/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.analysis.engine.databases;

import com.ibm.etools.analysis.engine.AnalysisEngineUtilities;
import com.ibm.etools.analysis.engine.Directive;
import com.ibm.etools.analysis.engine.ISymptomDatabase;
import com.ibm.etools.analysis.engine.Incident;
import com.ibm.etools.analysis.engine.Solution;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class DOMSSymptomDatabase
implements ISymptomDatabase {
    public static final String domsSymptomDatabaseCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable xmlSymptomDoms = new Hashtable();
    private String symptomDBPath = null;
    private final String SYMPTOMTAG = "symptom";
    private final String MATCHPATTERNTAG = "matchPattern";
    private final String SOLUTIONTAG = "solution";
    private final String DIRECTIVETAG = "directive";
    private final String SOLUTIONSATTRIBUTE = "solutions";
    private final String VALUEATTRIBUTE = "value";
    private final String DIRECTIVESATTRIBUTE = "directives";
    private final String IDATTRIBUTE = "id";
    private final String DESCRIPTIONATTRIBUTE = "description";
    private final String DIRECTIVESTRINGATTRIBUTE = "directiveString";

    public String getPath() {
        return this.symptomDBPath;
    }

    public boolean replace(String string) {
        this.symptomDBPath = string;
        if (this.symptomDBPath == null) {
            return this.unload();
        }
        return this.load();
    }

    public synchronized boolean load() {
        this.unload();
        return this.merge(this.symptomDBPath);
    }

    public synchronized boolean unload() {
        this.xmlSymptomDoms.clear();
        return true;
    }

    public synchronized boolean merge(String string) {
        Document document = this.getXmlDom(string);
        if (document == null) {
            return false;
        }
        this.xmlSymptomDoms.put(new File(string).getAbsolutePath(), document);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public Solution[] getSolutions(Incident var1_1) {
        block10: {
            var2_2 = new Vector<Solution>();
            if (this.xmlSymptomDoms.size() <= 0 || (var3_3 = var1_1.getMessageId()) == null || var3_3.trim().equals("")) break block10;
            var3_3 = var3_3.trim();
            var4_4 = var1_1.getRawData();
            var21_5 = this.xmlSymptomDoms.keys();
            while (var21_5.hasMoreElements()) {
                var5_6 = (Document)this.xmlSymptomDoms.get(var21_5.nextElement());
                var20_21 = var5_6.getElementsByTagName("symptom");
                var22_22 = 0;
                while (var22_22 < var20_21.getLength()) {
                    var6_7 = var20_21.item(var22_22);
                    var10_11 = AnalysisEngineUtilities.getDescendentNodes(var6_7, "matchPattern");
                    var16_17 = false;
                    var23_23 = 0;
                    while (var23_23 < var10_11.length) {
                        block12: {
                            block11: {
                                var13_14 = AnalysisEngineUtilities.getAttributeValue(var10_11[var23_23], "value");
                                if (var13_14 == null) ** GOTO lbl-1000
                                if (var3_3.indexOf(var13_14) == -1) break block11;
                                var16_17 = true;
                                break block12;
                            }
                            if (var4_4 == null) ** GOTO lbl-1000
                            var17_18 = 0;
                            while (var17_18 < var4_4.length) {
                                if (var4_4[var17_18] != null && var4_4[var17_18].indexOf(var13_14) != -1) break;
                                ++var17_18;
                            }
                            if (var17_18 < var4_4.length) {
                                var16_17 = true;
                            } else lbl-1000:
                            // 3 sources

                            {
                                var16_17 = false;
                                break;
                            }
                        }
                        ++var23_23;
                    }
                    if (var16_17 && (var14_15 = AnalysisEngineUtilities.getAttributeValue(var6_7, "solutions")) != null) {
                        var11_12 = new StringTokenizer(var14_15);
                        while (var11_12.hasMoreTokens()) {
                            var8_9 = AnalysisEngineUtilities.getElementById(var5_6, "solution", "id", var11_12.nextToken().trim());
                            var9_10 = null;
                            var15_16 = AnalysisEngineUtilities.getAttributeValue(var8_9, "directives");
                            if (var15_16 != null) {
                                var12_13 = new StringTokenizer(var15_16);
                                var18_19 = var12_13.countTokens();
                                var9_10 = new Directive[var18_19];
                                var24_24 = 0;
                                while (var24_24 < var18_19) {
                                    var7_8 = AnalysisEngineUtilities.getElementById(var5_6, "directive", "id", var12_13.nextToken().trim());
                                    var9_10[var24_24] = new Directive(AnalysisEngineUtilities.getAttributeValue(var7_8, "id"), AnalysisEngineUtilities.getAttributeValue(var7_8, "directiveString"), AnalysisEngineUtilities.getAttributeValue(var7_8, "description"));
                                    ++var24_24;
                                }
                            }
                            if (var2_2.contains(var19_20 = new Solution(AnalysisEngineUtilities.getAttributeValue(var8_9, "id"), AnalysisEngineUtilities.getAttributeValue(var8_9, "description"), var9_10))) continue;
                            var2_2.addElement(var19_20);
                        }
                    }
                    ++var22_22;
                }
            }
        }
        return var2_2.toArray(new Solution[var2_2.size()]);
    }

    public Directive[] getDirectives(Incident incident) {
        Vector<Directive> vector = new Vector<Directive>();
        Solution[] solutionArray = this.getSolutions(incident);
        int n = 0;
        while (n < solutionArray.length) {
            Directive[] directiveArray = solutionArray[n].getDirectives();
            if (directiveArray != null) {
                int n2 = 0;
                while (n2 < directiveArray.length) {
                    if (!vector.contains(directiveArray[n2])) {
                        vector.addElement(directiveArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector.toArray(new Directive[vector.size()]);
    }

    private Document getXmlDom(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            final File file = new File(string.trim());
            ErrorHandler errorHandler = new ErrorHandler(){

                public void error(SAXParseException sAXParseException) {
                    System.err.println("Error parsing XML file '" + file.getAbsolutePath() + "'.\nReason: " + sAXParseException.getMessage());
                }

                public void fatalError(SAXParseException sAXParseException) {
                    System.err.println("Fatal error parsing XML file '" + file.getAbsolutePath() + "'.\nReason: " + sAXParseException.getMessage());
                }

                public void warning(SAXParseException sAXParseException) {
                    System.err.println("Warning parsing XML file '" + file.getAbsolutePath() + "'.\nReason: " + sAXParseException.getMessage());
                }
            };
            documentBuilder.setErrorHandler(errorHandler);
            FileInputStream fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
            return documentBuilder.parse(fileInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

