/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.analysis.engine.databases;

import com.ibm.etools.analysis.engine.AnalysisEngineUtilities;
import com.ibm.etools.analysis.engine.Directive;
import com.ibm.etools.analysis.engine.ISymptomDatabase;
import com.ibm.etools.analysis.engine.Incident;
import com.ibm.etools.analysis.engine.Solution;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class WASDOMSymptomDatabase
implements ISymptomDatabase {
    public static final String wasDomSymptomDatabaseCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Document xmlSymptomDom = null;
    private String symptomDBPath = null;
    private final String SYMRECTAG = "symrec";
    private final String MATCHSYMPTOMTAG = "matchsymptomv";
    private final String SYMPTOMINFOTAG = "symptominfov";
    private final String RECORDIDATTRIBUTE = "recordid";
    private final String SYMPTOMTYPEATTRIBUTE = "symptomtype";
    private final String SYMPTOMSTATUSATTRIBUTE = "symptomstatus";

    public String getPath() {
        return this.symptomDBPath;
    }

    public boolean replace(String string) {
        this.symptomDBPath = string;
        if (this.symptomDBPath == null) {
            return this.unload();
        }
        return this.load();
    }

    public synchronized boolean load() {
        this.unload();
        this.xmlSymptomDom = this.getXmlDom(this.symptomDBPath);
        return this.xmlSymptomDom != null;
    }

    public synchronized boolean unload() {
        this.xmlSymptomDom = null;
        return true;
    }

    public synchronized boolean merge(String string) {
        Document document = this.getXmlDom(string);
        if (document == null) {
            return false;
        }
        if (this.xmlSymptomDom == null) {
            this.xmlSymptomDom = document;
        } else {
            NodeList nodeList = document.getElementsByTagName("symrec");
            if (nodeList.getLength() > 0) {
                if (this.xmlSymptomDom.getElementsByTagName("symrec").getLength() > 0) {
                    try {
                        Document document2 = (Document)this.xmlSymptomDom.cloneNode(true);
                        NodeList nodeList2 = document2.getElementsByTagName("symrec");
                        Node node = nodeList2.item(0).getParentNode();
                        int n = 0;
                        while (n < nodeList.getLength()) {
                            Node node2 = nodeList.item(n);
                            int n2 = 0;
                            while (n2 < nodeList2.getLength()) {
                                if (AnalysisEngineUtilities.equals(nodeList2.item(n2), node2, new String[]{"recordid", "symptomtype", "symptomstatus"})) break;
                                ++n2;
                            }
                            if (n2 == nodeList2.getLength()) {
                                node.appendChild(document2.importNode(node2, true));
                            }
                            ++n;
                        }
                        this.xmlSymptomDom = document2;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                } else {
                    this.xmlSymptomDom = document;
                }
            }
        }
        return true;
    }

    public Solution[] getSolutions(Incident incident) {
        String string;
        Vector<Solution> vector = new Vector<Solution>();
        if (this.xmlSymptomDom != null && (string = incident.getMessageId()) != null && !string.trim().equals("")) {
            NodeList nodeList = this.xmlSymptomDom.getElementsByTagName("symrec");
            String[] stringArray = incident.getRawData();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                StringTokenizer stringTokenizer = new StringTokenizer(AnalysisEngineUtilities.getDescendentNodeText(node, "matchsymptomv"), "\n\r\f");
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2 != null) {
                        if (string.indexOf(string2) != -1) {
                            bl = true;
                            continue;
                        }
                        if (stringArray != null) {
                            int n2 = 0;
                            while (n2 < stringArray.length) {
                                if (stringArray[n2] != null && stringArray[n2].indexOf(string2) != -1) break;
                                ++n2;
                            }
                            if (n2 < stringArray.length) {
                                bl = true;
                                continue;
                            }
                        }
                    }
                    bl = false;
                    break;
                }
                if (bl) {
                    vector.addElement(new Solution(null, AnalysisEngineUtilities.getDescendentNodeText(node, "symptominfov")));
                }
                ++n;
            }
        }
        return vector.toArray(new Solution[vector.size()]);
    }

    public Directive[] getDirectives(Incident incident) {
        Solution[] solutionArray = this.getSolutions(incident);
        Directive[] directiveArray = new Directive[solutionArray.length];
        int n = 0;
        while (n < solutionArray.length) {
            directiveArray[n] = new Directive(null, null, solutionArray[n].getDescription());
            ++n;
        }
        return directiveArray;
    }

    private Document getXmlDom(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            final File file = new File(string.trim());
            ErrorHandler errorHandler = new ErrorHandler(){

                public void error(SAXParseException sAXParseException) {
                    System.err.println("Error parsing XML file '" + file.getAbsolutePath() + "'.\nReason: " + sAXParseException.getMessage());
                }

                public void fatalError(SAXParseException sAXParseException) {
                    System.err.println("Fatal error parsing XML file '" + file.getAbsolutePath() + "'.\nReason: " + sAXParseException.getMessage());
                }

                public void warning(SAXParseException sAXParseException) {
                    System.err.println("Warning parsing XML file '" + file.getAbsolutePath() + "'.\nReason: " + sAXParseException.getMessage());
                }
            };
            documentBuilder.setErrorHandler(errorHandler);
            FileInputStream fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
            return documentBuilder.parse(fileInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

