/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.analysis.engine.databases.generators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SymptomDBGenerator {
    public static final String symptomDBGeneratorCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private int analysisFileTotalNum = 0;
    private int analysisFileParsedNum = 0;
    private File analysisFilesDir;
    private File symptomDBFile;
    private Hashtable analysisFilesDoms = new Hashtable();
    private static String SYMPTOMTAG = "symptom";
    private static String SOLUTIONTAG = "solution";
    private static String ACTIONTAG = "action";
    private static String MATCHTAG = "match";
    private static String DESCRIPTIONATTRIBUTE = "description";
    private static String NAMEATTRIBUTE = "name";
    private static String VALUEATTRIBUTE = "value";
    private static String IDATTRIBUTE = "id";
    private static String OPERATIONATTRIBUTE = "operation";
    private static String DATEATTRIBUTE = "date";
    private static String AUTHORATTRIBUTE = "author";
    private static String INDENTATION = "    ";
    private static String FILESEPARATOR = System.getProperty("file.separator");
    private static String LINESEPARATOR = System.getProperty("line.separator");

    private SymptomDBGenerator() {
    }

    public SymptomDBGenerator(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            System.err.println("ERROR - The analysis files directory path must be specified!");
            return;
        }
        if (string2 == null || string2.trim().length() == 0) {
            System.err.println("ERROR - The output symptom database directory path must be specified!");
            return;
        }
        this.analysisFilesDir = string.trim().endsWith("\"") ? new File(string.trim().substring(0, string.trim().length() - 1)) : new File(string);
        if (!this.analysisFilesDir.isDirectory()) {
            System.err.println("ERROR - The analysis files directory path must be a valid directory!");
            return;
        }
        this.symptomDBFile = string2.trim().endsWith("\"") ? new File(string2.trim().substring(0, string2.trim().length() - 1)) : new File(string2);
        try {
            if (!this.symptomDBFile.createNewFile()) {
                System.err.println("ERROR - The symptom database file currently exists!");
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR - The symptom database file could not be created!\nREASON - " + exception.getMessage());
            return;
        }
        this.parseAnalysisFilesDir(this.analysisFilesDir);
        this.createSymptomDatabase();
        System.out.println(this.analysisFileTotalNum + " analysis file(s) were found in '" + string + "' or a subdirectory.");
        System.out.println(this.analysisFileParsedNum + " analysis file(s) have been successfully converted to the XML symptom database '" + string2 + "'.");
    }

    private void createSymptomDatabase() {
        try {
            int n;
            Node node;
            int n2;
            Node[] nodeArray;
            Node node2;
            int n3;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
            Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
            Vector<Node> vector = new Vector<Node>();
            Vector<Node> vector2 = new Vector<Node>();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.symptomDBFile)));
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            printWriter.println();
            printWriter.println(this.getDTD());
            printWriter.println();
            printWriter.print("<!--  Created on ");
            printWriter.print(new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()));
            printWriter.println(" -->");
            printWriter.println();
            printWriter.println("<symptomDatabase>");
            printWriter.print(this.indent(1));
            printWriter.print("<runtime id=\"Runtime_0\" name=\"\" symptomUrl=\"\" localExternalFileLocation=\"");
            printWriter.print(this.normalize(this.symptomDBFile.getAbsolutePath()));
            printWriter.println("\">");
            printWriter.println();
            printWriter.print(this.indent(2));
            printWriter.println("<!-- Symptoms: -->");
            Enumeration enumeration = this.analysisFilesDoms.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                NodeList nodeList = ((Document)this.analysisFilesDoms.get(string)).getElementsByTagName(SYMPTOMTAG);
                n3 = 0;
                while (n3 < nodeList.getLength()) {
                    node2 = nodeList.item(n3);
                    printWriter.print(this.indent(2));
                    printWriter.print("<symptom id=\"");
                    String string2 = this.getAttributeValue(node2, IDATTRIBUTE);
                    if (string2 == null) {
                        throw new Exception("Attribute 'id' is required and must be specified for element type 'symptom' in '" + string + "'.");
                    }
                    if (hashtable.containsKey(string2)) {
                        int n4 = (Integer)hashtable.get(string2);
                        hashtable.put(string2, new Integer(++n4));
                        string2 = string2.concat("_").concat(String.valueOf(n4));
                    } else {
                        hashtable.put(string2, new Integer(-1));
                    }
                    printWriter.print(this.normalize(string2));
                    printWriter.print("\" description=\"");
                    printWriter.print(this.normalize(this.getAttributeValue(node2, DESCRIPTIONATTRIBUTE)));
                    nodeArray = this.getDescendentNodes(node2, SOLUTIONTAG);
                    if (nodeArray.length > 0) {
                        printWriter.print("\" solutions=\"");
                        hashtable4.clear();
                        n2 = 0;
                        while (n2 < nodeArray.length) {
                            String string3;
                            node = nodeArray[n2];
                            n = 0;
                            while (n < vector.size()) {
                                if (this.equals((Node)vector.elementAt(n), node, new String[]{IDATTRIBUTE})) break;
                                ++n;
                            }
                            if (n == vector.size()) {
                                string3 = this.getAttributeValue(node, IDATTRIBUTE);
                                if (string3 == null) {
                                    throw new Exception("Attribute 'id' is required and must be specified for element type 'solution' in '" + string + "'.");
                                }
                                if (hashtable2.containsKey(string3)) {
                                    int n5 = (Integer)hashtable2.get(string3);
                                    hashtable2.put(string3, new Integer(++n5));
                                    string3 = string3.concat("_").concat(String.valueOf(n5));
                                    node.getAttributes().getNamedItem(IDATTRIBUTE).setNodeValue(string3);
                                } else {
                                    hashtable2.put(string3, new Integer(-1));
                                }
                                vector.addElement(node);
                            } else {
                                string3 = this.getAttributeValue((Node)vector.elementAt(n), IDATTRIBUTE);
                            }
                            if (!hashtable4.containsKey(string3)) {
                                printWriter.print(this.normalize(string3));
                                hashtable4.put(string3, "");
                            }
                            if (n2 < nodeArray.length - 1) {
                                printWriter.print(" ");
                            }
                            ++n2;
                        }
                    }
                    printWriter.println("\">");
                    nodeArray = this.getDescendentNodes(node2, MATCHTAG);
                    n2 = 0;
                    while (n2 < nodeArray.length) {
                        node = nodeArray[n2];
                        printWriter.print(this.indent(3));
                        printWriter.write("<matchPattern name=\"");
                        printWriter.print(this.normalize(this.getAttributeValue(node, NAMEATTRIBUTE)));
                        printWriter.print("\" value=\"");
                        printWriter.print(this.normalize(this.getAttributeValue(node, VALUEATTRIBUTE)));
                        printWriter.println("\"/>");
                        ++n2;
                    }
                    printWriter.print(this.indent(2));
                    printWriter.println("</symptom>");
                    ++n3;
                }
            }
            printWriter.println();
            printWriter.print(this.indent(2));
            printWriter.println("<!-- Solutions: -->");
            n3 = 0;
            while (n3 < vector.size()) {
                node2 = (Node)vector.elementAt(n3);
                printWriter.print(this.indent(2));
                printWriter.print("<solution id=\"");
                printWriter.print(this.normalize(this.getAttributeValue(node2, IDATTRIBUTE)));
                printWriter.print("\" description=\"");
                printWriter.print(this.normalize(this.getAttributeValue(node2, DESCRIPTIONATTRIBUTE)));
                nodeArray = this.getDescendentNodes(node2, ACTIONTAG);
                if (nodeArray.length > 0) {
                    printWriter.print("\" directives=\"");
                    hashtable4.clear();
                    n2 = 0;
                    while (n2 < nodeArray.length) {
                        String string;
                        node = nodeArray[n2];
                        n = 0;
                        while (n < vector2.size()) {
                            if (this.equals((Node)vector2.elementAt(n), node, new String[]{IDATTRIBUTE})) break;
                            ++n;
                        }
                        if (n == vector2.size()) {
                            string = this.getAttributeValue(node, IDATTRIBUTE);
                            if (string == null) {
                                throw new Exception("Attribute 'id' is required and must be specified for element type 'action'.");
                            }
                            if (hashtable3.containsKey(string)) {
                                int n6 = (Integer)hashtable3.get(string);
                                hashtable3.put(string, new Integer(++n6));
                                string = string.concat("_").concat(String.valueOf(n6));
                                node.getAttributes().getNamedItem(IDATTRIBUTE).setNodeValue(string);
                            } else {
                                hashtable3.put(string, new Integer(-1));
                            }
                            vector2.addElement(node);
                        } else {
                            string = this.getAttributeValue((Node)vector2.elementAt(n), IDATTRIBUTE);
                        }
                        if (!hashtable4.containsKey(string)) {
                            printWriter.print(this.normalize(string));
                            hashtable4.put(string, "");
                        }
                        if (n2 < nodeArray.length - 1) {
                            printWriter.print(" ");
                        }
                        ++n2;
                    }
                }
                printWriter.println("\"/>");
                ++n3;
            }
            printWriter.println();
            printWriter.print(this.indent(2));
            printWriter.println("<!-- Directives: -->");
            n2 = 0;
            while (n2 < vector2.size()) {
                node2 = (Node)vector2.elementAt(n2);
                printWriter.print(this.indent(2));
                printWriter.print("<directive id=\"");
                printWriter.print(this.normalize(this.getAttributeValue(node2, IDATTRIBUTE)));
                printWriter.print("\" description=\"");
                printWriter.print(this.normalize(this.getAttributeValue(node2, DESCRIPTIONATTRIBUTE)));
                printWriter.print("\" directiveString=\"");
                printWriter.print(this.normalize(this.getAttributeValue(node2, OPERATIONATTRIBUTE)));
                printWriter.println("\"/>");
                ++n2;
            }
            printWriter.print(this.indent(1));
            printWriter.println("</runtime>");
            printWriter.print("</symptomDatabase>");
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR - The symptom database file '" + this.symptomDBFile.getAbsolutePath() + "' could not be created!\nREASON - " + exception.getMessage());
            this.symptomDBFile.deleteOnExit();
            return;
        }
    }

    private void parseAnalysisFilesDir(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                this.parseAnalysisFilesDir(fileArray[n]);
            } else {
                this.parseAnalysisFile(fileArray[n]);
            }
            ++n;
        }
    }

    private void parseAnalysisFile(File file) {
        ++this.analysisFileTotalNum;
        Document document = this.getXmlDom(file);
        if (document != null) {
            Enumeration enumeration = this.analysisFilesDoms.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.equals((Document)this.analysisFilesDoms.get(string), document, new String[]{IDATTRIBUTE, AUTHORATTRIBUTE, DATEATTRIBUTE})) continue;
                System.err.println("ERROR - The XML analysis file '" + file.getAbsolutePath() + "' is equivalent to '" + string + "' and will NOT be duplicated!");
                return;
            }
        } else {
            System.err.println("ERROR - The XML analysis file '" + file.getAbsolutePath() + "' could not be parsed!");
            return;
        }
        this.analysisFilesDoms.put(file.getAbsolutePath(), document);
        ++this.analysisFileParsedNum;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            new SymptomDBGenerator(stringArray[0], stringArray[1]);
        } else {
            SymptomDBGenerator.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("");
        System.out.println("SymptomDBGenerator:       \tRecursively converts XML analysis files to a XML symptom database.");
        System.out.println("");
        System.out.println("Usage:                    \tjava.exe -classpath <XML4J 3.2.x or higher JAR path> SymptomDBGenerator <analysisFilesDirectory> <symptomDatabaseFilePath>");
        System.out.println("");
        System.out.println("<analysisFilesDirectory>  \tThe absolute directory path which is recursively iterated for analysis files.");
        System.out.println("");
        System.out.println("<symptomDatabaseFilePath> \tThe absolute file path where the symptom database is saved.");
        System.out.println("");
        System.out.println("NOTE: Enclose paths with spaces in double quotes and remove trailing slashes from directory paths.");
        System.out.println("");
    }

    private Document getXmlDom(File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getAttributeValue(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string.trim()).getNodeValue().trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Node[] getDescendentNodes(Node node, String string) {
        String string2;
        Vector<Node> vector = new Vector<Node>();
        if (string != null && node != null && node.hasChildNodes() && !(string2 = string.trim()).equals("")) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeName().trim().equals(string2)) {
                    vector.addElement(node2);
                }
                vector.addAll(Arrays.asList(this.getDescendentNodes(node2, string)));
                ++n;
            }
        }
        return vector.toArray(new Node[vector.size()]);
    }

    private String normalize(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private boolean equals(Node node, Node node2) {
        return this.equals(node, node2, new String[0]);
    }

    private boolean equals(Node node, Node node2, String[] stringArray) {
        int n;
        Node node3;
        int n2;
        boolean[] blArray;
        Object object;
        Object object2;
        if (node == null && node2 == null) {
            return true;
        }
        if (node == null || node2 == null) {
            return false;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!node.getNodeName().trim().equals(node2.getNodeName().trim())) {
            return false;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null && node.getNodeName().trim().equals(stringArray[n3].trim())) {
                return true;
            }
            ++n3;
        }
        String string = node.getNodeValue();
        String string2 = node2.getNodeValue();
        if (string != null && string2 != null ? !string.trim().equals(string2.trim()) : string != null || string2 != null) {
            return false;
        }
        if (node.hasAttributes() && node2.hasAttributes()) {
            object2 = node.getAttributes();
            object = node2.getAttributes();
            if (object2.getLength() != object.getLength()) {
                return false;
            }
            blArray = new boolean[object.getLength()];
            n2 = 0;
            while (n2 < object2.getLength()) {
                node3 = object2.item(n2);
                n = 0;
                while (n < object.getLength()) {
                    if (!blArray[n] && this.equals(node3, object.item(n), stringArray)) {
                        blArray[n] = true;
                        break;
                    }
                    ++n;
                }
                if (n == object.getLength()) {
                    return false;
                }
                ++n2;
            }
        } else if (node.hasAttributes() || node2.hasAttributes()) {
            return false;
        }
        if (node.hasChildNodes() && node2.hasChildNodes()) {
            object2 = node.getChildNodes();
            object = node2.getChildNodes();
            if (object2.getLength() != object.getLength()) {
                return false;
            }
            blArray = new boolean[object.getLength()];
            n2 = 0;
            while (n2 < object2.getLength()) {
                node3 = object2.item(n2);
                n = 0;
                while (n < object.getLength()) {
                    if (!blArray[n] && this.equals(node3, object.item(n), stringArray)) {
                        blArray[n] = true;
                        break;
                    }
                    ++n;
                }
                if (n == object.getLength()) {
                    return false;
                }
                ++n2;
            }
        } else if (node.hasChildNodes() || node2.hasChildNodes()) {
            return false;
        }
        return true;
    }

    private String indent(int n) {
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return INDENTATION;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(INDENTATION);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String getDTD() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE symptomDatabase [");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT symptomDatabase (runtime+)>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST symptomDatabase>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT runtime (symptom+ , solution+ , directive*)>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST runtime");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("name CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("symptomUrl CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("localExternalFileLocation CDATA #IMPLIED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT symptom (matchPattern+)>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST symptom");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("solutions IDREFS #REQUIRED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT matchPattern EMPTY>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST matchPattern");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("name CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("value CDATA #REQUIRED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT solution EMPTY>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST solution");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("directives IDREFS #IMPLIED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT directive EMPTY>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST directive");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("directiveString CDATA #REQUIRED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("]>");
        return stringBuffer.toString();
    }
}

