/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.analysis.engine.databases.generators;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class XMLAnalysisFilesGenerator {
    public static final String xmlAnalysisFilesGeneratorCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private int analysisFileTotalNum = 0;
    private int analysisFileParsedNum = 0;
    private int symptomIdNum = 0;
    private int solutionIdNum = 0;
    private File analysisFilesDir;
    private File xmlAnalysisFilesDir;
    private static String RECORDDELIMITER = "-";
    private static String SYMPTOMDEMILTER = "\"";
    private static String SYMPTOMNOTDEMILTER = "!\"";
    private static String COMMENTCHARACTER = "#";
    private static String INDENTATION = "    ";
    private static String FILESEPARATOR = System.getProperty("file.separator");
    private static String LINESEPARATOR = System.getProperty("line.separator");
    private static String TWOSPACES = "  ";

    private XMLAnalysisFilesGenerator() {
    }

    public XMLAnalysisFilesGenerator(String string) {
        this(string, string);
    }

    public XMLAnalysisFilesGenerator(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            System.err.println("ERROR - The analysis files directory path must be specified!");
            return;
        }
        if (string2 == null || string2.trim().length() == 0) {
            System.err.println("ERROR - The output XML analysis files directory path must be specified!");
            return;
        }
        this.analysisFilesDir = string.trim().endsWith("\"") ? new File(string.trim().substring(0, string.trim().length() - 1)) : new File(string);
        if (!this.analysisFilesDir.isDirectory()) {
            System.err.println("ERROR - The analysis files directory path must be a valid directory!");
            return;
        }
        this.xmlAnalysisFilesDir = string2.trim().endsWith("\"") ? new File(string2.trim().substring(0, string2.trim().length() - 1)) : new File(string2);
        if (!this.xmlAnalysisFilesDir.isDirectory() && !this.xmlAnalysisFilesDir.mkdirs()) {
            System.err.println("ERROR - The output XML analysis files directory could not be created.\nThe output XML analysis files directory path must be a valid directory!");
            return;
        }
        this.parseAnalysisFilesDir(this.analysisFilesDir);
        System.out.println(this.analysisFileTotalNum + " analysis file(s) were found in '" + string + "' or a subdirectory.");
        System.out.println(this.analysisFileParsedNum + " analysis file(s) have been successfully converted to XML in '" + string2 + "' or a subdirectory.");
    }

    private void parseAnalysisFilesDir(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                this.parseAnalysisFilesDir(fileArray[n]);
            } else {
                this.parseAnalysisFile(fileArray[n]);
            }
            ++n;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseAnalysisFile(File file) {
        try {
            String string;
            PrintWriter printWriter;
            BufferedReader bufferedReader;
            block24: {
                block23: {
                    ++this.analysisFileTotalNum;
                    String string2 = file.getName();
                    if (string2.indexOf(46) != -1) {
                        string2 = string2.substring(0, string2.lastIndexOf(46));
                    }
                    String string3 = string2.concat(".xml");
                    String string4 = file.getParent().substring(this.analysisFilesDir.getAbsolutePath().length());
                    string4 = this.xmlAnalysisFilesDir.getAbsolutePath().concat(string4);
                    new File(string4).mkdirs();
                    File file2 = new File(string4.concat(FILESEPARATOR).concat(string3));
                    try {
                        if (!file2.createNewFile()) {
                            System.err.println("ERROR - The XML analysis file '" + file2.getAbsolutePath() + "' currently exists!");
                            return;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("ERROR - The XML analysis file '" + file2.getAbsolutePath() + "' could not be created!\nREASON - " + exception.toString());
                        return;
                    }
                    bufferedReader = new BufferedReader(new FileReader(file));
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
                    printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                    printWriter.println();
                    printWriter.println(this.getDTD());
                    printWriter.println();
                    printWriter.print("<!--  Created on ");
                    printWriter.print(new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()));
                    printWriter.println(" -->");
                    printWriter.println();
                    printWriter.print("<analysis description=\"\" author=\"\" date=\"");
                    try {
                        printWriter.print(this.normalize(DateFormat.getInstance().format(new Date(file.lastModified()))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    printWriter.println("\">");
                    printWriter.print(this.indent(1));
                    printWriter.print("<symptom id=\"Symptom_");
                    printWriter.print(this.symptomIdNum);
                    printWriter.println("\" description=\"\">");
                    printWriter.print(this.indent(2));
                    printWriter.println("<pattern description=\"\">");
                    if (!true) break block23;
                    string = bufferedReader.readLine();
                    if (string == null || (string = string.trim()).startsWith(RECORDDELIMITER)) break block24;
                }
                do {
                    if (string.startsWith(SYMPTOMDEMILTER) && string.endsWith(SYMPTOMDEMILTER)) {
                        printWriter.print(this.indent(3));
                        printWriter.print("<match name=\"\" value=\"");
                        printWriter.print(this.normalize(string.substring(1, string.length() - 1)));
                        printWriter.println("\"/>");
                    } else if (string.startsWith(SYMPTOMNOTDEMILTER) && string.endsWith(SYMPTOMDEMILTER)) {
                        printWriter.print(this.indent(3));
                        printWriter.print("<match name=\"NOT\" value=\"");
                        printWriter.print(this.normalize(string.substring(2, string.length() - 1)));
                        printWriter.println("\"/>");
                    } else if (string.startsWith(COMMENTCHARACTER)) {
                        printWriter.print(this.indent(3));
                        printWriter.print("<!-- ");
                        printWriter.print(string.substring(1).trim());
                        printWriter.println(" -->");
                    } else {
                        System.err.println("ERROR - Line '" + string + "' of the analysis file '" + file.getAbsolutePath() + "' is invalid!");
                    }
                    string = bufferedReader.readLine();
                } while (string != null && !(string = string.trim()).startsWith(RECORDDELIMITER));
            }
            printWriter.print(this.indent(2));
            printWriter.println("</pattern>");
            if (new StringTokenizer(string, RECORDDELIMITER).countTokens() > 0) {
                System.err.println("ERROR - Line '" + string + "' of the analysis file '" + file.getAbsolutePath() + "' contains data (i.e. record status) in the separator line that has not been persisted!");
            }
            while ((string = bufferedReader.readLine()) != null && (string = string.trim()).startsWith(RECORDDELIMITER)) {
                System.err.println("ERROR - Line '" + string + "' of the analysis file '" + file.getAbsolutePath() + "' contains a duplicate separator line that has not been persisted!");
                if (new StringTokenizer(string, RECORDDELIMITER).countTokens() <= 0) continue;
                System.err.println("ERROR - Line '" + string + "' of the analysis file '" + file.getAbsolutePath() + "' contains data (i.e. record status) in a duplicate separator line that has not been persisted!");
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (string != null) {
                if ((string = string.trim()).startsWith(COMMENTCHARACTER)) {
                    printWriter.print(this.indent(2));
                    printWriter.print("<!-- ");
                    printWriter.print(string.substring(1).trim());
                    printWriter.println(" -->");
                } else if (string.length() > 0) {
                    stringBuffer.append(TWOSPACES);
                    stringBuffer.append(this.normalize(string));
                }
                string = bufferedReader.readLine();
            }
            printWriter.print(this.indent(2));
            printWriter.print("<solution id=\"Solution_");
            printWriter.print(this.solutionIdNum);
            printWriter.print("\" description=\"");
            printWriter.print(stringBuffer.toString().trim());
            printWriter.println("\"/>");
            printWriter.print(this.indent(1));
            printWriter.println("</symptom>");
            printWriter.println("</analysis>");
            if (printWriter.checkError()) {
                System.err.println("ERROR - The creation of the analysis file '" + file.getAbsolutePath() + "' has been corrupted!");
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR - The analysis file '" + file.getAbsolutePath() + "' could not be converted to XML!\nREASON - " + exception.toString());
            file.deleteOnExit();
            return;
        }
        ++this.symptomIdNum;
        ++this.solutionIdNum;
        ++this.analysisFileParsedNum;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            new XMLAnalysisFilesGenerator(stringArray[0]);
        } else if (stringArray.length == 2) {
            new XMLAnalysisFilesGenerator(stringArray[0], stringArray[1]);
        } else {
            XMLAnalysisFilesGenerator.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("");
        System.out.println("XMLAnalysisFilesGenerator: \tRecursively converts analysis files to their equivalent XML format.");
        System.out.println("");
        System.out.println("Usage:                     \tjava.exe XMLAnalysisFilesGenerator <analysisFilesDirectory> [xmlAnalysisFilesDirectory]");
        System.out.println("");
        System.out.println("<analysisFilesDirectory>   \tThe absolute directory path which is recursively iterated for analysis files.");
        System.out.println("");
        System.out.println("[xmlAnalysisFilesDirectory]\tThe absolute directory path which converted XML analysis files are saved.  If this absolute directory path is not specified, XML analysis files are saved in the same absolute directory as the original.");
        System.out.println("");
        System.out.println("NOTE: Enclose paths with spaces in double quotes and remove trailing slashes from directory paths.");
        System.out.println("");
    }

    private String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private String indent(int n) {
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return INDENTATION;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(INDENTATION);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String getDTD() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE analysis [");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT analysis (symptom)>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST analysis");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("author CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("date CDATA #IMPLIED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT symptom (pattern+ , solution+)>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST symptom");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT pattern (match+)>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST pattern");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT match EMPTY>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST match");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("name CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("value CDATA #REQUIRED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT solution (action*) >");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST solution");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #REQUIRED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ELEMENT action EMPTY>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("<!ATTLIST action");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("id ID #REQUIRED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("description CDATA #IMPLIED");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append(this.indent(1));
        stringBuffer.append("operation CDATA #REQUIRED>");
        stringBuffer.append(LINESEPARATOR);
        stringBuffer.append("]>");
        return stringBuffer.toString();
    }
}

