/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.analysis.engine.engines;

import com.ibm.etools.analysis.engine.Directive;
import com.ibm.etools.analysis.engine.IAnalysisEngine;
import com.ibm.etools.analysis.engine.Incident;
import com.ibm.etools.analysis.engine.Solution;
import com.ibm.etools.analysis.engine.databases.DOMSSymptomDatabase;

public final class FFDCAnalysisEngine
implements IAnalysisEngine {
    public static final String ffdcAnalysisEngineCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private DOMSSymptomDatabase symptomDatabase = null;

    private FFDCAnalysisEngine() {
    }

    private FFDCAnalysisEngine(String string) {
        this.symptomDatabase = new DOMSSymptomDatabase();
        this.replaceSymptomDatabase(string);
    }

    public static FFDCAnalysisEngine getInstance() {
        return new FFDCAnalysisEngine(null);
    }

    public static FFDCAnalysisEngine getInstance(String string) {
        return new FFDCAnalysisEngine(string);
    }

    public synchronized boolean reloadSymptomDatabase() {
        return this.symptomDatabase.load();
    }

    public synchronized boolean mergeSymptomDatabase(String string) {
        return this.symptomDatabase.merge(string);
    }

    public synchronized boolean removeSymptomDatabase() {
        return this.symptomDatabase.replace(null);
    }

    public synchronized boolean replaceSymptomDatabase(String string) {
        if (string != null && !string.trim().equals("")) {
            this.symptomDatabase.replace(string);
            return this.symptomDatabase.load();
        }
        return false;
    }

    public synchronized String getSymptomDatabasePath() {
        if (this.symptomDatabase != null) {
            return this.symptomDatabase.getPath();
        }
        return null;
    }

    public synchronized Directive[] analyze(Incident incident) {
        return this.symptomDatabase.getDirectives(incident);
    }

    public Solution[] analyzeForSolutions(Incident incident) {
        return this.symptomDatabase.getSolutions(incident);
    }
}

