/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.command;

import com.ibm.etools.environment.command.AbstractCommand;
import com.ibm.etools.environment.command.Command;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.Status;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class MultiCommand
extends AbstractCommand {
    protected String name = null;
    protected String description = null;
    private List commands_ = new LinkedList();
    private Command[] commandsArray_ = null;

    public MultiCommand() {
    }

    public MultiCommand(String string, String string2) {
        super(string, string2);
    }

    public MultiCommand(String string, String string2, Command[] commandArray) {
        super(string, string2);
        this.commands_.addAll((Collection)Arrays.asList(commandArray));
    }

    public void add(Command command) {
        this.commandsArray_ = null;
        this.commands_.add(command);
    }

    public String getName() {
        return this.name != null ? this.name : (this.commands_.size() > 0 ? ((Command)this.commands_.get(0)).getName() : null);
    }

    public String getDescription() {
        return this.description != null ? this.description : (this.commands_.size() > 0 ? ((Command)this.commands_.get(0)).getDescription() : null);
    }

    public Status execute(Environment environment) {
        Status status = null;
        Command[] commandArray = this.commandsArray();
        int n = 0;
        while (n < commandArray.length) {
            status = commandArray[n].execute(environment);
            if (status != null && status.matches(4)) {
                --n;
                while (n >= 0) {
                    commandArray[n].undo(environment);
                    --n;
                }
                return status;
            }
            ++n;
        }
        return status;
    }

    public Status undo(Environment environment) {
        Status status = null;
        ListIterator listIterator = this.commands_.listIterator();
        while (listIterator.hasPrevious()) {
            status = ((Command)listIterator.previous()).undo(environment);
        }
        return status;
    }

    public boolean isUndoable() {
        ListIterator listIterator = this.commands_.listIterator();
        while (listIterator.hasPrevious()) {
            if (((Command)listIterator.previous()).isUndoable()) continue;
            return false;
        }
        return true;
    }

    public Status redo(Environment environment) {
        Status status = null;
        Command[] commandArray = this.commandsArray();
        int n = 0;
        while (n < commandArray.length) {
            status = commandArray[n].redo(environment);
            if (status != null && status.matches(4)) {
                --n;
                while (n >= 0) {
                    commandArray[n].undo(environment);
                    --n;
                }
                return status;
            }
            ++n;
        }
        return status;
    }

    private Command[] commandsArray() {
        if (this.commandsArray_ == null) {
            this.commandsArray_ = this.commands_.toArray(new Command[0]);
        }
        return this.commandsArray_;
    }
}

