/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.commandline;

import com.ibm.etools.environment.common.StringUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.ResourceBundle;
import java.util.Vector;

public class CommandLine {
    public static final String REQUIRED = "required";
    public static final String OPTIONAL = "optional";
    public static final String DUPS_OK = "dups_ok";
    public static final String NO_DUPS = "no_dups";
    public static final String POSITIONAL = "";
    public static final String NO_PARM = "";
    private static final int FLAG_COL = 0;
    private static final int NAME_COL = 1;
    private static final int DUP_COL = 2;
    private static final int REQUIRED_COL = 3;
    private static final int HELP_COL = 4;
    private static final int POSITIONAL_ROW = 0;
    private static final int HELP_LINE_LEN = 75;
    private String[][] flags_info;
    private String help_flag;
    private String tool_name;
    private Vector[] flags_specified;
    private int required_positionals;
    private boolean optional_positionals_allowed;
    private int optional_list_index;
    private int max_flag_size;
    private int max_name_size;
    protected ResourceBundle messages;
    private ResourceBundle flagMessages;

    public CommandLine(String[][] stringArray, String string, String string2, ResourceBundle resourceBundle) throws InternalErrorExc {
        this.flags_info = stringArray;
        this.help_flag = string;
        this.tool_name = string2;
        this.flagMessages = resourceBundle;
        this.messages = ResourceBundle.getBundle("com.ibm.etools.environment.commandline.commandline");
        this.verify_flags_info();
    }

    public void check_flags(String[] stringArray) throws Flag_error {
        this.flags_specified = new Vector[this.flags_info.length];
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = this.process_arg(stringArray, n);
            if (bl) {
                ++n;
            }
            ++n;
        }
        if (!this.flag_specified(this.help_flag)) {
            this.check_rules();
            this.more_processing();
        }
    }

    protected void more_processing() throws Flag_error, InternalErrorExc {
    }

    public String[] get_flag_parms(String string) {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.flags_info.length) {
            if (this.flags_info[n][0].equals(string)) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            Vector vector = this.flags_specified[n];
            return vector == null ? null : vector.toArray(new String[0]);
        }
        return null;
    }

    public String[] get_positionals() {
        return this.flags_specified[0].toArray(new String[0]);
    }

    public boolean flag_specified(String string) {
        return this.get_flag_parms(string) != null;
    }

    public String get_help_text() {
        StringBuffer stringBuffer = new StringBuffer(400);
        int n = 72 - this.max_flag_size - 1 - this.max_name_size - 1;
        stringBuffer.append(String.valueOf(this.messages.getString("PARSER_SYNTAX")) + ": " + this.tool_name + " ");
        int n2 = 0;
        while (n2 < this.required_positionals) {
            stringBuffer.append(String.valueOf(this.flagMessages.getString(this.flags_info[n2][1])) + " ");
            ++n2;
        }
        stringBuffer.append("[" + this.messages.getString("PARSER_FLAGS") + "] ");
        if (this.optional_positionals_allowed) {
            stringBuffer.append(this.flagMessages.getString(this.flags_info[this.optional_list_index][1]));
        }
        stringBuffer.append("\n  " + this.messages.getString("PARSER_WHERE") + "\n");
        n2 = 0;
        while (n2 < this.flags_info.length) {
            String string = this.flags_info[n2][1];
            String string2 = string == "" ? "" : this.flagMessages.getString(string);
            String string3 = this.flags_info[n2][0];
            String string4 = string3 == "" ? "" : this.flagMessages.getString(string3);
            int n3 = this.max_flag_size - string4.length();
            int n4 = this.max_name_size - string2.length();
            if (this.flags_info[n2][0] != "" || this.flags_info[n2][1] != "") {
                if (string4 == "") {
                    stringBuffer.append(this.getBlanks(3));
                } else {
                    stringBuffer.append("  -" + string4);
                }
                stringBuffer.append(this.getBlanks(n3 + 1));
                stringBuffer.append(string2);
                stringBuffer.append(this.getBlanks(n4 + 1));
                String string5 = this.flagMessages.getString(this.flags_info[n2][4]);
                String[] stringArray = StringUtils.splitter(string5, n);
                if (stringArray.length > 0) {
                    stringBuffer.append(String.valueOf(stringArray[0]) + "\n");
                } else {
                    stringBuffer.append("\n");
                }
                int n5 = 1;
                while (n5 < stringArray.length) {
                    stringBuffer.append(this.getBlanks(75 - n));
                    stringBuffer.append(String.valueOf(stringArray[n5]) + "\n");
                    ++n5;
                }
                stringBuffer.append("\n");
            }
            ++n2;
        }
        return "" + stringBuffer;
    }

    private String getBlanks(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, 0, n, ' ');
        return new String(cArray);
    }

    private boolean process_arg(String[] stringArray, int n) throws Flag_error {
        boolean bl = false;
        if (stringArray[n].charAt(0) == '-') {
            int n2 = 1;
            int n3 = this.get_info_index(stringArray[n], n2);
            int n4 = this.get_max_index(stringArray[n], n2, n3);
            if (this.flags_info[n3][1] != "") {
                if (n4 < stringArray[n].length()) {
                    this.add_flag_parm(n3, stringArray[n].substring(n4, stringArray[n].length()));
                } else if (n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-') {
                    this.add_flag_parm(n3, stringArray[n + 1]);
                    bl = true;
                } else {
                    this.add_flag_parm(n3, null);
                }
            } else {
                this.add_flag_parm(n3, null);
                if (n4 < stringArray[n].length()) {
                    this.add_positional(stringArray[n].substring(n4, stringArray[n].length()));
                }
            }
        } else {
            this.add_positional(stringArray[n]);
        }
        return bl;
    }

    private int get_info_index(String string, int n) throws Flag_error {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        BitSet bitSet = new BitSet();
        int n5 = n;
        while (n5 < string.length()) {
            int n6 = 0;
            while (n6 < this.flags_info.length) {
                String string2;
                String string3 = this.flags_info[n6][0];
                String string4 = string2 = string3 == "" ? "" : this.flagMessages.getString(string3);
                if (!bitSet.get(n6) && n3 < string2.length() && Character.toLowerCase(string.charAt(n5)) == string2.charAt(n3)) {
                    ++n2;
                    n4 = n6;
                } else {
                    bitSet.set(n6);
                }
                ++n6;
            }
            if (n2 == 1) {
                return n4;
            }
            if (n2 == 0) {
                throw new Flag_error(this.messages.getString("PARSER_ERROR_FLAG_NOT_FOUND"), string.substring(n));
            }
            ++n3;
            n2 = 0;
            ++n5;
        }
        throw new Flag_error(this.messages.getString("PARSER_ERROR_AMBIGUOUS_FLAG"), string.substring(n));
    }

    private int get_max_index(String string, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        String string2 = this.flagMessages.getString(this.flags_info[n2][0]);
        while (n3 < string.length() && n4 < string2.length()) {
            if (Character.toLowerCase(string.charAt(n3)) != string2.charAt(n4)) break;
            ++n3;
            ++n4;
        }
        return n3;
    }

    private void add_positional(String string) {
        if (this.flags_specified[0] == null) {
            this.flags_specified[0] = new Vector(3);
        }
        this.flags_specified[0].add(string);
    }

    private void add_flag_parm(int n, String string) throws Flag_error {
        if (this.flags_info[n][2] == NO_DUPS && this.flags_specified[n] != null) {
            throw new Flag_error(this.messages.getString("PARSER_ERROR_DUPLICATE_FLAGS_NOT_ALLOWED"), this.flagMessages.getString(this.flags_info[n][0]));
        }
        if (this.flags_specified[n] == null) {
            this.flags_specified[n] = new Vector(3);
        }
        this.flags_specified[n].add(string);
    }

    private void check_rules() throws Flag_error {
        int n = 0;
        if (this.flags_specified[0] != null) {
            n = this.flags_specified[0].size();
        }
        if (this.required_positionals > n) {
            throw new Flag_error(this.messages.getString("PARSER_ERROR_MISSING_POSITIONAL"), this.flagMessages.getString(this.flags_info[this.required_positionals - 1][1]));
        }
        if (this.required_positionals < n && !this.optional_positionals_allowed) {
            throw new Flag_error(this.messages.getString("PARSER_ERROR_TOO_MANY_POSITIONALS"));
        }
        int n2 = 0;
        while (n2 < this.flags_info.length) {
            if (this.flags_info[n2][0] != "") {
                if (this.flags_specified[n2] == null && this.flags_info[n2][3] == REQUIRED) {
                    throw new Flag_error(this.messages.getString("PARSER_ERROR_MISSING_REQUIRED_FLAG"), this.flagMessages.getString(this.flags_info[n2][0]));
                }
                int n3 = 0;
                if (this.flags_specified[n2] != null) {
                    n3 = this.flags_specified[n2].size();
                }
                if (this.flags_info[n2][2] == NO_DUPS && n3 > 1) {
                    throw new Flag_error(this.messages.getString("PARSER_ERROR_DUPLICATE_FLAGS_NOT_ALLOWED"), this.flagMessages.getString(this.flags_info[n2][0]));
                }
                if (n3 > 0 && this.flags_info[n2][1] != "") {
                    int n4 = 0;
                    while (n4 < this.flags_specified[n2].size()) {
                        if (this.flags_specified[n2].elementAt(n4) == null) {
                            throw new Flag_error(this.messages.getString("PARSER_ERROR_MISSING_FLAG_PARAMETER"), new String[]{this.flagMessages.getString(this.flags_info[n2][0]), this.flagMessages.getString(this.flags_info[n2][1])});
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private void verify_flags_info() throws InternalErrorExc {
        boolean bl = false;
        boolean bl2 = false;
        this.required_positionals = 0;
        this.optional_positionals_allowed = false;
        this.optional_list_index = -1;
        this.max_flag_size = 0;
        this.max_name_size = 0;
        if (this.flags_info == null || this.flags_info.length == 0) {
            throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_NO_FLAGS_DATA_SPECIFIED"));
        }
        if (this.flags_info[0] != null && this.flags_info[0].length > 0 && this.flags_info[0][0] != "") {
            throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_FIRST_FLAG_NOT_POSITIONAL"));
        }
        int n = 0;
        while (n < this.flags_info.length) {
            String string;
            if (this.flags_info[n] == null) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_NULL_FLAG_ROW"));
            }
            if (this.flags_info[n].length != 5) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_INCORRECT_ROW_SIZE"));
            }
            if (this.flags_info[n][0] == null || this.flags_info[n][1] == null || this.flags_info[n][4] == null) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_NULL_IN_ROW"));
            }
            if (this.flags_info[n][0].equals(this.help_flag)) {
                bl2 = true;
            }
            String string2 = this.flags_info[n][0];
            String string3 = this.flags_info[n][1];
            String string4 = string2 == "" ? "" : this.flagMessages.getString(string2);
            String string5 = string = string3 == "" ? "" : this.flagMessages.getString(string3);
            if (string4.length() > this.max_flag_size) {
                this.max_flag_size = string4.length();
            }
            if (string != "" && string.length() > this.max_name_size) {
                this.max_name_size = string.length();
            }
            if (!string4.equals(string4.toLowerCase())) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_FLAG_NOT_LOWERCASE"), string4);
            }
            if (this.flags_info[n][2] == null || this.flags_info[n][2] != NO_DUPS && this.flags_info[n][2] != DUPS_OK) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_INCORRECT_DUP_STRING"), this.flags_info[n][2]);
            }
            if (this.flags_info[n][3] == null || this.flags_info[n][3] != REQUIRED && this.flags_info[n][3] != OPTIONAL) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_INCORRECT_REQUIRED_STRING"), this.flags_info[n][3]);
            }
            if (this.flags_info[n][0] == "") {
                if (this.flags_info[n][3] == REQUIRED) {
                    if (this.flags_info[n][1] == "") {
                        throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_REQUIRED_POSITIONAL_NEEDS_NAME"));
                    }
                    ++this.required_positionals;
                } else if (this.flags_info[n][1] != "") {
                    this.optional_positionals_allowed = true;
                    this.optional_list_index = n;
                }
            }
            if (this.flags_info[n][0] != "" || !bl && this.flags_info[n][0] == "" && this.flags_info[n][3] == OPTIONAL) {
                bl = true;
            } else if (bl) {
                throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_POSITIONAL_NOT_AT_BEGINNING"));
            }
            ++n;
        }
        if (!bl2) {
            throw new InternalErrorExc(this.messages.getString("PARSER_ERROR_HELP_FLAG_NOT_SPECIFIED"));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < this.flags_info.length) {
            stringBuffer.append("\n");
            if (this.flags_info[n][0] == "") {
                stringBuffer.append("Positional:");
            } else {
                stringBuffer.append(String.valueOf(this.flagMessages.getString(this.flags_info[n][0])) + ":");
            }
            if (this.flags_specified[n] == null) {
                stringBuffer.append("no parameters");
            } else {
                int n2 = 0;
                while (n2 < this.flags_specified[n].size()) {
                    String string = (String)this.flags_specified[n].elementAt(n2);
                    stringBuffer.append(String.valueOf(string) + ":");
                    ++n2;
                }
            }
            stringBuffer.append("\n");
            ++n;
        }
        return "" + stringBuffer;
    }

    public static class ErrorExc
    extends Exception {
        private static final long serialVersionUID = 3361118884608853686L;

        public ErrorExc(String string, String[] stringArray) {
            super(MessageFormat.format(string, stringArray));
        }
    }

    public static class InternalErrorExc
    extends IllegalArgumentException {
        private static final long serialVersionUID = -624868801682175750L;

        public InternalErrorExc(String string, String[] stringArray) {
            super(MessageFormat.format(string, stringArray));
        }

        public InternalErrorExc(String string) {
            this(string, (String[])null);
        }

        public InternalErrorExc(String string, String string2) {
            this(string, new String[]{string2});
        }
    }

    public static class Flag_error
    extends ErrorExc {
        private static final long serialVersionUID = -4405565549223671142L;

        public Flag_error(String string, String[] stringArray) {
            super(string, stringArray);
        }

        public Flag_error(String string, String string2) {
            super(string, new String[]{string2});
        }

        public Flag_error(String string) {
            super(string, (String[])null);
        }
    }
}

