/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.console;

import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.resource.AbstractResourceManager;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.URLFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;

public class ConsoleResourceManager
extends AbstractResourceManager {
    private ResourceBundle resource = ResourceBundle.getBundle("com.ibm.etools.environment.environment");

    public void createFile(InputStream inputStream, URL uRL) throws ResourceException {
        OutputStream outputStream = null;
        try {
            try {
                byte[] byArray = new byte[1024];
                int n = inputStream.read(byArray);
                outputStream = this.getOutputStream(uRL);
                while (n >= 0) {
                    outputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FILE_IOEXCEPTION"), 4, iOException), uRL);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FILE_IOEXCEPTION"), 4, iOException), uRL);
            }
        }
    }

    public void createFolders(URL uRL) throws ResourceException {
        try {
            new File(uRL.getFile()).mkdirs();
        }
        catch (SecurityException securityException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_CREATE_FOLDERS_SECURITY_EXCEPTION"), 4, securityException), uRL);
        }
    }

    public void rename(URL uRL, URL uRL2) throws ResourceException {
        File file = new File(uRL2.getFile());
        new File(uRL.getFile()).renameTo(file);
    }

    public void delete(URL uRL) throws ResourceException {
        new File(uRL.getFile()).delete();
    }

    public void touchFile(URL uRL) throws ResourceException {
        try {
            new File(uRL.getFile()).createNewFile();
        }
        catch (IOException iOException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_TOUCHFILE_IOEXCEPTION"), 4, iOException), uRL);
        }
    }

    public void copy(URL uRL, URL uRL2) throws ResourceException {
        if (this.kind(uRL2) == 2) {
            String string = new File(uRL.getFile()).getName();
            uRL2 = this.appends(uRL2, string);
        }
        this.createFile(this.getInputStream(uRL), uRL2);
    }

    public boolean exists(URL uRL) throws ResourceException {
        return new File(uRL.getFile()).exists();
    }

    public byte kind(URL uRL) throws ResourceException {
        File file = new File(uRL.getFile());
        if (file.isFile()) {
            return 1;
        }
        if (file.isDirectory()) {
            return 2;
        }
        return 0;
    }

    public boolean isReadonly(URL uRL) throws ResourceException {
        return !new File(uRL.getFile()).canWrite();
    }

    public InputStream getInputStream(URL uRL) throws ResourceException {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_INPUTSTREAM_IOEXCEPTION"), 4, iOException), uRL);
        }
    }

    public OutputStream getOutputStream(URL uRL) throws ResourceException {
        try {
            File file = new File(uRL.getPath());
            File file2 = new File(file.getParent());
            file2.mkdirs();
            return new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_OUTPUTSTREAM_IOEXCEPTION"), 4, iOException), uRL);
        }
    }

    public PrintWriter getPrintWriter(URL uRL) throws ResourceException {
        try {
            File file = new File(uRL.getFile());
            File file2 = new File(file.getParent());
            file2.mkdirs();
            return new PrintWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_PRINTWRITER_IOEXCEPTION"), 4, iOException), uRL);
        }
    }

    public char getSeparatorChar() {
        return File.separatorChar;
    }

    public URL[] getChildren(URL uRL, URLFilter uRLFilter) throws ResourceException {
        File file = new File(uRL.getFile());
        try {
            String[] stringArray = file.list();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file, stringArray[n]);
                    URL uRL2 = file2.toURL();
                    if (uRLFilter == null) {
                        arrayList.add(uRL2);
                    } else if (uRLFilter.accept(uRL2)) {
                        arrayList.add(uRL2);
                    }
                    ++n;
                }
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }
        catch (SecurityException securityException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_GETCHILDREN_SECURITY_EXCEPTION"), 4, securityException), uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceException(new SimpleStatus("ConsoleResourceManager", this.getMessage("MSG_ERROR_GETCHILDREN_MALFORMEDURLEXCEPTION"), 4, malformedURLException), uRL);
        }
    }

    public Iterator getChildrenIterator(URL uRL, URLFilter uRLFilter) throws ResourceException {
        return null;
    }

    public String getMessage(String string) {
        return this.resource.getString(string);
    }
}

