/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.console;

import com.ibm.etools.environment.command.Command;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.console.ParsingCommand;
import com.ibm.etools.environment.resource.ResourceManagerFactory;
import com.ibm.etools.environment.resource.ResourceManagerFactoryImpl;

public class Main {
    private static final int EXIT_OK = 0;
    private static final int EXIT_PARSE_ERROR = 251;
    private static final int EXIT_NOT_CONSTRUCTABLE = 252;
    private static final int EXIT_NO_COMMAND = 253;
    private static final int EXIT_NO_CLASS = 254;
    private static final int EXIT_NO_ARGUMENTS = 255;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Main.exit(255);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(stringArray[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Main.exit(254);
        }
        Command command = null;
        ConsoleEnvironment consoleEnvironment = new ConsoleEnvironment();
        ResourceManagerFactory resourceManagerFactory = ResourceManagerFactoryImpl.getInstance();
        resourceManagerFactory.register("file", consoleEnvironment.getResourceManager());
        try {
            if (ParsingCommand.class.isAssignableFrom(clazz)) {
                ParsingCommand parsingCommand = (ParsingCommand)clazz.newInstance();
                Status status = parsingCommand.parse(stringArray, consoleEnvironment);
                if (status.getSeverity() == 4) {
                    Main.exit(251);
                } else if (status.getSeverity() == 2) {
                    Main.exit(0);
                }
                command = parsingCommand;
            } else if (Command.class.isAssignableFrom(clazz)) {
                command = (Command)clazz.newInstance();
            } else {
                Main.exit(253);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Main.exit(252);
        }
        command.execute(consoleEnvironment);
    }

    public static void exit(int n) {
        System.exit(n);
    }
}

