/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.resource;

import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.StatusMonitor;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.ResourceUtils;
import com.ibm.etools.webservice.context.ResourceContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileResourceOutputStream
extends OutputStream {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    IPath fFilePath;
    ResourceContext fResourceContext;
    ProgressMonitor fMonitor;
    StatusMonitor fStatusMonitor;
    ByteArrayOutputStream fByteArrayOutputStream;
    boolean fOpen;

    public FileResourceOutputStream(ResourceContext resourceContext, IPath iPath, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) {
        this.fFilePath = iPath;
        this.fResourceContext = resourceContext;
        this.fMonitor = progressMonitor;
        this.fStatusMonitor = statusMonitor;
        this.fByteArrayOutputStream = new ByteArrayOutputStream();
        this.fOpen = true;
    }

    public void close() throws IOException {
        if (!this.fOpen) {
            return;
        }
        this.fOpen = false;
        this.fByteArrayOutputStream.close();
        byte[] byArray = this.fByteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ResourceUtils.createFile(this.fResourceContext, this.fFilePath, byteArrayInputStream, this.fMonitor, this.fStatusMonitor);
        }
        catch (ResourceException resourceException) {
            throw new IOException(resourceException.getStatus() != null ? resourceException.getStatus().getMessage() : resourceException.getMessage());
        }
        catch (CoreException coreException) {
            throw new IOException(coreException.getMessage());
        }
    }

    public void flush() throws IOException {
        this.fByteArrayOutputStream.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.fByteArrayOutputStream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.fByteArrayOutputStream.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.fByteArrayOutputStream.write(n);
    }
}

