/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.environment.resource;

import com.ibm.etools.environment.common.Choice;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.StatusMonitor;
import com.ibm.etools.environment.resource.FileResourceOutputStream;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.webservice.context.ResourceContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public final class ResourceUtils {
    private static final String pluginId_ = "com.ibm.etools.environment.core";
    private static ResourceBundle resource_ = ResourceBundle.getBundle("com.ibm.etools.environment.environment");
    private static IWorkspace workspace_ = null;
    private static IWorkspaceRoot root_ = null;

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static Choice[] getThreeStateFileOptions() {
        Vector<Choice> vector = new Vector<Choice>();
        vector.add(new Choice(2, 'Y', ResourceUtils.getMessage("YES_LABEL")));
        vector.add(new Choice(4, 'A', ResourceUtils.getMessage("YES_TO_ALL_LABEL")));
        vector.add(new Choice(1, 'C', ResourceUtils.getMessage("CANCEL_LABEL")));
        return vector.toArray(new Choice[vector.size()]);
    }

    public static IResource findResource(String string) {
        if (string == null) {
            return null;
        }
        return ResourceUtils.findResource((IPath)new Path(string));
    }

    public static IResource findResource(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        return ResourceUtils.getWorkspaceRoot().findMember(iPath);
    }

    public static IFile createFile(ResourceContext resourceContext, IPath iPath, InputStream inputStream, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException, ResourceException {
        if (!iPath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_PATH_NOT_ABSOLUTE", new Object[]{iPath.toString()}), null));
        }
        if (iPath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_PATH_EMPTY", new Object[]{iPath.toString()}), null));
        }
        if (iPath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_PATH_NOT_FOLDER", new Object[]{iPath.toString()}), null));
        }
        IContainer iContainer = ResourceUtils.makeFolderPath(resourceContext, iPath.removeLastSegments(1), progressMonitor, statusMonitor);
        String string = iPath.lastSegment();
        return ResourceUtils.makeFile(resourceContext, iContainer, string, inputStream, progressMonitor, statusMonitor);
    }

    public static IFile createFile(ResourceContext resourceContext, IProject iProject, IPath iPath, InputStream inputStream, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException, ResourceException {
        IPath iPath2 = iProject.getFullPath().append(iPath);
        return ResourceUtils.createFile(resourceContext, iPath2, inputStream, progressMonitor, statusMonitor);
    }

    public static OutputStream newFileOutputStream(ResourceContext resourceContext, IPath iPath, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException {
        return new FileResourceOutputStream(resourceContext, iPath, progressMonitor, statusMonitor);
    }

    private static IContainer makeFolderPath(ResourceContext resourceContext, IPath iPath, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException {
        if (iPath.segmentCount() <= 1) {
            return ResourceUtils.getWorkspaceRoot().getProject(iPath.segment(0));
        }
        IContainer iContainer = ResourceUtils.makeFolderPath(resourceContext, iPath.removeLastSegments(1), progressMonitor, statusMonitor);
        String string = iPath.lastSegment();
        return ResourceUtils.makeFolder(resourceContext, iContainer, string, progressMonitor, statusMonitor);
    }

    private static IFolder makeFolder(ResourceContext resourceContext, IContainer iContainer, String string, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException {
        IResource iResource = iContainer.findMember(string);
        if (iResource == null) {
            Object object;
            if (!resourceContext.isCreateFoldersEnabled() && (object = statusMonitor.reportStatus(new SimpleStatus(pluginId_, ResourceUtils.getMessage("MSG_ERROR_FOLDER_CREATION_DISABLED", new Object[]{iContainer.getFullPath().toString(), string}), 2, null), ResourceUtils.getThreeStateFileOptions())) != null) {
                if (((Choice)object).getId() == 1) {
                    return null;
                }
                if (((Choice)object).getId() == 4) {
                    resourceContext.setCreateFoldersEnabled(true);
                }
            }
            object = iContainer.getFolder((IPath)new Path(string));
            object.create(true, true, null);
            return object;
        }
        if (iResource.getType() == 2) {
            return (IFolder)iResource;
        }
        throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_RESOURCE_NOT_FOLDER", new Object[]{iContainer.getFullPath().append(string).toString()}), null));
    }

    private static IFile makeFile(ResourceContext resourceContext, IContainer iContainer, String string, InputStream inputStream, ProgressMonitor progressMonitor, StatusMonitor statusMonitor) throws CoreException, ResourceException {
        IResource iResource = iContainer.findMember(string);
        if (iResource != null) {
            if (iResource.getType() == 1) {
                Object object;
                if (!resourceContext.isOverwriteFilesEnabled()) {
                    object = statusMonitor.reportStatus(new SimpleStatus(pluginId_, ResourceUtils.getMessage("MSG_WARN_FILE_OVERWRITE_DISABLED", new Object[]{iContainer.getFullPath().toString(), string}), 2, null), ResourceUtils.getThreeStateFileOptions());
                    if (object == null || ((Choice)object).getId() == 1) {
                        throw new ResourceException(new SimpleStatus(pluginId_, "ABORT", 8), null);
                    }
                    if (((Choice)object).getId() == 4) {
                        resourceContext.setOverwriteFilesEnabled(true);
                    }
                }
                if (iResource.getResourceAttributes().isReadOnly()) {
                    if (!resourceContext.isCheckoutFilesEnabled() && (object = statusMonitor.reportStatus(new SimpleStatus(pluginId_, ResourceUtils.getMessage("MSG_ERROR_FILE_CHECKOUT_DISABLED", new Object[]{iContainer.getFullPath().toString(), string}), 2, null), ResourceUtils.getThreeStateFileOptions())) != null) {
                        if (((Choice)object).getId() == 1) {
                            return null;
                        }
                        if (((Choice)object).getId() == 4) {
                            resourceContext.setCheckoutFilesEnabled(true);
                        }
                    }
                    object = new IFile[]{(IFile)iResource};
                    IStatus iStatus = ResourceUtils.getWorkspace().validateEdit((IFile[])object, null);
                    SimpleStatus simpleStatus = new SimpleStatus(iStatus.getPlugin(), iStatus.getMessage(), iStatus.getSeverity(), iStatus.getException());
                    if (!statusMonitor.reportStatus(simpleStatus)) {
                        return null;
                    }
                }
                object = iContainer.getFile((IPath)new Path(string));
                object.setContents(inputStream, true, true, null);
                return object;
            }
            throw new CoreException((IStatus)new Status(4, pluginId_, 0, ResourceUtils.getMessage("MSG_ERROR_RESOURCE_NOT_FILE", new Object[]{iContainer.getFullPath().append(string)}), null));
        }
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        iFile.create(inputStream, true, null);
        return iFile;
    }

    private static final String getMessage(String string, Object[] objectArray) {
        String string2 = ResourceUtils.getMessage(string);
        return MessageFormat.format(string2, objectArray);
    }

    private static final String getMessage(String string) {
        return resource_.getString(string);
    }
}

