/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.agent;

import com.ibm.etools.logging.tracing.agent.ProfilerNotAvailableException;

public final class Profiler {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2002 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean _isTracing = true;
    private static boolean _isActive = true;
    private boolean _isProfiling = false;
    private static Profiler _profiler;
    private static ProfilerNotAvailableException _errorCondition;

    private Profiler() throws ProfilerNotAvailableException {
        int n = this.initialize0();
        if (n < 0) {
            _errorCondition = new ProfilerNotAvailableException("The Java Profiling Agent is currently not running in \"application\" mode. ie. -XrunpiAgent:server=application must be provided as a  parameter to the JVM");
            throw _errorCondition;
        }
    }

    private native int initialize0();

    public static Profiler getProfiler() throws ProfilerNotAvailableException {
        if (!_isActive) {
            throw _errorCondition;
        }
        return _profiler;
    }

    public void startProfiling(boolean bl) {
        this.startProfiling(bl, 0);
    }

    public void startProfiling(boolean bl, int n) {
        Profiler profiler = this;
        synchronized (profiler) {
            if (!this._isProfiling && this.startProfiling0(bl, n) == 0) {
                this._isProfiling = true;
            }
        }
    }

    private native int startProfiling0(boolean var1, int var2);

    public void stopProfiling() {
        Profiler profiler = this;
        synchronized (profiler) {
            if (this._isProfiling) {
                this.stopProfiling0();
                this._isProfiling = false;
            }
        }
    }

    private native void stopProfiling0();

    public void markHeap() {
        if (_isActive) {
            this.markHeap0();
        }
    }

    private native void markHeap0();

    public void analyzeHeap(String string) {
        if (this._isProfiling) {
            this.analyzeHeap0(string);
        }
    }

    private native void analyzeHeap0(String var1);

    public void runGC() {
        if (_isActive) {
            this.runGC0();
        }
    }

    private native void runGC0();

    public boolean isProfiling() {
        return this._isProfiling;
    }

    static {
        try {
            System.loadLibrary("piAgent");
            _profiler = new Profiler();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            _isActive = false;
            _profiler = null;
            _errorCondition = new ProfilerNotAvailableException("Cannot locate Java Profiling Agent.  Both, the IBM Agent Controller must be installed and the piAgent.dll must be provided as a parameter to the JVM and it must be running in \"application\" mode. ie. -XrunpiAgent:server=application must be provided as a parameter to the JVM");
        }
        catch (ProfilerNotAvailableException profilerNotAvailableException) {
            _isActive = false;
            _profiler = null;
        }
    }
}

