/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import com.ibm.etools.logging.tracing.client.AgentConfiguration;
import com.ibm.etools.logging.tracing.client.AgentConfigurationEntry;
import com.ibm.etools.logging.tracing.client.AgentInfo;
import com.ibm.etools.logging.tracing.client.AnalyseHeapCommand;
import com.ibm.etools.logging.tracing.client.DataListenerInfo;
import com.ibm.etools.logging.tracing.client.MarkHeapCommand;
import com.ibm.etools.logging.tracing.client.RAClientEngine;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.DataProcessor;
import com.ibm.etools.logging.tracing.common.SetNVPairCommand;
import com.ibm.etools.logging.tracing.common.StartMonitoringRemoteAgentCommand;
import com.ibm.etools.logging.tracing.common.StopMonitorCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AgentController {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static RAClientEngine _engine = null;

    public static void sendConfiguration(AgentConfiguration agentConfiguration, AgentInfo agentInfo) throws UnknownHostException {
        int n = 0;
        if (_engine == null || agentConfiguration == null || agentInfo == null) {
            return;
        }
        ControlMessage controlMessage = new ControlMessage();
        AgentConfiguration agentConfiguration2 = agentConfiguration;
        synchronized (agentConfiguration2) {
            int n2 = 0;
            while (n2 < agentConfiguration.size()) {
                AgentConfigurationEntry agentConfigurationEntry = agentConfiguration.getEntryAt(n2);
                if (agentConfigurationEntry != null) {
                    ++n;
                    SetNVPairCommand setNVPairCommand = new SetNVPairCommand();
                    setNVPairCommand.setProcessId(agentInfo.getProcessId());
                    setNVPairCommand.setAgentName(agentInfo.getAgentName());
                    setNVPairCommand.setType(agentConfigurationEntry.getType());
                    setNVPairCommand.setName(agentConfigurationEntry.getName());
                    setNVPairCommand.setValue(agentConfigurationEntry.getValue());
                    controlMessage.appendCommand(setNVPairCommand);
                }
                ++n2;
            }
        }
        if (n > 0) {
            InetAddress inetAddress = _engine.registerServer(agentInfo.getHostname());
            _engine.sendMessage(inetAddress, controlMessage, null);
        }
    }

    public static void setEngine(RAClientEngine rAClientEngine) {
        _engine = rAClientEngine;
    }

    public static void startCollectingData(DataProcessor dataProcessor, AgentInfo agentInfo) throws UnknownHostException {
        DataListenerInfo dataListenerInfo = null;
        if (_engine == null) {
            return;
        }
        ControlMessage controlMessage = new ControlMessage();
        InetAddress inetAddress = _engine.registerServer(agentInfo.getHostname());
        StartMonitoringRemoteAgentCommand startMonitoringRemoteAgentCommand = new StartMonitoringRemoteAgentCommand();
        dataListenerInfo = _engine.createDataListener(dataProcessor);
        startMonitoringRemoteAgentCommand.setAgentName(agentInfo.getAgentName());
        startMonitoringRemoteAgentCommand.setPort(dataListenerInfo.getPort());
        startMonitoringRemoteAgentCommand.setProcessId(agentInfo.getProcessId());
        controlMessage.appendCommand(startMonitoringRemoteAgentCommand);
        _engine.sendMessage(inetAddress, controlMessage, null);
    }

    public static void markHeap(AgentInfo agentInfo) throws UnknownHostException {
        if (_engine == null) {
            return;
        }
        ControlMessage controlMessage = new ControlMessage();
        InetAddress inetAddress = _engine.registerServer(agentInfo.getHostname());
        MarkHeapCommand markHeapCommand = new MarkHeapCommand();
        markHeapCommand.setAgentName(agentInfo.getAgentName());
        markHeapCommand.setProcessId(agentInfo.getProcessId());
        controlMessage.appendCommand(markHeapCommand);
        _engine.sendMessage(inetAddress, controlMessage, null);
    }

    public static void stopCollectingData(AgentInfo agentInfo) throws UnknownHostException {
        if (_engine == null) {
            return;
        }
        ControlMessage controlMessage = new ControlMessage();
        InetAddress inetAddress = _engine.registerServer(agentInfo.getHostname());
        StopMonitorCommand stopMonitorCommand = new StopMonitorCommand();
        stopMonitorCommand.setAgentName(agentInfo.getAgentName());
        stopMonitorCommand.setProcessId(agentInfo.getProcessId());
        controlMessage.appendCommand(stopMonitorCommand);
        _engine.sendMessage(inetAddress, controlMessage, null);
    }

    public static void analyseHeap(AgentInfo agentInfo) throws UnknownHostException {
        if (_engine == null) {
            return;
        }
        ControlMessage controlMessage = new ControlMessage();
        InetAddress inetAddress = _engine.registerServer(agentInfo.getHostname());
        AnalyseHeapCommand analyseHeapCommand = new AnalyseHeapCommand();
        analyseHeapCommand.setAgentName(agentInfo.getAgentName());
        analyseHeapCommand.setProcessId(agentInfo.getProcessId());
        controlMessage.appendCommand(analyseHeapCommand);
        _engine.sendMessage(inetAddress, controlMessage, null);
    }
}

