/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import com.ibm.etools.logging.tracing.common.CommandHandler;

public class ContextMapper {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int MAPPING_INCREMENT = 10;
    protected ContextMap[] _map = new ContextMap[10];
    protected int _mappingCount = 0;
    protected int _maxMappingCount = 0;

    public void addContext(long l, CommandHandler commandHandler) {
        ContextMap[] contextMapArray = this._map;
        synchronized (contextMapArray) {
            if (this._maxMappingCount == this._map.length) {
                this.increaseContextmappingCapacity();
            }
            int n = this._mappingCount;
            while (n >= 0) {
                if (this._map[n] == null) {
                    ++this._mappingCount;
                    ++this._maxMappingCount;
                    this._map[n] = new ContextMap();
                    this._map[n]._context = l;
                    this._map[n]._handler = commandHandler;
                    this._map[n]._dirty = true;
                    return;
                }
                if (!this._map[n]._dirty) {
                    ++this._mappingCount;
                    this._map[n]._context = l;
                    this._map[n]._handler = commandHandler;
                    this._map[n]._dirty = true;
                    return;
                }
                --n;
            }
        }
    }

    public CommandHandler getHandler(long l) {
        CommandHandler commandHandler = null;
        ContextMap[] contextMapArray = this._map;
        synchronized (contextMapArray) {
            int n = this._maxMappingCount - 1;
            while (n >= 0) {
                if (this._map[n] == null) break;
                if (this._map[n]._context == l && this._map[n]._dirty) {
                    commandHandler = this._map[n]._handler;
                    break;
                }
                --n;
            }
        }
        return commandHandler;
    }

    protected void increaseContextmappingCapacity() {
        ContextMap[] contextMapArray = this._map;
        synchronized (contextMapArray) {
            ContextMap[] contextMapArray2 = new ContextMap[this._maxMappingCount + 10];
            int n = 0;
            while (n < this._maxMappingCount) {
                contextMapArray2[n] = this._map[n];
                ++n;
            }
            this._map = contextMapArray2;
            contextMapArray2 = null;
        }
    }

    public void removeContext(long l) {
        ContextMap[] contextMapArray = this._map;
        synchronized (contextMapArray) {
            int n = this._maxMappingCount - 1;
            while (n >= 0) {
                if (this._map[n]._context == l && this._map[n]._dirty) {
                    --this._mappingCount;
                    this._map[n]._dirty = false;
                    this._map[n]._handler = null;
                    break;
                }
                --n;
            }
        }
    }

    class ContextMap {
        public long _context = 0L;
        public CommandHandler _handler = null;
        public boolean _dirty = false;

        ContextMap() {
        }
    }
}

