/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import com.ibm.etools.logging.tracing.client.NodeConfiguration;
import com.ibm.etools.logging.tracing.client.NodeConfigurationListener;
import com.ibm.etools.logging.tracing.client.NotificationTimeoutException;
import com.ibm.etools.logging.tracing.client.RAClientEngine;
import com.ibm.etools.logging.tracing.common.ActiveAgentListCommand;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.QueryAgentListCommand;
import com.ibm.etools.logging.tracing.common.QueryProcessListCommand;
import com.ibm.etools.logging.tracing.common.RegisteredProcessListCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NodeConfigurationQuery
implements CommandHandler {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private RAClientEngine _engine = null;
    private NodeConfigurationListener _listener = null;
    private NodeConfiguration _configuration = new NodeConfiguration();
    private String _nodeName = null;
    private int _waitingProcessInfoCount = 0;

    public NodeConfigurationQuery(RAClientEngine rAClientEngine, String string, NodeConfigurationListener nodeConfigurationListener) {
        this._engine = rAClientEngine;
        this._nodeName = string;
        this._listener = nodeConfigurationListener;
    }

    public void incommingCommand(InetAddress inetAddress, CommandElement commandElement) {
        switch ((int)commandElement.getTag()) {
            case 33: {
                RegisteredProcessListCommand registeredProcessListCommand = (RegisteredProcessListCommand)commandElement;
                long[] lArray = registeredProcessListCommand.getProcessList();
                this._waitingProcessInfoCount = lArray.length;
                NodeConfigurationQuery nodeConfigurationQuery = this;
                synchronized (nodeConfigurationQuery) {
                    if (this._waitingProcessInfoCount == 0) {
                        this.notify();
                    }
                }
                int n = 0;
                while (n < lArray.length) {
                    this._configuration.addProcess(lArray[n]);
                    ControlMessage controlMessage = new ControlMessage();
                    QueryAgentListCommand queryAgentListCommand = new QueryAgentListCommand();
                    queryAgentListCommand.setProcessId(lArray[n]);
                    controlMessage.appendCommand(queryAgentListCommand);
                    this._engine.sendMessage(inetAddress, controlMessage, this);
                    ++n;
                }
                break;
            }
            case 34: {
                ActiveAgentListCommand activeAgentListCommand = (ActiveAgentListCommand)commandElement;
                String[] stringArray = activeAgentListCommand.getAgents();
                this._configuration.setProcessName(activeAgentListCommand.getProcessId(), activeAgentListCommand.getProcessName());
                int n = 0;
                while (n < stringArray.length) {
                    this._configuration.addAgent(activeAgentListCommand.getProcessId(), stringArray[n]);
                    ++n;
                }
                --this._waitingProcessInfoCount;
                NodeConfigurationQuery nodeConfigurationQuery = this;
                synchronized (nodeConfigurationQuery) {
                    if (this._waitingProcessInfoCount == 0) {
                        this.notify();
                    }
                    break;
                }
            }
        }
    }

    public void performQuery(long l) throws UnknownHostException, NotificationTimeoutException {
        this._configuration.reset();
        InetAddress inetAddress = this._engine.registerServer(this._nodeName);
        ControlMessage controlMessage = new ControlMessage();
        QueryProcessListCommand queryProcessListCommand = new QueryProcessListCommand();
        controlMessage.appendCommand(queryProcessListCommand);
        this._engine.sendMessage(inetAddress, controlMessage, this);
        this._waitingProcessInfoCount = 1;
        NodeConfigurationQuery nodeConfigurationQuery = this;
        synchronized (nodeConfigurationQuery) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._waitingProcessInfoCount > 0) {
            throw new NotificationTimeoutException();
        }
        this._listener.updateNodeConfiguration(this._configuration);
    }
}

