/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import com.ibm.etools.logging.tracing.client.IncompleteProcessSpecException;
import com.ibm.etools.logging.tracing.client.NotificationTimeoutException;
import com.ibm.etools.logging.tracing.client.ProcessListener;
import com.ibm.etools.logging.tracing.client.RAClientEngine;
import com.ibm.etools.logging.tracing.common.AgentActiveCommand;
import com.ibm.etools.logging.tracing.common.AgentInactiveCommand;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.common.Console;
import com.ibm.etools.logging.tracing.common.ConsoleNotStartedException;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.ErrorCommand;
import com.ibm.etools.logging.tracing.common.LaunchProcessCommand;
import com.ibm.etools.logging.tracing.common.ProcessLaunchedCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ProcessLauncher
implements CommandHandler {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int ENVIRONMENT_VARIABLE_INCREMENT = 5;
    protected static final int AGENT_INTEREST_INCREMENT = 2;
    protected EnvironmentEntry[] _env = new EnvironmentEntry[5];
    protected String[] _agentInterests = new String[2];
    protected int _currentEnvironmentEntryCount = 0;
    protected int _currentAgentInterestCount = 0;
    protected ProcessListener _listener = null;
    protected String _host = null;
    protected String _exe = null;
    protected String _params = null;
    protected RAClientEngine _engine = null;
    protected boolean _complete = false;
    protected ProcessLaunchedCommand _launchedProcessInfo = null;
    protected Console _console = null;

    public ProcessLauncher(RAClientEngine rAClientEngine, String string, ProcessListener processListener) {
        this._host = string;
        this._listener = processListener;
        this._engine = rAClientEngine;
    }

    public void addAgentInterest(String string) {
        if (this._currentAgentInterestCount == this._agentInterests.length) {
            String[] stringArray = new String[this._currentAgentInterestCount + 2];
            int n = 0;
            while (n < this._currentAgentInterestCount) {
                stringArray[n] = this._agentInterests[n];
                ++n;
            }
            this._agentInterests = stringArray;
            stringArray = null;
        }
        this._agentInterests[this._currentAgentInterestCount] = new String();
        this._agentInterests[this._currentAgentInterestCount] = string;
        ++this._currentAgentInterestCount;
    }

    public void addEnvironmentVariable(String string, String string2) {
        if (this._currentEnvironmentEntryCount == this._env.length) {
            EnvironmentEntry[] environmentEntryArray = new EnvironmentEntry[this._currentEnvironmentEntryCount + 5];
            int n = 0;
            while (n < this._currentEnvironmentEntryCount) {
                environmentEntryArray[n] = this._env[n];
                ++n;
            }
            this._env = environmentEntryArray;
            environmentEntryArray = null;
        }
        this._env[this._currentEnvironmentEntryCount] = new EnvironmentEntry();
        this._env[this._currentEnvironmentEntryCount]._variable = string;
        this._env[this._currentEnvironmentEntryCount]._value = string2;
        ++this._currentEnvironmentEntryCount;
    }

    public void incommingCommand(InetAddress inetAddress, CommandElement commandElement) {
        switch ((int)commandElement.getTag()) {
            case 32: {
                this._launchedProcessInfo = (ProcessLaunchedCommand)commandElement;
                ProcessLauncher processLauncher = this;
                synchronized (processLauncher) {
                    this._complete = true;
                    this.notify();
                    break;
                }
            }
            case 35: {
                this._listener.agentActive((AgentActiveCommand)commandElement);
                break;
            }
            case 36: {
                this._listener.agentInactive((AgentInactiveCommand)commandElement);
                break;
            }
            case 37: {
                this._listener.error((ErrorCommand)commandElement);
            }
        }
    }

    public void launchProcess(long l) throws UnknownHostException, NotificationTimeoutException, IncompleteProcessSpecException, ConsoleNotStartedException {
        if (this._engine == null || this._exe == null || this._host == null) {
            throw new IncompleteProcessSpecException();
        }
        InetAddress inetAddress = this._engine.registerServer(this._host);
        ControlMessage controlMessage = new ControlMessage();
        LaunchProcessCommand launchProcessCommand = new LaunchProcessCommand();
        launchProcessCommand.setExe(this._exe);
        launchProcessCommand.setArgs(this._params);
        if (this._console != null) {
            launchProcessCommand.setConsole(this._console);
        }
        int n = 0;
        while (n < this._currentEnvironmentEntryCount) {
            launchProcessCommand.addEnvironmentVariable(this._env[n]._variable, this._env[n]._value);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._currentAgentInterestCount) {
            launchProcessCommand.addAgent(this._agentInterests[n2]);
            ++n2;
        }
        controlMessage.appendCommand(launchProcessCommand);
        ProcessLauncher processLauncher = this;
        synchronized (processLauncher) {
            try {
                this._complete = false;
                this._engine.sendMessage(inetAddress, controlMessage, this);
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this._complete) {
            throw new NotificationTimeoutException();
        }
        this._listener.processLaunched(this._launchedProcessInfo);
    }

    public void reset() {
        int n = 0;
        while (n < this._currentAgentInterestCount) {
            this._agentInterests[n] = null;
            ++n;
        }
        this._currentAgentInterestCount = 0;
        int n2 = 0;
        while (n2 < this._currentEnvironmentEntryCount) {
            this._env[n2] = null;
            ++n2;
        }
        this._currentEnvironmentEntryCount = 0;
    }

    public void setConsole(Console console) {
        this._console = console;
    }

    public void setExecutable(String string) {
        this._exe = string;
    }

    public void setParameters(String string) {
        this._params = string;
    }

    class EnvironmentEntry {
        public String _variable;
        public String _value;

        EnvironmentEntry() {
        }
    }
}

