/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import com.ibm.etools.logging.tracing.client.ContextGenerator;
import com.ibm.etools.logging.tracing.client.ContextMapper;
import com.ibm.etools.logging.tracing.client.DataListenerInfo;
import com.ibm.etools.logging.tracing.client.RegisteredServersTable;
import com.ibm.etools.logging.tracing.common.AcknowledgementHandler;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.CommandHandler;
import com.ibm.etools.logging.tracing.common.Constants;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.ControlServerDaemon;
import com.ibm.etools.logging.tracing.common.DataProcessor;
import com.ibm.etools.logging.tracing.common.TCPDataServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public final class RAClientEngine
implements Constants,
CommandHandler {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CommandHandler _cmdHandler = null;
    protected AcknowledgementHandler _ackHandler = null;
    protected ControlServerDaemon _controlServer = null;
    private RegisteredServersTable _registeredServers = null;
    private ContextMapper _contextMapper = new ContextMapper();

    public RAClientEngine() {
        this._registeredServers = new RegisteredServersTable();
    }

    public DataListenerInfo createDataListener(DataProcessor dataProcessor) throws UnknownHostException {
        int n = 10004;
        boolean bl = false;
        TCPDataServer tCPDataServer = new TCPDataServer();
        while (!bl) {
            try {
                bl = true;
                tCPDataServer.startServer(dataProcessor, n);
            }
            catch (Exception exception) {
                n = (short)(n + 1);
                bl = false;
            }
        }
        DataListenerInfo dataListenerInfo = new DataListenerInfo();
        byte[] byArray = InetAddress.getLocalHost().getAddress();
        long l = (long)(byArray[3] << 24 & 0xFF000000) | (long)(byArray[2] << 16 & 0xFF0000) | (long)(byArray[1] << 8 & 0xFF00) | (long)(byArray[0] & 0xFF);
        dataListenerInfo.setIP(l);
        dataListenerInfo.setPort((short)tCPDataServer.getPort());
        return dataListenerInfo;
    }

    public void deregisterServer(String string) {
        this._registeredServers.removeServer(string);
    }

    public void incommingCommand(InetAddress inetAddress, CommandElement commandElement) {
        long l = commandElement.getContext();
        if (l == 0L) {
            if (this._cmdHandler != null) {
                this._cmdHandler.incommingCommand(inetAddress, commandElement);
            }
        } else {
            CommandHandler commandHandler = this._contextMapper.getHandler(l);
            if (commandHandler != null) {
                commandHandler.incommingCommand(inetAddress, commandElement);
            }
        }
    }

    public InetAddress registerServer(String string) throws UnknownHostException {
        InetAddress inetAddress = this._registeredServers.getServerAddress(string);
        if (inetAddress != null) {
            return inetAddress;
        }
        inetAddress = InetAddress.getByName(string);
        this._registeredServers.addServer(inetAddress, string);
        return inetAddress;
    }

    public void sendMessage(InetAddress inetAddress, ControlMessage controlMessage, CommandHandler commandHandler) {
        int n = controlMessage.getSize();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < controlMessage.getCommandCount()) {
            controlMessage.getCommand(n2).setContext(ContextGenerator.generate());
            this._contextMapper.addContext(controlMessage.getCommand(n2).getContext(), commandHandler);
            ++n2;
        }
        controlMessage.writeToBuffer(byArray, 0);
        try {
            this._controlServer.sendMessage(byArray, n, inetAddress);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAcknowledgementHandler(AcknowledgementHandler acknowledgementHandler) {
        this._ackHandler = acknowledgementHandler;
    }

    public void setDefaultCommandHandler(CommandHandler commandHandler) {
        this._cmdHandler = commandHandler;
    }

    public void startEngine() throws SocketException {
        this._controlServer = new ControlServerDaemon();
        this._controlServer.setCommandHandler(this);
        this._controlServer.setAcknowledgementHandler(this._ackHandler);
        this._controlServer.startServer();
    }
}

