/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.client;

import java.net.InetAddress;

final class RegisteredServersTable {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int INITIAL_SERVERS = 16;
    private ServerEntry[] _servers = new ServerEntry[16];

    public boolean addServer(InetAddress inetAddress, String string) {
        ServerEntry[] serverEntryArray = this._servers;
        synchronized (serverEntryArray) {
            int n = 0;
            while (n < this._servers.length) {
                if (this._servers[n] == null) {
                    this._servers[n] = new ServerEntry();
                    this._servers[n].addr = inetAddress;
                    this._servers[n].name = string;
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
            ServerEntry[] serverEntryArray2 = this._servers;
            this._servers = new ServerEntry[serverEntryArray2.length + 1];
            int n2 = 0;
            while (n2 < serverEntryArray2.length) {
                this._servers[n2] = serverEntryArray2[n2];
                ++n2;
            }
            this._servers[serverEntryArray2.length] = new ServerEntry();
            this._servers[serverEntryArray2.length].addr = inetAddress;
            this._servers[serverEntryArray2.length].name = string;
            boolean bl = true;
            return bl;
        }
    }

    public InetAddress getServerAddress(String string) {
        ServerEntry[] serverEntryArray = this._servers;
        synchronized (serverEntryArray) {
            int n = 0;
            while (n < this._servers.length) {
                if (this._servers[n] != null && this._servers[n].name != null && this._servers[n].name.equals(string)) {
                    InetAddress inetAddress = this._servers[n].addr;
                    return inetAddress;
                }
                ++n;
            }
        }
        return null;
    }

    public String getServerName(InetAddress inetAddress) {
        ServerEntry[] serverEntryArray = this._servers;
        synchronized (serverEntryArray) {
            int n = 0;
            while (n < this._servers.length) {
                if (this._servers[n] != null && this._servers[n].addr != null && this._servers[n].addr.equals(inetAddress)) {
                    String string = this._servers[n].name;
                    return string;
                }
                ++n;
            }
        }
        return null;
    }

    public void removeServer(String string) {
        ServerEntry[] serverEntryArray = this._servers;
        synchronized (serverEntryArray) {
            int n = 0;
            while (n < this._servers.length) {
                if (this._servers[n] != null && this._servers[n].name != null && this._servers[n].name.equals(string)) {
                    this._servers[n] = null;
                }
                ++n;
            }
        }
    }

    class ServerEntry {
        public InetAddress addr;
        public String name;

        ServerEntry() {
        }
    }
}

