/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.common;

import com.ibm.etools.logging.tracing.common.Constants;

class RABinaryArray
implements Constants {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected byte[] _data;
    protected int _padding = 0;

    public RABinaryArray() {
    }

    public RABinaryArray(byte[] byArray) {
        if (byArray != null) {
            this._data = byArray;
            this.calculatePadding();
        } else {
            this._padding = 0;
        }
    }

    private void calculatePadding() {
        this._padding = 4 - this._data.length % 4;
        if (this._padding == 4) {
            this._padding = 0;
        }
    }

    public byte[] getData() {
        return this._data;
    }

    public int getPadding() {
        return this._padding;
    }

    public int getSize() {
        return 4 + this._data.length + this._padding;
    }

    public long length() {
        if (this._data != null) {
            return this._data.length;
        }
        return 0L;
    }

    public void setData(byte[] byArray) {
        this._data = byArray;
        this.calculatePadding();
    }

    public void setData(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            this._data = new byte[n2];
            System.arraycopy(byArray, n, this._data, 0, n2);
            this.calculatePadding();
        }
    }
}

