/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.control;

import com.ibm.etools.logging.tracing.control.Node;
import com.ibm.etools.logging.tracing.control.NodeImpl;
import com.ibm.etools.logging.tracing.security.DuplicateUserException;
import com.ibm.etools.logging.tracing.security.User;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NodeFactory {
    private static final int INITIAL_SERVERS = 16;
    private static Node[] _servers = new Node[16];

    public static Node createNode(String string) throws UnknownHostException {
        try {
            return NodeFactory.createNode(string, null);
        }
        catch (DuplicateUserException duplicateUserException) {
            return NodeFactory.containsNode(string, null);
        }
    }

    public static Node createNode(String string, User user) throws UnknownHostException, DuplicateUserException {
        Node node = NodeFactory.containsNode(string, user);
        if (node == null) {
            InetAddress inetAddress = InetAddress.getByName(string);
            return NodeFactory.addNode(string, inetAddress, user);
        }
        throw new DuplicateUserException();
    }

    public static Node createNode(InetAddress inetAddress) throws UnknownHostException {
        return NodeFactory.createNode(inetAddress, null);
    }

    public static Node createNode(InetAddress inetAddress, User user) throws UnknownHostException {
        Node node = NodeFactory.getNode(inetAddress, user);
        if (node == null) {
            String string = inetAddress.getHostName();
            node = NodeFactory.addNode(string, inetAddress, user);
        }
        return node;
    }

    public static Node getLocalHost() throws UnknownHostException {
        if (_servers[0] == null) {
            throw new UnknownHostException();
        }
        return _servers[0];
    }

    public static Node getLocalHost(User user) throws UnknownHostException {
        if (_servers[0] == null) {
            throw new UnknownHostException();
        }
        String string = _servers[0].getName();
        return null;
    }

    private static Node addNode(String string, InetAddress inetAddress, User user) {
        Node[] nodeArray = _servers;
        synchronized (nodeArray) {
            int n = 0;
            while (n < _servers.length) {
                if (_servers[n] == null) {
                    NodeFactory._servers[n] = new NodeImpl(string, inetAddress);
                    ((NodeImpl)_servers[n]).setUser(user);
                    Node node = _servers[n];
                    return node;
                }
                ++n;
            }
            Node[] nodeArray2 = _servers;
            _servers = new Node[nodeArray2.length + 1];
            int n2 = 0;
            while (n2 < nodeArray2.length) {
                NodeFactory._servers[n2] = nodeArray2[n2];
                ++n2;
            }
            NodeFactory._servers[nodeArray2.length] = new NodeImpl(string, inetAddress);
            Node node = _servers[nodeArray2.length];
            return node;
        }
    }

    private static Node containsNode(String string) {
        return NodeFactory.containsNode(string, null);
    }

    private static Node containsNode(String string, User user) {
        Node[] nodeArray = _servers;
        synchronized (nodeArray) {
            if (string.equals("localhost")) {
                try {
                    string = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            InetAddress[] inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(string);
                inetAddressArray = InetAddress.getAllByName(inetAddressArray[0].getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                Node node = null;
                return node;
            }
            int n = 0;
            while (n < _servers.length) {
                if (_servers[n] != null) {
                    int n2 = 0;
                    while (n2 < inetAddressArray.length) {
                        InetAddress inetAddress = _servers[n].getInetAddress();
                        if (inetAddressArray[n2].equals(inetAddress)) {
                            if (user == null) {
                                Node node = _servers[n];
                                return node;
                            }
                            if (_servers[n].getUser() != null && user.getName().equals(_servers[n].getUser().getName())) {
                                Node node = _servers[n];
                                return node;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public static Node getNode(InetAddress inetAddress) {
        return NodeFactory.getNode(inetAddress, null);
    }

    public static Node getNode(InetAddress inetAddress, User user) {
        return NodeFactory.containsNode(inetAddress.getHostName(), user);
    }

    public static Node getNode(String string, User user) throws UnknownHostException {
        return NodeFactory.getNode(InetAddress.getByName(string), user);
    }

    static {
        try {
            NodeFactory._servers[0] = NodeFactory.createNode(InetAddress.getLocalHost());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

