/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.tracing.control;

import com.ibm.etools.logging.tracing.common.ActiveAgentListCommand;
import com.ibm.etools.logging.tracing.common.AgentDetailsCommand;
import com.ibm.etools.logging.tracing.common.CommandElement;
import com.ibm.etools.logging.tracing.common.ControlMessage;
import com.ibm.etools.logging.tracing.common.KillProcessCommand;
import com.ibm.etools.logging.tracing.common.ProcessExitedCommand;
import com.ibm.etools.logging.tracing.common.QueryAgentDetailsCommand;
import com.ibm.etools.logging.tracing.common.QueryAgentListCommand;
import com.ibm.etools.logging.tracing.common.QueryProcessListCommand;
import com.ibm.etools.logging.tracing.common.RegisteredProcessListCommand;
import com.ibm.etools.logging.tracing.common.SimpleProcessCommand;
import com.ibm.etools.logging.tracing.control.Agent;
import com.ibm.etools.logging.tracing.control.AgentControllerUnavailableException;
import com.ibm.etools.logging.tracing.control.AgentImpl;
import com.ibm.etools.logging.tracing.control.CommandHandler;
import com.ibm.etools.logging.tracing.control.Connection;
import com.ibm.etools.logging.tracing.control.ConnectionImpl;
import com.ibm.etools.logging.tracing.control.ConnectionListener;
import com.ibm.etools.logging.tracing.control.InactiveProcessException;
import com.ibm.etools.logging.tracing.control.Node;
import com.ibm.etools.logging.tracing.control.NodeImpl;
import com.ibm.etools.logging.tracing.control.NodeListener;
import com.ibm.etools.logging.tracing.control.NotConnectedException;
import com.ibm.etools.logging.tracing.control.NotImplementedException;
import com.ibm.etools.logging.tracing.control.Process;
import com.ibm.etools.logging.tracing.control.ProcessImpl;
import com.ibm.etools.logging.tracing.control.ProcessListener;
import com.ibm.etools.logging.tracing.security.SecureConnectionRequiredException;
import com.ibm.etools.logging.tracing.security.User;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class NodeImpl
implements Node {
    protected String _name;
    protected InetAddress[] _addr;
    protected Vector _listeners = new Vector(10);
    protected Connection _connection;
    private User _user;
    protected Vector _userConnections = new Vector();
    protected Hashtable _processes = new Hashtable(300);
    private ProcessListener _processListener = null;
    private long _listProcessesWaitingCommandCount = 0L;
    private Object _listProcessesLock = new Object();
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001, 2002 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public NodeImpl(String string, InetAddress inetAddress) {
        this._name = string;
        try {
            this._addr = InetAddress.getAllByName(inetAddress.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this._processListener = new ProcessListener(){

            public synchronized void processLaunched(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(l);
                    NodeImpl.this._processes.put(l, process);
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }

            public synchronized void processExited(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(l);
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }
        };
    }

    public NodeImpl(String string, InetAddress[] inetAddressArray) {
        this._name = string;
        this._addr = inetAddressArray;
        this._processListener = new ProcessListener(){

            public synchronized void processLaunched(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    if (!NodeImpl.this._processes.containsKey(l)) {
                        NodeImpl.this._processes.put(l, process);
                    }
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }

            public synchronized void processExited(Process process) {
                try {
                    Long l = new Long(process.getProcessId());
                    NodeImpl.this._processes.remove(l);
                }
                catch (InactiveProcessException inactiveProcessException) {
                    // empty catch block
                }
            }
        };
    }

    public void killProcess(Process process) throws InactiveProcessException, NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        if (!process.isActive()) {
            throw new InactiveProcessException();
        }
        ControlMessage controlMessage = new ControlMessage();
        KillProcessCommand killProcessCommand = new KillProcessCommand();
        killProcessCommand.setProcessId(Long.parseLong(process.getProcessId()));
        controlMessage.appendCommand(killProcessCommand);
        try {
            this._connection.sendMessage(controlMessage, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement commandElement) {
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdown(long l) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public void reboot(long l) throws NotConnectedException {
        throw new NotImplementedException();
    }

    public Enumeration listMonitors() throws NotConnectedException {
        throw new NotImplementedException();
    }

    public synchronized Enumeration listProcesses() throws NotConnectedException {
        if (this._connection == null) {
            throw new NotConnectedException();
        }
        NodeImpl nodeImpl = this;
        ControlMessage controlMessage = new ControlMessage();
        QueryProcessListCommand queryProcessListCommand = new QueryProcessListCommand();
        controlMessage.appendCommand(queryProcessListCommand);
        ConnectionListener connectionListener = new ConnectionListener(){

            public void connectionClosed(Connection connection) {
                Object object = NodeImpl.this._listProcessesLock;
                synchronized (object) {
                    NodeImpl.this._listProcessesLock.notifyAll();
                }
            }
        };
        Object object = this._listProcessesLock;
        synchronized (object) {
            this._connection.addConnectionListener(connectionListener);
            try {
                this._connection.sendMessage(controlMessage, new CommandHandler(){

                    public void incommingCommand(Node node, CommandElement commandElement) {
                        switch ((int)commandElement.getTag()) {
                            case 33: {
                                Object object;
                                RegisteredProcessListCommand registeredProcessListCommand = (RegisteredProcessListCommand)commandElement;
                                long[] lArray = registeredProcessListCommand.getProcessList();
                                long l = lArray.length;
                                Enumeration enumeration = NodeImpl.this._processes.elements();
                                while (enumeration.hasMoreElements()) {
                                    long l2 = 0L;
                                    object = (Process)enumeration.nextElement();
                                    try {
                                        l2 = Long.parseLong(object.getProcessId());
                                    }
                                    catch (InactiveProcessException inactiveProcessException) {
                                        continue;
                                    }
                                    long l3 = 0L;
                                    while (l3 < l) {
                                        if (l2 == lArray[(int)l3]) {
                                            if (object.isActive()) break;
                                            l3 = l;
                                        }
                                        ++l3;
                                    }
                                    if (l3 != l) continue;
                                    NodeImpl.this._processes.remove(new Long(l2));
                                    try {
                                        ProcessExitedCommand processExitedCommand = new ProcessExitedCommand();
                                        processExitedCommand.setProcessId(l2);
                                        ((ProcessImpl)object).handleCommand(processExitedCommand);
                                    }
                                    catch (ClassCastException classCastException) {
                                        // empty catch block
                                    }
                                }
                                if (l == 0L) {
                                    Object object2 = NodeImpl.this._listProcessesLock;
                                    synchronized (object2) {
                                        NodeImpl.this._listProcessesLock.notify();
                                        break;
                                    }
                                }
                                ControlMessage controlMessage = new ControlMessage();
                                int n = 0;
                                while ((long)n < l) {
                                    object = new QueryAgentListCommand();
                                    ((SimpleProcessCommand)object).setProcessId(lArray[n]);
                                    controlMessage.appendCommand((CommandElement)object);
                                    ++n;
                                }
                                try {
                                    object = NodeImpl.this._listProcessesLock;
                                    synchronized (object) {
                                        NodeImpl.this._listProcessesWaitingCommandCount = l;
                                    }
                                    NodeImpl.this._connection.sendMessage(controlMessage, new CommandHandler(this){
                                        private final /* synthetic */ 5 this$1;
                                        {
                                            this.this$1 = var1_1;
                                        }

                                        public void incommingCommand(Node node, CommandElement commandElement) {
                                            Object object;
                                            switch ((int)commandElement.getTag()) {
                                                case 34: {
                                                    Object object2;
                                                    object = (ActiveAgentListCommand)commandElement;
                                                    Long l = new Long(((SimpleProcessCommand)object).getProcessId());
                                                    Process process = (Process)5.access$200(this.this$1)._processes.get(l);
                                                    if (process == null) {
                                                        process = new ProcessImpl(node, ((ActiveAgentListCommand)object).getProcessName(), ((SimpleProcessCommand)object).getProcessId());
                                                        try {
                                                            process.addProcessListener(NodeImpl.access$300(5.access$200(this.this$1)));
                                                        }
                                                        catch (ClassCastException classCastException) {
                                                            // empty catch block
                                                        }
                                                        5.access$200(this.this$1)._processes.put(l, process);
                                                    } else if (!process.getExecutable().equals(((ActiveAgentListCommand)object).getProcessName()) && !((ActiveAgentListCommand)object).getProcessName().equals("unknown")) {
                                                        object2 = new ProcessExitedCommand();
                                                        ((SimpleProcessCommand)object2).setProcessId(((SimpleProcessCommand)object).getProcessId());
                                                        ((ProcessImpl)process).handleCommand((CommandElement)object2);
                                                        5.access$200(this.this$1)._processes.remove(l);
                                                        process = new ProcessImpl(node, ((ActiveAgentListCommand)object).getProcessName(), ((SimpleProcessCommand)object).getProcessId());
                                                        try {
                                                            process.addProcessListener(NodeImpl.access$300(5.access$200(this.this$1)));
                                                        }
                                                        catch (ClassCastException classCastException) {
                                                            // empty catch block
                                                        }
                                                        5.access$200(this.this$1)._processes.put(l, process);
                                                    }
                                                    object2 = ((ActiveAgentListCommand)object).getAgents();
                                                    int n = 0;
                                                    while (n < ((String[])object2).length) {
                                                        ControlMessage controlMessage = new ControlMessage();
                                                        QueryAgentDetailsCommand queryAgentDetailsCommand = new QueryAgentDetailsCommand();
                                                        queryAgentDetailsCommand.setProcessId(((SimpleProcessCommand)object).getProcessId());
                                                        queryAgentDetailsCommand.setAgentName((String)object2[n]);
                                                        controlMessage.appendCommand(queryAgentDetailsCommand);
                                                        try {
                                                            Object object3 = NodeImpl.access$000(5.access$200(this.this$1));
                                                            synchronized (object3) {
                                                                NodeImpl.access$108(5.access$200(this.this$1));
                                                            }
                                                            5.access$200(this.this$1)._connection.sendMessage(controlMessage, new CommandHandler(this){
                                                                private final /* synthetic */ 6 this$2;
                                                                {
                                                                    this.this$2 = var1_1;
                                                                }

                                                                public void incommingCommand(Node node, CommandElement commandElement) {
                                                                    switch ((int)commandElement.getTag()) {
                                                                        case 40: {
                                                                            AgentDetailsCommand agentDetailsCommand = (AgentDetailsCommand)commandElement;
                                                                            Process process = (Process)5.access$200(6.access$400(this.this$2))._processes.get(new Long(agentDetailsCommand.getProcessId()));
                                                                            if (process == null) break;
                                                                            ((ProcessImpl)process).setUUID(agentDetailsCommand.getProcessUUID());
                                                                            Agent agent = process.getAgent(agentDetailsCommand.getAgentName());
                                                                            if (agent != null) break;
                                                                            agent = new AgentImpl(process, agentDetailsCommand.getAgentName(), agentDetailsCommand.getAgentType(), true);
                                                                            ((AgentImpl)agent).setUUID(agentDetailsCommand.getAgentUUID());
                                                                            try {
                                                                                ((ProcessImpl)process).addAgent(agent);
                                                                                agent.addAgentListener((ProcessImpl)process);
                                                                                break;
                                                                            }
                                                                            catch (ClassCastException classCastException) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                    }
                                                                    Object object = NodeImpl.access$000(5.access$200(6.access$400(this.this$2)));
                                                                    synchronized (object) {
                                                                        NodeImpl.access$110(5.access$200(6.access$400(this.this$2)));
                                                                        if (NodeImpl.access$100(5.access$200(6.access$400(this.this$2))) == 0L) {
                                                                            NodeImpl.access$000(5.access$200(6.access$400(this.this$2))).notify();
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                        ++n;
                                                    }
                                                    break;
                                                }
                                            }
                                            object = NodeImpl.access$000(5.access$200(this.this$1));
                                            synchronized (object) {
                                                NodeImpl.access$110(5.access$200(this.this$1));
                                                if (NodeImpl.access$100(5.access$200(this.this$1)) == 0L) {
                                                    NodeImpl.access$000(5.access$200(this.this$1)).notify();
                                                }
                                            }
                                        }

                                        static /* synthetic */ 5 access$400(6 var0) {
                                            return var0.this$1;
                                        }
                                    });
                                    break;
                                }
                                catch (IOException iOException) {
                                    Object object3 = NodeImpl.this._listProcessesLock;
                                    synchronized (object3) {
                                        NodeImpl.this._listProcessesWaitingCommandCount = 0L;
                                        NodeImpl.this._listProcessesLock.notify();
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    static /* synthetic */ NodeImpl access$200(5 var0) {
                        return var0.NodeImpl.this;
                    }
                });
            }
            catch (IOException iOException) {
                Enumeration enumeration = null;
                return enumeration;
            }
            try {
                this._listProcessesLock.wait(7000L);
                this._connection.removeConnectionListener(connectionListener);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ((Hashtable)this._processes.clone()).elements();
    }

    public synchronized Process getProcess(String string) {
        return (Process)this._processes.get(new Long(string));
    }

    public InetAddress getInetAddress() {
        if (this._addr != null) {
            return this._addr[0];
        }
        return null;
    }

    public InetAddress[] getAllInetAddresses() {
        return this._addr;
    }

    public String getName() {
        return this._name;
    }

    public void addNodeListener(NodeListener nodeListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(nodeListener)) {
                this._listeners.add(nodeListener);
            }
        }
    }

    public void removeNodeListener(NodeListener nodeListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(nodeListener)) {
                this._listeners.remove(nodeListener);
            }
        }
    }

    public boolean isConnected() {
        if (this._connection != null) {
            return this._connection.isActive();
        }
        return false;
    }

    public synchronized Connection connect(int n) throws AgentControllerUnavailableException, SecureConnectionRequiredException {
        if (this._connection == null || !this._connection.isActive()) {
            try {
                this._connection = new ConnectionImpl();
                ((ConnectionImpl)this._connection).connect(this, n);
            }
            catch (IOException iOException) {
                this._connection = null;
                throw new AgentControllerUnavailableException();
            }
        }
        return this._connection;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public ProcessListener getProcessListener() {
        return this._processListener;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public User getUser() {
        return this._user;
    }

    static /* synthetic */ ProcessListener access$300(NodeImpl nodeImpl) {
        return nodeImpl._processListener;
    }

    static /* synthetic */ long access$108(NodeImpl nodeImpl) {
        return nodeImpl._listProcessesWaitingCommandCount++;
    }

    static /* synthetic */ long access$110(NodeImpl nodeImpl) {
        return nodeImpl._listProcessesWaitingCommandCount--;
    }

    static /* synthetic */ long access$100(NodeImpl nodeImpl) {
        return nodeImpl._listProcessesWaitingCommandCount;
    }
}

