/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.tracing.agent.AgentControllerListener;
import com.ibm.etools.logging.tracing.agent.LoggingAgent;
import com.ibm.etools.logging.tracing.agent.MonitorListener;
import com.ibm.etools.logging.tracing.agent.QueueManager;
import com.ibm.etools.logging.tracing.control.AgentConfiguration;
import com.ibm.etools.logging.util.AbstractMessageLoggerFactory;
import com.ibm.etools.logging.util.Constants;
import com.ibm.etools.logging.util.DefaultRecord;
import com.ibm.etools.logging.util.IPluginHelper;
import com.ibm.etools.logging.util.Level;
import com.ibm.etools.logging.util.LoggingUtilities;
import com.ibm.etools.logging.util.NoDefinedFactoryException;
import com.ibm.etools.logging.util.PluginHelperImpl;
import com.ibm.etools.logging.util.XMLGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractMessageLogger
implements MonitorListener,
AgentControllerListener {
    public static final String abstractMessageLoggerCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static AbstractMessageLoggerFactory _factory = null;
    private LoggingAgent _agent = null;
    private String _name = "";
    private String _uuid = "";
    private boolean _controllerAvailable = false;
    private QueueManager _queue = new QueueManager();
    private boolean _isMonitored = false;
    private BufferedWriter _out = null;
    private String _outputFileName = null;
    private boolean _xmlFormat = true;
    private boolean loggingActive = false;
    private int _level = 0;
    private Plugin plugin = null;
    private boolean formatXMLOutput = true;
    private boolean firstFileWrite = false;
    private String processId = null;
    private String agentId = "";
    private String agentCreateTime = "";
    private int xmlDepth = 4;
    private int _archiveExpiryDays = 0;
    private Object currentThreadLock = new Object();

    public static AbstractMessageLoggerFactory getFactory() throws NoDefinedFactoryException {
        if (_factory == null) {
            throw new NoDefinedFactoryException(LoggingUtilities.getResourceString("GET_FACTORY_ERROR_"));
        }
        return _factory;
    }

    protected final synchronized void initialize(String string) throws IllegalArgumentException {
        if (LoggingUtilities.isValidLoggerName(string)) {
            this._name = string.trim();
            this.agentCreateTime = LoggingUtilities.currentTimeSeconds();
            this._uuid = this.agentId = "AGENT_CREATE".concat(".").concat(this._name).concat(".").concat(this.agentCreateTime);
            if (this._agent == null) {
                try {
                    this._agent = new LoggingAgent(this._name, "Logging");
                    this._agent.addAgentControllerListener(this);
                    this._agent.addMonitorListener(this);
                    this._agent.initialize();
                }
                catch (Throwable throwable) {
                    this._controllerAvailable = false;
                }
            }
            try {
                this.setMsgLoggerConfig(((IPluginHelper)this.plugin).getMsgLoggerConfig(this.plugin));
            }
            catch (Exception exception) {
                this.setMsgLoggerConfig(PluginHelperImpl.getMsgLoggerConfig(this._name));
            }
        } else {
            throw new IllegalArgumentException(LoggingUtilities.getResourceString("ILLEGAL_LOGGING_NAME_EXC_"));
        }
    }

    public static String printStackToString(Throwable throwable) {
        return LoggingUtilities.getThrowableStackTrace(throwable);
    }

    protected void checkEnvironment() {
    }

    public final AgentConfiguration getLoggingAgentDefaultConfiguration() {
        return this._agent.getDefaultConfiguration();
    }

    public final void agentControllerActive() {
        this._controllerAvailable = true;
    }

    public final void agentControllerInactive() {
        this._controllerAvailable = false;
    }

    public final void finalize() {
        this._agent.deregister();
    }

    public boolean isMonitored() {
        return this._isMonitored;
    }

    public boolean waitUntilMonitored(long l) {
        Object object = this.currentThreadLock;
        synchronized (object) {
            try {
                if (!this.isMonitored()) {
                    this.currentThreadLock.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.isMonitored();
    }

    public final void monitorActive() {
        this._queue.flushCurrentQueue(this._agent);
        this._isMonitored = true;
        Object object = this.currentThreadLock;
        synchronized (object) {
            this.currentThreadLock.notify();
        }
    }

    public final void monitorInactive() {
        this._isMonitored = false;
        if (this._queue.isFlushNeeded()) {
            this._queue.flushCurrentQueue(this._agent);
        }
    }

    public final boolean isLogging() {
        return this.loggingActive;
    }

    public final boolean isLoggingLevel(int n) {
        return this.isLogging() && Level.isValidLevel(n) && n <= this._level;
    }

    private void createXMLViewerFile() {
        if (this._outputFileName != null) {
            Object object;
            File file = new File(this._outputFileName);
            File file2 = new File(file.getAbsolutePath().concat("_Viewer.xml"));
            if (!file2.exists()) {
                try {
                    object = new BufferedWriter(new FileWriter(file2));
                    ((Writer)object).write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("<?xml-stylesheet type=\"text/xsl\" href=\"./" + file.getName() + "_Viewer.xsl\"?>");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("<!DOCTYPE document [");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("    <!ENTITY log SYSTEM \"./" + file.getName() + "\">");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("]>");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("<document>");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("    &log;");
                    ((BufferedWriter)object).newLine();
                    ((Writer)object).write("</document>");
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!((File)(object = new File(file.getAbsolutePath().concat("_Viewer.xsl")))).exists()) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((File)object));
                    bufferedWriter.newLine();
                    bufferedWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!DOCTYPE xsl:stylesheet [");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!ENTITY nbsp \"&#xA0;\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("]>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:output method=\"html\" encoding=\"ISO-8859-1\" indent=\"no\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!-- Template for the 'document' element: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:template match=\"document\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <html>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <body>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Iterate the first-level child elements of the 'document' element: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:for-each select=\"node()\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:apply-templates select=\".\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <br/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:for-each>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </body>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </html>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</xsl:template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!-- Template to recursively check attribute values for the tab (&#x9;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:template name=\"tabSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:param name=\"attributeValue\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Check if the attribute value contains a tab (&#x9;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:if test=\"contains($attributeValue,'&#x9;')\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the part of the attribute value before the tab (&#x9;) entity reference for a new line (&#xA;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"newlineSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"substring-before($attributeValue,'&#x9;')\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Substitute four spaces for a tab: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:text>&nbsp;&nbsp;&nbsp;&nbsp;</xsl:text>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the part of the attribute value after the tab (&#x9;) entity reference for other tab (&#x9;) entity references: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"tabSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"substring-after($attributeValue,'&#x9;')\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Check if the attribute value does not contain a tab (&#x9;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:if test=\"not(contains($attributeValue,'&#x9;'))\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the attribute value for a new line (&#xA;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"newlineSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"$attributeValue\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</xsl:template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!-- Template to recursively check attribute values for the new line (&#xA;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!-- Assumption:  All &#xD; entity references are replaced with &#xA; entity references by the XML parser: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:template name=\"newlineSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:param name=\"attributeValue\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Check if the attribute value contains a new line (&#xA;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:if test=\"contains($attributeValue,'&#xA;')\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the part of the attribute value before the new line (&#xA;) entity reference for a space (&#x20;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"spaceSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"substring-before($attributeValue,'&#xA;')\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Substitute <br/> for a new line: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <br/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the part of the attribute value after the new line (&#xA;) entity reference for other new line (&#xA;) entity references: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"newlineSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"substring-after($attributeValue,'&#xA;')\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Check if the attribute value does not contain a new line (&#xA;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:if test=\"not(contains($attributeValue,'&#xA;'))\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the attribute value for a space (&#x20;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"spaceSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"$attributeValue\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</xsl:template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!-- Template to recursively check attribute values for the space (&#x20;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:template name=\"spaceSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:param name=\"attributeValue\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Check if the attribute value contains a space (&#x20;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:if test=\"contains($attributeValue,'&#x20;')\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Output the attribute value before the space (&#x20;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:value-of select=\"substring-before($attributeValue,'&#x20;')\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Substitute &nbsp; for a space: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:text>&nbsp;</xsl:text>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Check the part of the attribute value after the space (&#x20;) entity reference for other space (&#x20;) entity references: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:call-template name=\"spaceSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("            <xsl:with-param name=\"attributeValue\" select=\"substring-after($attributeValue,'&#x20;')\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <!-- Check if the attribute value does not contain a space (&#x20;) entity reference: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("    <xsl:if test=\"not(contains($attributeValue,'&#x20;'))\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <!-- Output the attribute value: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("        <xsl:value-of select=\"$attributeValue\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("    </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</xsl:template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("<!-- Template for elements: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("<xsl:template match=\"*\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <!-- Indent nested open tag: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <xsl:for-each select=\"ancestor::*\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <xsl:text>&nbsp;&nbsp;</xsl:text>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      </xsl:for-each>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <font color=\"blue\">&lt;</font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <!-- Output element name: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <font color=\"brown\"><xsl:value-of select=\"name()\"/></font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <!-- Iterate all attributes: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <xsl:for-each select=\"@*\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <xsl:text>&nbsp;</xsl:text>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <!-- Output attribute name: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"brown\"><xsl:value-of select=\"name()\"/></font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"blue\">=\"</font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <b>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("              <xsl:element name=\"{name()}\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("                  <!-- Recursively check attribute value for known entity references: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("                  <xsl:call-template name=\"tabSubstitution\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("                      <xsl:with-param name=\"attributeValue\" select=\".\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("                  </xsl:call-template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("              </xsl:element>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          </b>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <xsl:text>\"</xsl:text>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      </xsl:for-each>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <!-- End the empty tag if no nested elements: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <xsl:if test=\"not(descendant::*)\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"blue\">/&gt;</font>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("      </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <xsl:if test=\"descendant::*\">");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"blue\">&gt;</font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <br/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <!-- Iterate the first-level child elements of this current element: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <xsl:for-each select=\"node()\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("              <xsl:apply-templates select=\".\"/>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          </xsl:for-each>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <!-- Indent nested close tag: -->");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <xsl:for-each select=\"ancestor::*\">");
                    bufferedWriter.newLine();
                    bufferedWriter.write("              <xsl:text>&nbsp;&nbsp;</xsl:text>");
                    bufferedWriter.newLine();
                    bufferedWriter.write("          </xsl:for-each>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"blue\">&lt;/</font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"brown\"><xsl:value-of select=\"name()\"/></font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("          <font color=\"blue\">&gt;</font>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      </xsl:if>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("      <br/>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</xsl:template>");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("</xsl:stylesheet>");
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void deleteXMLViewerFile() {
        if (this._outputFileName != null) {
            File file;
            File file2 = new File(this._outputFileName);
            File file3 = new File(file2.getAbsolutePath().concat("_Viewer.xml"));
            if (file3.exists()) {
                try {
                    file3.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((file = new File(file2.getAbsolutePath().concat("_Viewer.xsl"))).exists()) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void outputFileWrite(String string) {
        try {
            this.openFile();
            BufferedWriter bufferedWriter = this._out;
            synchronized (bufferedWriter) {
                this._out.write(string);
                this._out.newLine();
                this._out.flush();
            }
        }
        catch (Exception exception) {
            System.err.println("");
            System.err.println(LoggingUtilities.getResourceString("ERROR_UI_") + "   " + LoggingUtilities.getResourceString("WRITE_MESSAGE_WRITING_ERROR_", this._outputFileName));
            System.err.println(LoggingUtilities.getResourceString("REASON_UI_") + "  " + exception);
            System.err.println(LoggingUtilities.getResourceString("RESULT_UI_") + "  " + LoggingUtilities.getResourceString("LOG_TO_STDOUT_INFO_"));
            System.err.println(LoggingUtilities.getResourceString("MESSAGE_UI_") + " " + string);
            System.err.println("");
            this.setFileName(null);
        }
    }

    private void createProcessId() {
        this.processId = this._outputFileName != null ? LoggingUtilities.getProcessId(this._outputFileName) : null;
    }

    public void write(int n, boolean bl) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(bl, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(bl));
            }
        }
    }

    public void write(boolean bl) {
        this.write(7, bl);
    }

    public void write(int n, char c) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(c, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(c));
            }
        }
    }

    public void write(char c) {
        this.write(7, c);
    }

    public void write(int n, byte by) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(by, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(by));
            }
        }
    }

    public void write(byte by) {
        this.write(7, by);
    }

    public void write(int n, short s) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(s, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(s));
            }
        }
    }

    public void write(short s) {
        this.write(7, s);
    }

    public void write(int n, int n2) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(n2, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(n2));
            }
        }
    }

    public void write(int n) {
        this.write(7, n);
    }

    public void write(int n, long l) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(l, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(l));
            }
        }
    }

    public void write(long l) {
        this.write(7, l);
    }

    public void write(int n, float f) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(f, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(f));
            }
        }
    }

    public void write(float f) {
        this.write(7, f);
    }

    public void write(int n, double d) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(XMLGenerator.primitiveToXML(d, this.agentId, Level.getLevelName(n)));
            } else {
                this.writeMessage(String.valueOf(d));
            }
        }
    }

    public void write(double d) {
        this.write(7, d);
    }

    public void write(DefaultRecord defaultRecord) {
        if (defaultRecord != null) {
            this.write(defaultRecord.getSeverity(), defaultRecord);
        } else {
            this.write(7, defaultRecord);
        }
    }

    public void write(int n, Object object) {
        if (this.isLoggingLevel(n)) {
            if (this._xmlFormat) {
                this.writeMessage(new XMLGenerator(this.agentId, Level.getLevelName(n), this.formatXMLOutput, this.xmlDepth).objectToXML(object));
            } else {
                this.writeMessage(LoggingUtilities.objectToString(object));
            }
        }
    }

    public void write(Object object) {
        this.write(7, object);
    }

    public final void writeCurrentThread() {
        this.write(7, Thread.currentThread());
    }

    private final void writeMessage(String string) {
        try {
            if (this._controllerAvailable && this._isMonitored) {
                this._agent.logMessageUTF8(string);
            } else {
                this._queue.insertInQueue(string);
            }
            if (this._outputFileName != null) {
                if (this.firstFileWrite) {
                    LoggingUtilities.archiveFile(this._outputFileName);
                    LoggingUtilities.deleteArchivedFiles(this._outputFileName, this._archiveExpiryDays);
                    if (this._xmlFormat) {
                        this.createProcessId();
                        StringBuffer stringBuffer = new StringBuffer("<");
                        stringBuffer.append("AGENT_CREATE");
                        stringBuffer.append(" ");
                        stringBuffer.append("logging.util.agent_id");
                        stringBuffer.append("=\"" + this.agentId + "\" ");
                        stringBuffer.append("logging.util.agent_version");
                        stringBuffer.append("=\"1.000\" ");
                        if (this.processId != null) {
                            stringBuffer.append("logging.util.process_idref");
                            stringBuffer.append("=\"" + this.processId + "\" ");
                        }
                        stringBuffer.append("logging.util.agent_name");
                        stringBuffer.append("=\"" + this._name + "\" ");
                        stringBuffer.append("logging.util.agent_type");
                        stringBuffer.append("=\"Logging\" ");
                        stringBuffer.append("logging.util.agent_parameters");
                        stringBuffer.append("=\"\" ");
                        stringBuffer.append("logging.util.time");
                        stringBuffer.append("=\"" + this.agentCreateTime + "\"");
                        stringBuffer.append("/>");
                        this.outputFileWrite(stringBuffer.toString());
                        this.createXMLViewerFile();
                    } else {
                        this.deleteXMLViewerFile();
                    }
                    this.firstFileWrite = false;
                }
                this.outputFileWrite(string);
            } else if (!this._isMonitored) {
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            System.err.println("");
            System.err.println(LoggingUtilities.getResourceString("ERROR_UI_") + "   " + LoggingUtilities.getResourceString("WRITE_MESSAGE_AGENT_ERROR_"));
            System.err.println(LoggingUtilities.getResourceString("REASON_UI_") + "  " + exception);
            System.err.println(LoggingUtilities.getResourceString("RESULT_UI_") + "  " + LoggingUtilities.getResourceString("LOG_TO_STDOUT_INFO_"));
            System.err.println(LoggingUtilities.getResourceString("MESSAGE_UI_") + " " + string);
            System.err.println("");
            this.setFileName(null);
        }
    }

    public Hashtable getMsgLoggerConfig() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("name", this._name);
        hashtable.put("level", Level.getTranslatedLevelName(this._level));
        hashtable.put("xml", String.valueOf(this._xmlFormat));
        if (this._outputFileName != null) {
            hashtable.put("file", this._outputFileName);
        }
        hashtable.put("archiveExpiryDays", String.valueOf(this._archiveExpiryDays));
        return hashtable;
    }

    public void setMsgLoggerConfig(Hashtable hashtable) {
        if (hashtable != null) {
            String string = (String)hashtable.get("level");
            if (string == null) {
                string = (String)hashtable.get("defaultLevel");
            }
            if (Level.isValidLevel(string)) {
                this.setLevel(Level.getLevel(string));
            }
            if ((string = (String)hashtable.get("archiveExpiryDays")) == null) {
                string = (String)hashtable.get("defaultArchiveExpiryDays");
            }
            if (string != null) {
                try {
                    this.setArchiveExpiryDays(Integer.parseInt(string.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string = (String)hashtable.get("file")) != null) {
                this.setFileName(string.trim());
            }
            if ((string = (String)hashtable.get("xml")) != null) {
                if (string.trim().equalsIgnoreCase(Boolean.TRUE.toString())) {
                    this.setXMLFormat(true);
                } else if (string.trim().equalsIgnoreCase(Boolean.FALSE.toString())) {
                    this.setXMLFormat(false);
                }
            }
        }
    }

    public final int getArchiveExpiryDays() {
        return this._archiveExpiryDays;
    }

    public final void setArchiveExpiryDays(int n) {
        this._archiveExpiryDays = n;
    }

    public final boolean getFormatXMLOutput() {
        return this.formatXMLOutput;
    }

    public final void setFormatXMLOutput(boolean bl) {
        this.formatXMLOutput = bl;
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    protected final void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public final String getName() {
        return this._name;
    }

    public final synchronized void setLevel(int n) throws IllegalArgumentException {
        if (Level.isValidLevel(n)) {
            this._level = n;
            if (this._level == 0) {
                this.setActive(false);
            } else {
                this.setActive(true);
            }
        } else {
            throw new IllegalArgumentException(LoggingUtilities.getResourceString("ILLEGAL_LOGGING_LEVEL_EXC_"));
        }
    }

    public final int getLevel() {
        return this._level;
    }

    public void setXMLDepth(int n) {
        this.xmlDepth = n;
    }

    public int getXMLDepth() {
        return this.xmlDepth;
    }

    public boolean getXMLFormat() {
        return this._xmlFormat;
    }

    public void setXMLFormat(boolean bl) {
        this._xmlFormat = bl;
    }

    public String getFileName() {
        return this._outputFileName;
    }

    public synchronized void setFileName(String string) {
        if (string != null && !string.trim().equals("")) {
            File file = new File(string);
            if (file.getParent() == null && LoggingUtilities.isWorkbench() && Constants.WORKBENCH_METADATA_DIRECTORY != null) {
                string = Constants.WORKBENCH_METADATA_DIRECTORY.concat(string.trim());
            }
            this.closeFile();
            this._outputFileName = string.trim();
            this.firstFileWrite = true;
        } else {
            this.closeFile();
            this._outputFileName = null;
        }
    }

    private synchronized void openFile() {
        if (this._outputFileName == null) {
            this._out = null;
        } else if (this._out == null) {
            this._out = LoggingUtilities.getFileHandle(this._outputFileName);
            if (this._out == null) {
                this._outputFileName = null;
            }
        }
    }

    public synchronized void closeFile() {
        if (this._outputFileName != null) {
            LoggingUtilities.closeFileHandle(this._outputFileName);
        }
        this._out = null;
    }

    public final boolean isActive() {
        return this.loggingActive;
    }

    public void setActive(boolean bl) {
        this.loggingActive = bl;
        if (!this.loggingActive) {
            this.closeFile();
        }
    }
}

