/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.util.LoggingUtilities;

public final class Level {
    public static final String levelCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2001 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String[] LEVELNAMES = new String[]{"NONE", "CONFIG", "INFO", "WARNING", "SEVERE", "FINE", "FINER", "FINEST"};
    private static final String[] TRANSLATEDLEVELNAMES = new String[]{LoggingUtilities.getResourceString("LOGGING_LEVEL_NONE"), LoggingUtilities.getResourceString("LOGGING_LEVEL_CONFIG"), LoggingUtilities.getResourceString("LOGGING_LEVEL_INFO"), LoggingUtilities.getResourceString("LOGGING_LEVEL_WARNING"), LoggingUtilities.getResourceString("LOGGING_LEVEL_SEVERE"), LoggingUtilities.getResourceString("LOGGING_LEVEL_FINE"), LoggingUtilities.getResourceString("LOGGING_LEVEL_FINER"), LoggingUtilities.getResourceString("LOGGING_LEVEL_FINEST")};
    public static final int NONE = 0;
    public static final int CONFIG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int SEVERE = 4;
    public static final int FINE = 5;
    public static final int FINER = 6;
    public static final int FINEST = 7;

    public static boolean isValidLevel(int n) {
        return n >= 0 && n <= 7;
    }

    public static boolean isValidLevel(String string) {
        return Level.isValidLevel(Level.getLevel(string));
    }

    public static int getLevel(String string) {
        if (string != null && string.trim().length() != 0) {
            String string2 = string.trim();
            if (string2.startsWith("%")) {
                string2 = string2.substring(1);
            }
            string2 = LoggingUtilities.getResourceString(string2).trim();
            int n = 0;
            while (n < LEVELNAMES.length) {
                if (string2.equalsIgnoreCase(LEVELNAMES[n])) {
                    return n;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < TRANSLATEDLEVELNAMES.length) {
                if (string2.equalsIgnoreCase(TRANSLATEDLEVELNAMES[n2])) {
                    return n2;
                }
                ++n2;
            }
            try {
                int n3 = Integer.parseInt(string);
                if (Level.isValidLevel(n3)) {
                    return n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String getLevelName(int n) {
        if (Level.isValidLevel(n)) {
            return LEVELNAMES[n];
        }
        return null;
    }

    public static String getTranslatedLevelName(int n) {
        if (Level.isValidLevel(n)) {
            return TRANSLATEDLEVELNAMES[n];
        }
        return null;
    }

    public static String getTranslatedLevelName(String string) {
        return Level.getTranslatedLevelName(Level.getLevel(string));
    }

    public static String[] getLevelNames() {
        return LEVELNAMES;
    }

    public static String[] getTranslatedLevelNames() {
        return TRANSLATEDLEVELNAMES;
    }
}

