/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.util.Constants;
import com.ibm.etools.logging.util.IPluginHelper;
import com.ibm.etools.logging.util.Level;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class PluginHelperImpl
implements IPluginHelper {
    public static final String pluginHelperImplCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2001 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public void setMsgLoggerConfig(Hashtable hashtable) {
    }

    public static String getMsgLoggerName(Plugin plugin) {
        if (plugin != null) {
            try {
                String string;
                String string2;
                IConfigurationElement iConfigurationElement;
                int n;
                IConfigurationElement[] iConfigurationElementArray;
                String string3;
                String string4 = string3 = plugin.getDescriptor().getUniqueIdentifier().trim();
                IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
                IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("com.ibm.etools.logging.util", "loggingDefaults");
                if (iExtensionPoint != null) {
                    iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                    n = 0;
                    while (n < iConfigurationElementArray.length) {
                        iConfigurationElement = iConfigurationElementArray[n];
                        string2 = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                        if (string2.trim().equals("com.ibm.etools.logging.util") && (string = iConfigurationElement.getAttribute("name")) != null) {
                            string4 = string;
                            break;
                        }
                        ++n;
                    }
                }
                iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("com.ibm.etools.logging.util", "loggingOptions");
                n = 0;
                while (n < iConfigurationElementArray.length) {
                    iConfigurationElement = iConfigurationElementArray[n];
                    string2 = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                    if (string2.trim().equals(string3) && (string = iConfigurationElement.getAttribute("name")) != null) {
                        string4 = string;
                        break;
                    }
                    ++n;
                }
                return string4.trim();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "Default Logging Agent";
    }

    public static Hashtable getMsgLoggerConfig(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            String string2 = System.getProperty(string.replace(' ', '_') + "." + "level");
            if (Level.isValidLevel(string2)) {
                hashtable.put("level", Level.getTranslatedLevelName(string2));
            }
            if ((string2 = System.getProperty(string.replace(' ', '_') + "." + "file")) != null) {
                hashtable.put("file", string2.trim());
            }
            if ((string2 = System.getProperty(string.replace(' ', '_') + "." + "archiveExpiryDays")) != null) {
                try {
                    hashtable.put("archiveExpiryDays", Integer.valueOf(string2.trim()).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = System.getProperty(string.replace(' ', '_') + "." + "xml")) != null && (string2.trim().equalsIgnoreCase(Boolean.TRUE.toString()) || string2.trim().equalsIgnoreCase(Boolean.FALSE.toString()))) {
                hashtable.put("xml", string2.trim());
            }
        }
        return hashtable;
    }

    public Hashtable getMsgLoggerConfig(Plugin plugin) {
        String string = PluginHelperImpl.getMsgLoggerName(plugin);
        Hashtable hashtable = PluginHelperImpl.getMsgLoggerConfig(string);
        try {
            File file;
            String string2;
            String string3;
            IConfigurationElement iConfigurationElement;
            IConfigurationElement[] iConfigurationElementArray;
            IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
            IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("com.ibm.etools.logging.util", "loggingDefaults");
            if (iExtensionPoint != null) {
                iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    iConfigurationElement = iConfigurationElementArray[n];
                    string3 = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                    if (string3.trim().equals("com.ibm.etools.logging.util")) {
                        string2 = iConfigurationElement.getAttribute("level");
                        if (Level.isValidLevel(string2)) {
                            hashtable.put("defaultLevel", Level.getTranslatedLevelName(string2));
                        }
                        if ((string2 = iConfigurationElement.getAttribute("file")) != null) {
                            hashtable.put("file", string2.trim());
                        }
                        if ((string2 = iConfigurationElement.getAttribute("archiveExpiryDays")) != null) {
                            try {
                                hashtable.put("defaultArchiveExpiryDays", Integer.valueOf(string2.trim()).toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((string2 = iConfigurationElement.getAttribute("xml")) == null || !string2.trim().equalsIgnoreCase(Boolean.TRUE.toString()) && !string2.trim().equalsIgnoreCase(Boolean.FALSE.toString())) break;
                        hashtable.put("xml", string2.trim());
                        break;
                    }
                    ++n;
                }
            }
            if (plugin != null) {
                String string4 = plugin.getDescriptor().getUniqueIdentifier().trim();
                iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor("com.ibm.etools.logging.util", "loggingOptions");
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    iConfigurationElement = iConfigurationElementArray[n];
                    string3 = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
                    if (string3.trim().equals(string4)) {
                        string2 = iConfigurationElement.getAttribute("level");
                        if (Level.isValidLevel(string2)) {
                            hashtable.put("level", Level.getTranslatedLevelName(string2));
                        }
                        if ((string2 = iConfigurationElement.getAttribute("file")) != null) {
                            hashtable.put("file", string2.trim());
                        }
                        if ((string2 = iConfigurationElement.getAttribute("archiveExpiryDays")) != null) {
                            try {
                                hashtable.put("archiveExpiryDays", Integer.valueOf(string2.trim()).toString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((string2 = iConfigurationElement.getAttribute("xml")) == null || !string2.trim().equalsIgnoreCase(Boolean.TRUE.toString()) && !string2.trim().equalsIgnoreCase(Boolean.FALSE.toString())) break;
                        hashtable.put("xml", string2.trim());
                        break;
                    }
                    ++n;
                }
            }
            if ((file = Platform.getLocation().addTrailingSeparator().append(Constants.LOGGING_UI_PREFSTORE_PATH).toFile()).length() > 0L) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                string2 = properties.getProperty(string.concat(".").concat("level"));
                if (Level.isValidLevel(string2)) {
                    hashtable.put("level", Level.getTranslatedLevelName(string2));
                }
                if (Level.isValidLevel(string2 = properties.getProperty("LoggingOptions.workbenchLevel"))) {
                    hashtable.put("defaultLevel", Level.getTranslatedLevelName(string2));
                }
                if ((string2 = properties.getProperty("LoggingOptions.archiveDays")) != null) {
                    try {
                        hashtable.put("defaultArchiveExpiryDays", Integer.valueOf(string2.trim()).toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }
}

