/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.StringTokenizer;

public class TimerStep {
    public static final String timerStepCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2001 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int _isLoaded;
    private boolean _autoMemory = true;
    private String _logFile = "c:\\";
    private Runtime _runtime;
    private boolean _pause = false;
    private boolean _sysout = false;
    private long[] _times = new long[5];
    private int _testd = 0;
    private boolean _isOn = this.processEnvironmentVariables();
    private String _prefix;
    private int _runId;
    private String _var;
    private static TimerStep _me;
    private static final int[] _whatIndex;
    private static final String LOG_FILE = "timer.del";
    private static final String ENV_PERF_CTRL = "etools_perf_ctrl";
    private static final String NATIVE_LIBRARY_NAME = "ivjperf";
    public static final String WHAT_ELAPSED = "1";
    public static final String WHAT_TOTAL_JAVA_HEAP = "2";
    public static final String WHAT_USED_JAVA_HEAP = "3";

    public static void main(String[] stringArray) {
        System.out.println("Id = $Id: TimerStep.java,v 1.16 2002/06/05 20:51:15 gary Exp $");
    }

    public TimerStep() {
        if (this._isOn) {
            this._times[0] = System.currentTimeMillis();
            this._times[1] = this._times[0];
            this._times[2] = this._times[0];
            this._times[3] = this._times[0];
            this._times[4] = this._times[0];
            if (this._testd == 0) {
                this._testd = (int)this._times[0];
            }
            this._runId = (int)this._times[0];
            this._runtime = Runtime.getRuntime();
            StringBuffer stringBuffer = new StringBuffer(30);
            stringBuffer.append(this._testd);
            stringBuffer.append(',');
            stringBuffer.append(this._runId);
            stringBuffer.append(',');
            this._prefix = stringBuffer.toString();
        }
    }

    public static TimerStep instance() {
        if (_me == null) {
            _me = new TimerStep();
        }
        return _me;
    }

    private boolean processEnvironmentVariables() {
        String string = System.getProperty(ENV_PERF_CTRL);
        if (string == null) {
            return false;
        }
        this._testd = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("log=")) {
                this._logFile = new File(string3.substring(4), LOG_FILE).getAbsolutePath();
                continue;
            }
            if (string3.startsWith("sysout=")) {
                string2 = string3.substring(7);
                if (!string2.equals("true")) continue;
                this._sysout = true;
                continue;
            }
            if (string3.startsWith("testd=")) {
                this._testd = Integer.parseInt(string3.substring(6));
                continue;
            }
            if (string3.startsWith("pause=")) {
                string2 = string3.substring(6);
                if (!string2.equals("true")) continue;
                this._pause = true;
                continue;
            }
            if (!string3.startsWith("var=")) continue;
            this._var = string3.substring(4);
        }
        return true;
    }

    private static boolean isLoaded() {
        if (_isLoaded == 2) {
            return true;
        }
        if (_isLoaded == 1) {
            return false;
        }
        try {
            System.loadLibrary(NATIVE_LIBRARY_NAME);
            _isLoaded = 2;
        }
        catch (Throwable throwable) {
            _isLoaded = 1;
        }
        return _isLoaded == 2;
    }

    private static boolean getPerformanceCounters(long[] lArray) {
        if (!TimerStep.isLoaded()) {
            return false;
        }
        return TimerStep.nativeGetPerformanceCounters(lArray);
    }

    private static native boolean nativeGetPerformanceCounters(long[] var0);

    private void pause() {
        System.out.println("The current thread has been paused by TimerStep, press enter to have it continue");
        byte[] byArray = new byte[200];
        try {
            System.in.read(byArray);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public void reset(int n) {
        if (!this._isOn) {
            return;
        }
        this._times[n] = System.currentTimeMillis();
    }

    public void totalMemory(int n) {
        if (!this._isOn) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(n);
        stringBuffer.append(",2,");
        stringBuffer.append(this._runtime.totalMemory());
        this.write(stringBuffer.toString(), this._prefix);
    }

    public void usedMemory(int n) {
        if (!this._isOn) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(n);
        stringBuffer.append(",3,");
        this._runtime.gc();
        stringBuffer.append(this._runtime.totalMemory() - this._runtime.freeMemory());
        this.write(stringBuffer.toString(), this._prefix);
    }

    public void write(int n, int n2) {
        if (!this._isOn) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(n2);
        stringBuffer.append(",1,");
        long l = System.currentTimeMillis() - this._times[n];
        stringBuffer.append(l);
        this.write(stringBuffer.toString(), this._prefix);
        if (this._autoMemory) {
            this.writeCounters(n2);
            this.totalMemory(n2);
        }
    }

    private void write(String string, String string2) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileOutputStream(this._logFile, true));
                printWriter.print(string2);
                printWriter.println(string);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                Object var6_5 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
            }
            Object var6_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            printWriter = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            printWriter = null;
            throw throwable;
        }
        if (this._sysout) {
            System.out.println("TimerStep " + new Timestamp(System.currentTimeMillis()).toString() + " - " + string);
        }
    }

    public void writeEnvironment(String string) {
        if (!this._isOn) {
            return;
        }
        this.write("Driver=" + string, "");
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            this.write("Host=" + string2, "");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.write("RunTS=" + System.currentTimeMillis(), "");
        if (this._var != null) {
            this.write("Var=" + this._var, "");
        }
    }

    public void writeAndReset(int n, int n2) {
        if (!this._isOn) {
            return;
        }
        this.write(n, n2);
        this._times[n] = System.currentTimeMillis();
    }

    public void writeCounters(int n) {
        if (!this._isOn) {
            return;
        }
        long[] lArray = new long[_whatIndex.length];
        if (TimerStep.getPerformanceCounters(lArray)) {
            StringBuffer stringBuffer = new StringBuffer(50);
            int n2 = 0;
            while (n2 < _whatIndex.length) {
                stringBuffer.setLength(0);
                stringBuffer.append(n);
                stringBuffer.append(',');
                stringBuffer.append(_whatIndex[n2]);
                stringBuffer.append(',');
                stringBuffer.append(lArray[n2]);
                this.write(stringBuffer.toString(), this._prefix);
                ++n2;
            }
        }
        if (this._pause) {
            this.pause();
        }
    }

    public boolean getSysout() {
        return this._sysout;
    }

    public void setSysout(boolean bl) {
        this._sysout = bl;
    }

    public boolean getAutoMemory() {
        return this._autoMemory;
    }

    public void setAutoMemory(boolean bl) {
        this._autoMemory = bl;
    }

    public boolean is_pause() {
        return this._pause;
    }

    public void set_pause(boolean bl) {
        this._pause = bl;
    }

    static {
        _whatIndex = new int[]{4, 8, 9, 10, 11};
    }
}

