/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util;

import com.ibm.etools.logging.util.Constants;
import com.ibm.etools.logging.util.LoggingUtilities;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

final class XMLGenerator {
    public static final String xmlGeneratorCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2000, 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String lineSeparator = null;
    private String loggingLevel = null;
    private String loggerName = null;
    private boolean format;
    private int currentLevel;
    private int maxLevels;
    private Hashtable loggedObjects = null;

    protected XMLGenerator(String string, String string2, boolean bl, int n) {
        this.loggerName = string;
        this.loggingLevel = string2;
        this.format = bl;
        this.maxLevels = n;
    }

    protected String objectToXML(Object object) {
        if (object == null) {
            return this.nullObjectToXML(null, null, this.loggerName, this.loggingLevel, null);
        }
        if (this.getType(object.getClass()) == 1) {
            return this.simpleObjectToXML(object, null, this.loggerName, this.loggingLevel, null);
        }
        this.lineSeparator = this.format ? Constants.LINESEPARATOR : "";
        this.currentLevel = -1;
        this.loggedObjects = new Hashtable();
        return this.createXMLTag(object, null).toString().trim();
    }

    private StringBuffer createXMLTag(Object objectArray, String string) {
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indention(++this.currentLevel));
        if (objectArray == null) {
            if (this.currentLevel == 0) {
                stringBuffer.append(this.nullObjectToXML(null, null, this.loggerName, this.loggingLevel, string));
            } else {
                stringBuffer.append(this.nullObjectToXML(null, null, null, null, string));
            }
            stringBuffer.append(this.lineSeparator);
            return stringBuffer;
        }
        Class<?> clazz = objectArray.getClass();
        if (clazz.isArray()) {
            string3 = "Array";
            string2 = string3.concat(this.getClassName(clazz));
        } else {
            string2 = clazz.getName().trim();
            string3 = this.removeTagNameChars(string2.substring(string2.lastIndexOf(46) + 1));
        }
        if (this.loggedObjects.containsKey(objectArray)) {
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(" ");
            stringBuffer.append("logging.util.idref");
            stringBuffer.append("=\"");
            stringBuffer.append(this.loggedObjects.get(objectArray));
            stringBuffer.append("\"/>");
            stringBuffer.append(this.lineSeparator);
            return stringBuffer;
        }
        String string4 = this.getUniqueId(string2);
        this.loggedObjects.put(objectArray, string4);
        if (this.getType(clazz) == 1) {
            if (this.currentLevel == 0) {
                stringBuffer.append(this.simpleObjectToXML(objectArray, string4, this.loggerName, this.loggingLevel, string));
            } else {
                stringBuffer.append(this.simpleObjectToXML(objectArray, string4, null, null, string));
            }
            stringBuffer.append(this.lineSeparator);
        } else if (objectArray instanceof EventQueue) {
            if (this.currentLevel == 0) {
                stringBuffer.append("<");
                stringBuffer.append(string3);
                stringBuffer.append(this.getNameAttribute(string));
                stringBuffer.append(this.getIdAttribute(string4));
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
                stringBuffer.append("/>");
            } else {
                stringBuffer.append("<");
                stringBuffer.append(string3);
                stringBuffer.append(this.getNameAttribute(string));
                stringBuffer.append(this.getIdAttribute(string4));
                stringBuffer.append("/>");
            }
            stringBuffer.append(this.lineSeparator);
        } else if (clazz.isArray() || objectArray instanceof Collection || objectArray instanceof Enumeration || objectArray instanceof Iterator) {
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(this.getIdAttribute(string4));
            if (!clazz.isArray()) {
                Vector vector;
                if (objectArray instanceof Collection) {
                    objectArray = ((Collection)objectArray).toArray();
                } else if (objectArray instanceof Enumeration) {
                    vector = new Vector();
                    while (((Enumeration)objectArray).hasMoreElements()) {
                        vector.add(((Enumeration)objectArray).nextElement());
                    }
                    objectArray = vector.toArray();
                } else if (objectArray instanceof Iterator) {
                    vector = new Vector();
                    while (((Iterator)objectArray).hasNext()) {
                        vector.add(((Iterator)objectArray).next());
                    }
                    objectArray = vector.toArray();
                }
            }
            if (this.currentLevel == 0) {
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
            }
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            if (objectArray instanceof boolean[]) {
                int n = 0;
                while (n < ((boolean[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((boolean[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof char[]) {
                int n = 0;
                while (n < ((char[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((char[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof byte[]) {
                int n = 0;
                while (n < ((byte[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((byte[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof short[]) {
                int n = 0;
                while (n < ((short[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((short[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof int[]) {
                int n = 0;
                while (n < ((int[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((int[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof long[]) {
                int n = 0;
                while (n < ((long[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((long[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof float[]) {
                int n = 0;
                while (n < ((float[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((float[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (objectArray instanceof double[]) {
                int n = 0;
                while (n < ((double[])objectArray).length) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(XMLGenerator.primitiveToXML(((double[])objectArray)[n]));
                    stringBuffer.append(this.lineSeparator);
                    ++n;
                }
            } else if (this.currentLevel == this.maxLevels) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.getEndOfNestingTag());
            } else {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] == null) {
                        stringBuffer.append(this.indention(this.currentLevel + 1));
                        if (this.currentLevel + 1 == 0) {
                            stringBuffer.append(this.nullObjectToXML(clazz.getComponentType().getName().trim(), string4, this.loggerName, this.loggingLevel, string));
                        } else {
                            stringBuffer.append(this.nullObjectToXML(clazz.getComponentType().getName().trim(), string4, null, null, string));
                        }
                        stringBuffer.append(this.lineSeparator);
                    } else {
                        stringBuffer.append((Object)this.createXMLTag(objectArray[n], null));
                        --this.currentLevel;
                    }
                    ++n;
                }
            }
            stringBuffer.append(this.indention(this.currentLevel));
            stringBuffer.append("</");
            stringBuffer.append(string3);
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
        } else if (objectArray instanceof Thread) {
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(this.getIdAttribute(string4));
            if (this.currentLevel == 0) {
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
            }
            stringBuffer.append(" Name=\"");
            stringBuffer.append(((Thread)objectArray).getName().trim());
            stringBuffer.append("\"");
            stringBuffer.append(" Priority=\"");
            stringBuffer.append(((Thread)objectArray).getPriority());
            stringBuffer.append("\"");
            stringBuffer.append(" Group=\"");
            stringBuffer.append(((Thread)objectArray).getThreadGroup().getName().trim());
            stringBuffer.append("\">");
            stringBuffer.append(this.lineSeparator);
            StringTokenizer stringTokenizer = new StringTokenizer(LoggingUtilities.getThreadStackTrace((Thread)objectArray), Constants.LINESEPARATOR);
            stringTokenizer.nextToken();
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(this.simpleObjectToXML(stringTokenizer.nextToken().trim(), null, null, null, string));
                    stringBuffer.append(this.lineSeparator);
                }
            }
            catch (Exception exception) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.simpleObjectToXML(LoggingUtilities.getThreadStackTrace((Thread)objectArray), null, null, null, string));
                stringBuffer.append(this.lineSeparator);
            }
            stringBuffer.append(this.indention(this.currentLevel));
            stringBuffer.append("</");
            stringBuffer.append(string3);
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
        } else if (objectArray instanceof Throwable) {
            String string5;
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(this.getIdAttribute(string4));
            if (this.currentLevel == 0) {
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
            }
            if ((string5 = ((Throwable)objectArray).getMessage()) != null) {
                stringBuffer.append(" Message=\"");
                stringBuffer.append(string5);
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            StringTokenizer stringTokenizer = new StringTokenizer(LoggingUtilities.getThrowableStackTrace((Throwable)objectArray), Constants.LINESEPARATOR);
            stringTokenizer.nextToken();
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(this.simpleObjectToXML(stringTokenizer.nextToken().trim(), null, null, null, string));
                    stringBuffer.append(this.lineSeparator);
                }
            }
            catch (Exception exception) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.simpleObjectToXML(LoggingUtilities.getThrowableStackTrace((Throwable)objectArray), null, null, null, string));
                stringBuffer.append(this.lineSeparator);
            }
            stringBuffer.append(this.indention(this.currentLevel));
            stringBuffer.append("</");
            stringBuffer.append(string3);
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
        } else if (objectArray instanceof Map) {
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(this.getIdAttribute(string4));
            if (this.currentLevel == 0) {
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
            }
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            if (this.currentLevel == this.maxLevels) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.getEndOfNestingTag());
            } else {
                Iterator iterator = ((Map)objectArray).keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append("<Entry>");
                    stringBuffer.append(this.lineSeparator);
                    stringBuffer.append(this.indention(this.currentLevel + 2));
                    stringBuffer.append("<Key>");
                    stringBuffer.append(this.lineSeparator);
                    stringBuffer.append(this.indention(this.currentLevel + 3));
                    stringBuffer.append((Object)this.createXMLTag(k, null));
                    --this.currentLevel;
                    stringBuffer.append(this.indention(this.currentLevel + 2));
                    stringBuffer.append("</Key>");
                    stringBuffer.append(this.lineSeparator);
                    stringBuffer.append(this.indention(this.currentLevel + 2));
                    stringBuffer.append("<Value>");
                    stringBuffer.append(this.lineSeparator);
                    stringBuffer.append(this.indention(this.currentLevel + 3));
                    stringBuffer.append((Object)this.createXMLTag(((Map)objectArray).get(k), null));
                    --this.currentLevel;
                    stringBuffer.append(this.indention(this.currentLevel + 2));
                    stringBuffer.append("</Value>");
                    stringBuffer.append(this.lineSeparator);
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append("</Entry>");
                    stringBuffer.append(this.lineSeparator);
                }
            }
            stringBuffer.append(this.indention(this.currentLevel));
            stringBuffer.append("</");
            stringBuffer.append(string3);
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
        } else if (objectArray instanceof Class) {
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(this.getIdAttribute(string4));
            if (this.currentLevel == 0) {
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
            }
            stringBuffer.append(" Name=\"");
            stringBuffer.append(this.getClassName((Class)objectArray));
            stringBuffer.append("\"");
            stringBuffer.append(" Type=\"");
            if (((Class)objectArray).isPrimitive()) {
                stringBuffer.append("primitive");
            } else if (((Class)objectArray).isArray()) {
                stringBuffer.append("array");
            } else if (((Class)objectArray).isInterface()) {
                stringBuffer.append("interface");
            } else {
                stringBuffer.append("class");
            }
            stringBuffer.append("\"");
            stringBuffer.append(" Package=\"");
            try {
                stringBuffer.append(((Class)objectArray).getPackage().getName());
            }
            catch (Exception exception) {
                stringBuffer.append("null");
            }
            stringBuffer.append("\"");
            stringBuffer.append(" Modifers=\"");
            stringBuffer.append(Modifier.toString(((Class)objectArray).getModifiers()));
            stringBuffer.append("\"");
            stringBuffer.append(" Superclass=\"");
            try {
                stringBuffer.append(this.getClassName(((Class)objectArray).getSuperclass()));
            }
            catch (Exception exception) {
                stringBuffer.append("null");
            }
            stringBuffer.append("\"/>");
            stringBuffer.append(this.lineSeparator);
        } else {
            Object object;
            Method method2;
            String string6;
            Vector<Method> vector = new Vector<Method>();
            Vector<Method> vector2 = new Vector<Method>();
            Method[] methodArray = new Method[]{};
            try {
                methodArray = clazz.getMethods();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 0;
            while (n < methodArray.length) {
                string6 = methodArray[n].getName().trim();
                if (string6.length() > 3 && string6.startsWith("get") && methodArray[n].getParameterTypes().length == 0) {
                    if (this.getType(methodArray[n].getReturnType()) == 1) {
                        vector.addElement(methodArray[n]);
                    } else {
                        vector2.addElement(methodArray[n]);
                    }
                }
                ++n;
            }
            if (vector.size() + vector2.size() == 0) {
                stringBuffer.append("<");
                stringBuffer.append(string3);
                stringBuffer.append(this.getNameAttribute(string));
                stringBuffer.append(this.getIdAttribute(string4));
                if (this.currentLevel == 0) {
                    stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                    stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
                }
                stringBuffer.append("/>");
                stringBuffer.append(this.lineSeparator);
                return stringBuffer;
            }
            stringBuffer.append("<");
            stringBuffer.append(string3);
            stringBuffer.append(this.getNameAttribute(string));
            stringBuffer.append(this.getIdAttribute(string4));
            if (this.currentLevel == 0) {
                stringBuffer.append(XMLGenerator.getLoggerNameAttribute(this.loggerName));
                stringBuffer.append(XMLGenerator.getLevelAttribute(this.loggingLevel));
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                block110: {
                    method2 = (Method)vector.elementAt(n2);
                    string6 = method2.getName().trim().substring(3);
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append("=\"");
                    try {
                        object = method2.invoke((Object)objectArray, null);
                        if (object != null) {
                            stringBuffer.append(XMLGenerator.normalize(object.toString().trim()));
                            break block110;
                        }
                        throw new Exception();
                    }
                    catch (Exception exception) {
                        stringBuffer.append("null");
                    }
                }
                stringBuffer.append("\"");
                ++n2;
            }
            if (vector2.size() == 0) {
                stringBuffer.append("/>");
                stringBuffer.append(this.lineSeparator);
                return stringBuffer;
            }
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            if (this.currentLevel == this.maxLevels) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.getEndOfNestingTag());
            } else {
                int n3 = 0;
                while (n3 < vector2.size()) {
                    block111: {
                        method2 = (Method)vector2.elementAt(n3);
                        try {
                            object = method2.invoke((Object)objectArray, null);
                            if (object != null) {
                                stringBuffer.append((Object)this.createXMLTag(object, method2.getName().trim().substring(3)));
                                --this.currentLevel;
                                break block111;
                            }
                            throw new Exception();
                        }
                        catch (Exception exception) {
                            String string7;
                            stringBuffer.append(this.indention(this.currentLevel + 1));
                            Class<?> clazz2 = method2.getReturnType();
                            if (clazz2.isArray()) {
                                string7 = "Array";
                            } else {
                                string7 = clazz2.getName().trim();
                                string7 = this.removeTagNameChars(string7.substring(string7.lastIndexOf(46) + 1));
                            }
                            stringBuffer.append(this.nullObjectToXML(string7, null, null, null, method2.getName().trim().substring(3)));
                            stringBuffer.append(this.lineSeparator);
                        }
                    }
                    ++n3;
                }
            }
            stringBuffer.append(this.indention(this.currentLevel));
            stringBuffer.append("</");
            stringBuffer.append(string3);
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
        }
        return stringBuffer;
    }

    protected static String primitiveToXML(boolean bl) {
        return XMLGenerator.primitiveToXML(bl, null, null);
    }

    protected static String primitiveToXML(boolean bl, String string) {
        return XMLGenerator.primitiveToXML(bl, string, null);
    }

    protected static String primitiveToXML(boolean bl, String string, String string2) {
        return "<boolean" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(bl) + "\"/>";
    }

    protected static String primitiveToXML(char c) {
        return XMLGenerator.primitiveToXML(c, null, null);
    }

    protected static String primitiveToXML(char c, String string) {
        return XMLGenerator.primitiveToXML(c, string, null);
    }

    protected static String primitiveToXML(char c, String string, String string2) {
        return "<char" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + XMLGenerator.normalize(String.valueOf(c)) + "\"/>";
    }

    protected static String primitiveToXML(byte by) {
        return XMLGenerator.primitiveToXML(by, null, null);
    }

    protected static String primitiveToXML(byte by, String string) {
        return XMLGenerator.primitiveToXML(by, string, null);
    }

    protected static String primitiveToXML(byte by, String string, String string2) {
        return "<byte" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(by) + "\"/>";
    }

    protected static String primitiveToXML(short s) {
        return XMLGenerator.primitiveToXML(s, null, null);
    }

    protected static String primitiveToXML(short s, String string) {
        return XMLGenerator.primitiveToXML(s, string, null);
    }

    protected static String primitiveToXML(short s, String string, String string2) {
        return "<short" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(s) + "\"/>";
    }

    protected static String primitiveToXML(int n) {
        return XMLGenerator.primitiveToXML(n, null, null);
    }

    protected static String primitiveToXML(int n, String string) {
        return XMLGenerator.primitiveToXML(n, string, null);
    }

    protected static String primitiveToXML(int n, String string, String string2) {
        return "<int" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(n) + "\"/>";
    }

    protected static String primitiveToXML(long l) {
        return XMLGenerator.primitiveToXML(l, null, null);
    }

    protected static String primitiveToXML(long l, String string) {
        return XMLGenerator.primitiveToXML(l, string, null);
    }

    protected static String primitiveToXML(long l, String string, String string2) {
        return "<long" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(l) + "\"/>";
    }

    protected static String primitiveToXML(float f) {
        return XMLGenerator.primitiveToXML(f, null, null);
    }

    protected static String primitiveToXML(float f, String string) {
        return XMLGenerator.primitiveToXML(f, string, null);
    }

    protected static String primitiveToXML(float f, String string, String string2) {
        return "<float" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(f) + "\"/>";
    }

    protected static String primitiveToXML(double d) {
        return XMLGenerator.primitiveToXML(d, null, null);
    }

    protected static String primitiveToXML(double d, String string) {
        return XMLGenerator.primitiveToXML(d, string, null);
    }

    protected static String primitiveToXML(double d, String string, String string2) {
        return "<double" + XMLGenerator.getLoggerNameAttribute(string) + XMLGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(d) + "\"/>";
    }

    private static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String getLevelAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " logging.util.MsgLoggerLevel=\"" + string.trim() + "\"";
        }
        return "";
    }

    private static String getLoggerNameAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " logging.util.agent_idref=\"" + string.trim() + "\"";
        }
        return "";
    }

    private String getIdAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " logging.util.id=\"" + string + "\"";
        }
        return "";
    }

    private String getNameAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " Instance_Name=\"" + string.trim() + "\"";
        }
        return "";
    }

    private String getEndOfNestingTag() {
        return "<EndOfNesting Level=\"" + this.maxLevels + "\"/>" + this.lineSeparator;
    }

    private String simpleObjectToXML(Object object, String string, String string2, String string3, String string4) {
        if (object == null) {
            return this.nullObjectToXML(null, string, string2, string3, string4);
        }
        String string5 = object.getClass().getName().trim();
        return "<" + this.removeTagNameChars(string5.substring(string5.lastIndexOf(46) + 1)) + this.getNameAttribute(string4) + this.getIdAttribute(string) + XMLGenerator.getLoggerNameAttribute(string2) + XMLGenerator.getLevelAttribute(string3) + " Value=\"" + XMLGenerator.normalize(object.toString().trim()) + "\"/>";
    }

    private String nullObjectToXML(String string, String string2, String string3, String string4, String string5) {
        if (string == null) {
            return "<null" + this.getIdAttribute(string2) + XMLGenerator.getLoggerNameAttribute(string3) + XMLGenerator.getLevelAttribute(string4) + "/>";
        }
        return "<" + this.removeTagNameChars(string) + this.getNameAttribute(string5) + this.getIdAttribute(string2) + XMLGenerator.getLoggerNameAttribute(string3) + XMLGenerator.getLevelAttribute(string4) + " Value=\"null\"/>";
    }

    private byte getType(Class clazz) {
        String string = clazz.getName().trim();
        if (clazz.isPrimitive() || string.equals("java.lang.StringBuffer") || string.equals("java.lang.String") || string.equals("java.math.BigDecimal") || string.equals("java.math.BigInteger")) {
            return 1;
        }
        return 2;
    }

    private String removeTagNameChars(String string) {
        if (string == null) {
            return "null";
        }
        return string.replace('$', '_');
    }

    private String indention(int n) {
        if (this.format) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private String getUniqueId(String string) {
        if (string == null) {
            return "null";
        }
        Object[] objectArray = this.loggedObjects.values().toArray();
        int n = 0;
        String string2 = "_";
        int n2 = 0;
        while (n2 < objectArray.length) {
            String string3 = (String)objectArray[n2];
            if (string3.substring(0, string3.lastIndexOf(string2)).equals(string)) {
                ++n;
            }
            ++n2;
        }
        return string + string2 + n++;
    }

    private String getClassName(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        String string = clazz.getName().trim();
        if (clazz.isArray()) {
            String string2 = string.substring(0, string.lastIndexOf(91) + 1);
            String string3 = string.substring(string.lastIndexOf(91) + 1);
            String string4 = "";
            if (string3.startsWith("L") && string3.endsWith(";")) {
                string4 = string3.substring(1, string3.length() - 1);
            } else if (string3.startsWith("B")) {
                string4 = "byte";
            } else if (string3.startsWith("C")) {
                string4 = "char";
            } else if (string3.startsWith("D")) {
                string4 = "double";
            } else if (string3.startsWith("F")) {
                string4 = "float";
            } else if (string3.startsWith("I")) {
                string4 = "int";
            } else if (string3.startsWith("J")) {
                string4 = "long";
            } else if (string3.startsWith("S")) {
                string4 = "short";
            } else if (string3.startsWith("Z")) {
                string4 = "boolean";
            }
            return string2.concat(string4).concat(string2.replace('[', ']'));
        }
        return string;
    }
}

