/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util.dcs;

import com.ibm.etools.logging.util.dcs.Parameter;
import com.ibm.etools.logging.util.dcs.ProviderCorrelator;
import com.ibm.etools.logging.util.dcs.ProviderCorrelatorCommonData;
import com.ibm.etools.logging.util.dcs.ProviderThreadCorrelator;
import com.ibm.etools.logging.util.dcs.ProviderThreadCorrelatorList;
import com.ibm.etools.logging.util.dcs.Service;
import java.net.UnknownHostException;

public class DCSCorrelator {
    public static final String dcsCorrelatorCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int _list_size = 16;
    public String _hostname = null;
    public String _jvmID;
    private ProviderThreadCorrelatorList _correlatorTable = null;

    public DCSCorrelator() throws UnknownHostException {
        this._jvmID = Service.dcs.get_jvmID();
        this._hostname = Service.dcs.get_hostname();
        this._correlatorTable = new ProviderThreadCorrelatorList(16, 16);
    }

    public DCSCorrelator(String string, String string2, String string3, Parameter[] parameterArray, String string4, DCSCorrelator dCSCorrelator) throws UnknownHostException {
        ProviderCorrelator providerCorrelator = null;
        long l = 0L;
        this._jvmID = Service.dcs.get_jvmID();
        if (this._hostname == null) {
            this._hostname = Service.dcs.get_hostname();
        }
        l = Thread.currentThread().hashCode();
        this._correlatorTable = new ProviderThreadCorrelatorList(1, 1);
        providerCorrelator = new ProviderCorrelator(string, string2, string3, parameterArray, string4, dCSCorrelator);
        providerCorrelator.getProviderCorrelatorCommonData().set_counters(1L, Service.dcs.increment_global_sequence_counter());
        this._correlatorTable.pushCorrelator(l, providerCorrelator);
        providerCorrelator = null;
    }

    public DCSCorrelator(int n, int n2, String string, String string2, String string3, long l, String string4, String string5, Parameter[] parameterArray, String string6, long l2, long l3, DCSCorrelator dCSCorrelator) throws UnknownHostException {
        ProviderCorrelator providerCorrelator = null;
        this._jvmID = string2;
        this._hostname = string == null ? Service.dcs.get_hostname() : string;
        this._correlatorTable = new ProviderThreadCorrelatorList(n, n2);
        providerCorrelator = new ProviderCorrelator(string3, string4, string5, parameterArray, string6, dCSCorrelator);
        providerCorrelator.getProviderCorrelatorCommonData().set_counters(l2, l3);
        this._correlatorTable.pushCorrelator(l, providerCorrelator);
        providerCorrelator = null;
    }

    public String getHostname() {
        return this._hostname;
    }

    public ProviderThreadCorrelatorList getProviderThreadCorrelatorList() {
        return this._correlatorTable;
    }

    public ProviderThreadCorrelator getProviderThreadCorrelatorList(int n) {
        return this._correlatorTable.getProviderThreadCorrelatorList(n);
    }

    protected void setHostname(String string) {
        this._hostname = string;
    }

    public String getJvmID() {
        return this._jvmID;
    }

    public String toString() {
        String string = null;
        string = new String("\nCorrelator.hostname=" + this._hostname + "Correlator.jvmID=" + this._jvmID + this._correlatorTable.getProviderThreadCorrelatorList(0).toString());
        return string;
    }

    public String toXML() {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < this._correlatorTable.get_stack_size()) {
            string2 = string2 + this._correlatorTable.getProviderThreadCorrelatorList(n).toXML();
            ++n;
        }
        string = "<DCSCorrelator hostname=\"" + this._hostname + "\" jvmID=\"" + this._jvmID + "\">" + string2 + "</DCSCorrelator>\u0000";
        return string;
    }

    public void reset() {
        this._hostname = null;
        this._jvmID = null;
        this._correlatorTable = null;
    }

    protected DCSCorrelator pullCorrelator(int n, String string, long l) {
        DCSCorrelator dCSCorrelator = null;
        ProviderThreadCorrelator providerThreadCorrelator = this._correlatorTable.pullCorrelator(string, l);
        if (providerThreadCorrelator != null) {
            ProviderCorrelator providerCorrelator = providerThreadCorrelator.getProviderCorrelator();
            ProviderCorrelatorCommonData providerCorrelatorCommonData = providerCorrelator.getProviderCorrelatorCommonData();
            long l2 = Service.dcs.getRegisteredProvidersTable()[n].incrementProviderThreadEntry(l);
            providerCorrelatorCommonData.set_counters(l2, Service.dcs.increment_global_sequence_counter());
            try {
                dCSCorrelator = new DCSCorrelator(1, 1, this._hostname, this._jvmID, providerCorrelator.getProviderID(), providerThreadCorrelator.getThreadID(), providerCorrelatorCommonData.getString_UniqueID(), providerCorrelatorCommonData.getString_UniqueID_format(), providerCorrelator.getArray_correlator_data(), providerCorrelator.getString_correlator_data_format(), providerCorrelatorCommonData.get_thread_sequence_counter(), providerCorrelatorCommonData.get_process_sequence_counter(), providerCorrelatorCommonData.getPartnerCorrelator());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return dCSCorrelator;
    }

    protected int pushCorrelator(long l, DCSCorrelator dCSCorrelator) {
        int n = 0;
        n = this._correlatorTable.pushCorrelator(l, dCSCorrelator.getProviderThreadCorrelatorList(0).getProviderCorrelator());
        return n;
    }
}

