/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util.dcs;

import com.ibm.etools.logging.util.dcs.DCSCorrelator;
import com.ibm.etools.logging.util.dcs.Parameter;
import com.ibm.etools.logging.util.dcs.ProviderCorrelator;
import com.ibm.etools.logging.util.dcs.ProviderThreadCorrelator;
import java.io.Serializable;
import java.net.UnknownHostException;

public class ProviderCorrelatorCommonData
implements Serializable {
    public static final String providerCorrelatorCommonDataCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String _UniqueID;
    private String _UniqueID_format;
    private long _thread_sequence_counter = 0L;
    private long _process_sequence_counter = 0L;
    private DCSCorrelator _partner_correlator;

    public DCSCorrelator getPartnerCorrelator() {
        return this._partner_correlator;
    }

    public String getString_UniqueID() {
        return this._UniqueID;
    }

    public String getString_UniqueID_format() {
        return this._UniqueID_format;
    }

    public long get_thread_sequence_counter() {
        return this._thread_sequence_counter;
    }

    public long get_process_sequence_counter() {
        return this._process_sequence_counter;
    }

    public ProviderCorrelatorCommonData() {
        this._UniqueID = null;
        this._UniqueID_format = null;
        this._thread_sequence_counter = 1L;
        this._process_sequence_counter = 1L;
        this._partner_correlator = null;
    }

    public ProviderCorrelatorCommonData(String string, String string2, DCSCorrelator dCSCorrelator) {
        this._UniqueID = string;
        this._UniqueID_format = string2;
        this._thread_sequence_counter = 1L;
        this._process_sequence_counter = 1L;
        this._partner_correlator = null;
        if (dCSCorrelator != null) {
            try {
                ProviderThreadCorrelator providerThreadCorrelator = dCSCorrelator.getProviderThreadCorrelatorList(0);
                ProviderCorrelator providerCorrelator = providerThreadCorrelator.getProviderCorrelator();
                ProviderCorrelatorCommonData providerCorrelatorCommonData = providerCorrelator.getProviderCorrelatorCommonData();
                this._partner_correlator = new DCSCorrelator(1, 1, dCSCorrelator.getHostname(), dCSCorrelator.getJvmID(), providerCorrelator.getProviderID(), providerThreadCorrelator.getThreadID(), providerCorrelatorCommonData.getString_UniqueID(), providerCorrelatorCommonData.getString_UniqueID_format(), providerCorrelator.getArray_correlator_data(), providerCorrelator.getString_correlator_data_format(), providerCorrelatorCommonData.get_thread_sequence_counter(), providerCorrelatorCommonData.get_process_sequence_counter(), null);
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            this._partner_correlator = null;
        }
    }

    public int set_partner_correlator_data(String string, String string2, long l, String string3, String string4, String string5, Parameter[] parameterArray, String string6, long l2, long l3) {
        int n = 0;
        this._partner_correlator = null;
        try {
            this._partner_correlator = new DCSCorrelator(1, 1, string, string2, string3, l, string4, string5, parameterArray, string6, l2, l3, null);
        }
        catch (UnknownHostException unknownHostException) {
            n = -6;
        }
        return n;
    }

    public int set_partner_correlator_data(DCSCorrelator dCSCorrelator) {
        int n = 0;
        this._partner_correlator = dCSCorrelator;
        return n;
    }

    protected void increment_counters(long l) {
        ++this._thread_sequence_counter;
        this._process_sequence_counter = l;
    }

    public void set_counters(long l, long l2) {
        this._thread_sequence_counter = l;
        this._process_sequence_counter = l2;
    }

    public void finalize() {
        this._UniqueID = null;
        this._UniqueID_format = null;
        this._partner_correlator = null;
    }

    public String toString() {
        String string;
        if (this._partner_correlator == null) {
            string = "\nCorrelator.UniqueID=" + this._UniqueID + "\n" + "Correlator.UniqueID_format=" + this._UniqueID_format + "\n" + "Correlator.thread_sequence_counter=" + this._thread_sequence_counter + "\n" + "Correlator.process_sequence_counter=" + this._process_sequence_counter + "\n";
        } else {
            ProviderThreadCorrelator providerThreadCorrelator = this._partner_correlator.getProviderThreadCorrelatorList(0);
            ProviderCorrelator providerCorrelator = providerThreadCorrelator.getProviderCorrelator();
            ProviderCorrelatorCommonData providerCorrelatorCommonData = providerCorrelator.getProviderCorrelatorCommonData();
            string = "\nProviderCorrelatorCommonData.UniqueID=" + this._UniqueID + "\n" + "ProviderCorrelatorCommonData.UniqueID_format=" + this._UniqueID_format + "\n" + "ProviderCorrelatorCommonData.thread_sequence_counter=" + this._thread_sequence_counter + "\n" + "ProviderCorrelatorCommonData.process_sequence_counter=" + this._process_sequence_counter + "\n" + "ProviderCorrelatorCommonData.partnerhostname=" + this._partner_correlator.getHostname() + "\n" + "ProviderCorrelatorCommonData.partnerjvmID=" + this._partner_correlator.getJvmID() + "\n" + "ProviderCorrelatorCommonData.partnerUniqueID=" + providerCorrelatorCommonData.getString_UniqueID() + "\n" + "ProviderCorrelatorCommonData.partnerUniqueID_format=" + providerCorrelatorCommonData.getString_UniqueID_format() + "\n" + "ProviderCorrelatorCommonData.partnerthreadID=" + providerThreadCorrelator.getThreadID() + "\n" + "ProviderCorrelatorCommonData.correlator_data_format=" + providerCorrelator.getString_correlator_data_format() + "\n" + "ProviderCorrelatorCommonData.correlator_data=" + providerCorrelator.getArray_correlator_data().toString() + "\n" + "ProviderCorrelatorCommonData.partnersequence_counter=" + providerCorrelatorCommonData.get_thread_sequence_counter() + "\n" + "ProviderCorrelatorCommonData.partnerglobal_sequence_counter=" + providerCorrelatorCommonData.get_process_sequence_counter() + "\n";
        }
        return string;
    }

    public String toXML() {
        String string = null;
        string = this._partner_correlator == null ? "<ProviderCorrelatorCommonData UniqueID=\"" + this._UniqueID + "\" UniqueID_format=\"" + this._UniqueID_format + "\" thread_sequence_counter=\"" + this._thread_sequence_counter + "\" process_sequence_counter=\"" + this._process_sequence_counter + "\">" + "<PartnerDCSCorrelator value=\"null\">" + "</PartnerDCSCorrelator>" + "</ProviderCorrelatorCommonData>\u0000" : "<ProviderCorrelatorCommonData UniqueID=\"" + this._UniqueID + "\" UniqueID_format=\"" + this._UniqueID_format + "\" thread_sequence_counter=\"" + this._thread_sequence_counter + "\" process_sequence_counter=\"" + this._process_sequence_counter + "\">" + "<PartnerDCSCorrelator>" + this._partner_correlator.toXML() + "</PartnerDCSCorrelator>" + "</ProviderCorrelatorCommonData>\u0000";
        return string;
    }
}

