/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util.dcs;

import com.ibm.etools.logging.util.dcs.ThreadTableEntry;
import java.io.Serializable;

public class ProviderRegistrationEntry
implements Serializable {
    public static final String providerRegistrationEntryCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String _providerID;
    private ThreadTableEntry[] _threadList = null;
    private int _thread_stack_size;

    protected ProviderRegistrationEntry() {
        this._providerID = null;
        this._threadList = null;
        this._thread_stack_size = 0;
    }

    protected String getProviderID() {
        return this._providerID;
    }

    protected ProviderRegistrationEntry(String string, long l) {
        this._providerID = string;
        this._threadList = new ThreadTableEntry[20];
        this._threadList[0] = new ThreadTableEntry(l);
        this._thread_stack_size = 1;
    }

    protected void addProviderThreadEntry(long l) {
        boolean bl = false;
        int n = 0;
        if (this._threadList != null) {
            n = this._thread_stack_size - 1;
            while (n >= 0) {
                if (this._threadList[n].getThreadID() == l) {
                    bl = true;
                    break;
                }
                --n;
            }
        }
        if (!bl) {
            ThreadTableEntry threadTableEntry = new ThreadTableEntry(l);
            if (this._thread_stack_size < this._threadList.length) {
                this._threadList[this._thread_stack_size] = threadTableEntry;
                ++this._thread_stack_size;
            } else {
                ThreadTableEntry[] threadTableEntryArray = new ThreadTableEntry[2 * this._thread_stack_size];
                System.arraycopy(this._threadList, 0, threadTableEntryArray, 0, this._thread_stack_size);
                this._threadList = threadTableEntryArray;
                this._threadList[this._thread_stack_size] = threadTableEntry;
                ++this._thread_stack_size;
            }
        } else {
            this._threadList[n].increment_sequence_counter();
        }
    }

    protected void removeProviderThreadEntry(long l) {
        if (this._threadList != null) {
            int n = this._thread_stack_size - 1;
            while (n >= 0) {
                if (this._threadList[n].getThreadID() == l) {
                    this._threadList[n] = null;
                    int n2 = n + 1;
                    while (n2 < this._thread_stack_size) {
                        this._threadList[n2 - 1] = this._threadList[n2];
                        this._threadList[n2] = null;
                        ++n2;
                    }
                    --this._thread_stack_size;
                    break;
                }
                --n;
            }
        }
    }

    protected long incrementProviderThreadEntry(long l) {
        long l2 = 0L;
        if (this._threadList != null) {
            int n = this._thread_stack_size - 1;
            while (n >= 0) {
                if (this._threadList[n].getThreadID() == l) {
                    l2 = this._threadList[n].increment_sequence_counter();
                    break;
                }
                --n;
            }
        }
        return l2;
    }

    protected int setProviderThreadEntryState(long l, boolean bl) {
        boolean bl2 = false;
        int n = -5;
        int n2 = 0;
        if (this._threadList != null) {
            n2 = this._thread_stack_size - 1;
            while (n2 >= 0) {
                if (this._threadList[n2].getThreadID() == l) {
                    bl2 = true;
                    break;
                }
                --n2;
            }
        }
        if (bl2) {
            this._threadList[n2].set_suspend_state(bl);
            n = 0;
        }
        return n;
    }

    protected boolean getProviderThreadEntryState(long l) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (this._threadList != null) {
            n = this._thread_stack_size - 1;
            while (n >= 0) {
                if (this._threadList[n].getThreadID() == l) {
                    bl = true;
                    break;
                }
                --n;
            }
        }
        if (bl) {
            bl2 = this._threadList[n].get_suspend_state();
        }
        return bl2;
    }

    protected boolean getProviderThreadEntry(long l) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (this._threadList != null) {
            n = this._thread_stack_size - 1;
            while (n >= 0) {
                if (this._threadList[n].getThreadID() == l) {
                    bl = true;
                    break;
                }
                --n;
            }
        }
        return bl;
    }

    protected void finalize() {
        this._providerID = null;
        this._threadList = null;
        this._thread_stack_size = 0;
    }
}

