/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.util.dcs;

import com.ibm.etools.logging.util.dcs.ProviderCorrelator;
import com.ibm.etools.logging.util.dcs.ProviderCorrelatorCommonData;
import java.io.Serializable;

public class ProviderThreadCorrelator
implements Serializable {
    public static final String providerThreadCorrelatorCopyright = "Licensed Material - Property of IBM\n5724-D14\n(C) Copyright IBM Corp. 2002 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int list_size = 16;
    private long _threadID;
    private ProviderCorrelator[] _providerCorrelatorList;
    private int _stack_size = 0;

    public ProviderThreadCorrelator() {
        this._threadID = Thread.currentThread().hashCode();
        this._providerCorrelatorList = new ProviderCorrelator[16];
    }

    public ProviderCorrelator getProviderCorrelator() {
        return this._providerCorrelatorList[0];
    }

    public ProviderCorrelator[] getProviderCorrelatorList() {
        return this._providerCorrelatorList;
    }

    public ProviderCorrelator getProviderCorrelator(int n) {
        return this._providerCorrelatorList[n];
    }

    public long getThreadID() {
        return this._threadID;
    }

    public ProviderThreadCorrelator(String string, long l, ProviderCorrelator providerCorrelator) {
        ProviderCorrelatorCommonData providerCorrelatorCommonData = providerCorrelator.getProviderCorrelatorCommonData();
        this._threadID = l;
        this._providerCorrelatorList = new ProviderCorrelator[16];
        ProviderCorrelator providerCorrelator2 = new ProviderCorrelator(string, providerCorrelatorCommonData.getString_UniqueID(), providerCorrelatorCommonData.getString_UniqueID_format(), providerCorrelator.getArray_correlator_data(), providerCorrelator.getString_correlator_data_format(), providerCorrelatorCommonData.getPartnerCorrelator());
        providerCorrelator2.getProviderCorrelatorCommonData().set_counters(providerCorrelatorCommonData.get_thread_sequence_counter(), providerCorrelatorCommonData.get_process_sequence_counter());
        this._providerCorrelatorList[this._stack_size] = providerCorrelator2;
        ++this._stack_size;
    }

    public void addProviderCorrelatorEntry(ProviderCorrelator providerCorrelator) {
        ProviderCorrelatorCommonData providerCorrelatorCommonData = providerCorrelator.getProviderCorrelatorCommonData();
        ProviderCorrelator providerCorrelator2 = new ProviderCorrelator(providerCorrelator.getProviderID(), providerCorrelatorCommonData.getString_UniqueID(), providerCorrelatorCommonData.getString_UniqueID_format(), providerCorrelator.getArray_correlator_data(), providerCorrelator.getString_correlator_data_format(), providerCorrelatorCommonData.getPartnerCorrelator());
        providerCorrelator2.getProviderCorrelatorCommonData().set_counters(providerCorrelatorCommonData.get_thread_sequence_counter(), providerCorrelatorCommonData.get_process_sequence_counter());
        if (this._stack_size < this._providerCorrelatorList.length) {
            this._providerCorrelatorList[this._stack_size] = providerCorrelator2;
            ++this._stack_size;
        } else {
            ProviderCorrelator[] providerCorrelatorArray = new ProviderCorrelator[2 * this._stack_size];
            System.arraycopy(this._providerCorrelatorList, 0, providerCorrelatorArray, 0, this._stack_size);
            this._providerCorrelatorList = null;
            this._providerCorrelatorList = providerCorrelatorArray;
            this._providerCorrelatorList[this._stack_size] = providerCorrelator2;
            ++this._stack_size;
        }
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this._stack_size) {
            string = string + this._providerCorrelatorList[n].toString();
            ++n;
        }
        String string2 = new String("\nCorrelator.threadID=" + this._threadID + "\n" + string);
        return string2;
    }

    public String toXML() {
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < this._stack_size) {
            string2 = string2 + this._providerCorrelatorList[n].toXML();
            ++n;
        }
        string = "<ProviderThreadCorrelator threadID=\"" + this._threadID + "\">" + string2 + "</ProviderThreadCorrelator>\u0000";
        return string;
    }

    public int get_stack_size() {
        return this._stack_size;
    }

    public void finalize() {
        this._threadID = -1L;
        this._providerCorrelatorList = null;
        this._stack_size = 0;
    }
}

