/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logging.was;

import com.ibm.etools.logging.tracing.control.AgentConfiguration;
import com.ibm.etools.logging.tracing.control.AgentConfigurationEntry;
import com.ibm.etools.logging.util.AbstractMessageLogger;
import com.ibm.etools.logging.util.LoggingUtilities;
import com.ibm.etools.logging.util.MsgLogger;
import com.ibm.etools.logging.was.WASActivityLogParseException;
import com.ibm.etools.logging.was.WASConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class WASActivityLogParser {
    private String activityLogPath = null;
    private String was_home = null;
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        MsgLogger msgLogger = (MsgLogger)MsgLogger.getFactory().getLogger("WAS Activity Log Agent");
        msgLogger.setLevel(7);
        msgLogger.setXMLFormat(false);
        WASActivityLogParser wASActivityLogParser = new WASActivityLogParser();
        int n = stringArray.length;
        int n2 = 0;
        if (n > n2 && stringArray[n2] != null && stringArray[n2].trim().equals("com.ibm.etools.logging.was.WASActivityLogParser")) {
            ++n2;
        }
        if (n > n2) {
            wASActivityLogParser.setActivityLogPath(stringArray[n2]);
        }
        if (n > ++n2) {
            wASActivityLogParser.setWAS_Home(stringArray[n2]);
        } else {
            object2 = msgLogger.getLoggingAgentDefaultConfiguration();
            int n3 = 0;
            while (n3 < ((AgentConfiguration)object2).size()) {
                object = ((AgentConfiguration)object2).getEntryAt(n3);
                try {
                    if (((AgentConfigurationEntry)object).getName().trim().equals("WAS_HOME")) {
                        wASActivityLogParser.setWAS_Home(((AgentConfigurationEntry)object).getValue());
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n3;
            }
        }
        try {
            object2 = wASActivityLogParser.parse();
            while (object2.hasMoreElements()) {
                msgLogger.write((String)object2.nextElement());
            }
        }
        catch (WASActivityLogParseException wASActivityLogParseException) {
            object = (MsgLogger)MsgLogger.getFactory().getLogger("WAS Activity Log Error Agent");
            ((AbstractMessageLogger)object).setLevel(7);
            ((AbstractMessageLogger)object).setXMLFormat(false);
            ((AbstractMessageLogger)object).write(wASActivityLogParseException.getMessage());
            ((AbstractMessageLogger)object).waitUntilMonitored(5000L);
            MsgLogger.getFactory().destroyLogger("WAS Activity Log Error Agent");
        }
        MsgLogger.getFactory().destroyLogger("WAS Activity Log Agent");
    }

    public Enumeration parse() throws WASActivityLogParseException {
        BufferedReader bufferedReader;
        Vector<String> vector;
        File file;
        block72: {
            Process process;
            File file2;
            if (this.was_home == null || this.was_home.trim().length() == 0) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("WAS_HOME_ERROR_"));
            }
            this.was_home = this.was_home.trim();
            if (!new File(this.was_home).isDirectory()) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("INVALID_WAS_HOME_ERROR_", this.was_home));
            }
            if (this.activityLogPath == null || this.activityLogPath.trim().length() == 0) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("LOG_FILE_ERROR_"));
            }
            this.activityLogPath = this.activityLogPath.trim();
            int n = this.activityLogPath.indexOf(WASConstants.WINDOWS_WAS_HOME);
            if (n != -1) {
                this.activityLogPath = this.activityLogPath.substring(0, n).concat(this.was_home).concat(this.activityLogPath.substring(n + WASConstants.WINDOWS_WAS_HOME.length()));
            }
            if ((n = this.activityLogPath.indexOf(WASConstants.UNIX_WAS_HOME)) != -1) {
                this.activityLogPath = this.activityLogPath.substring(0, n).concat(this.was_home).concat(this.activityLogPath.substring(n + WASConstants.UNIX_WAS_HOME.length()));
            }
            if (!(file2 = new File(this.activityLogPath)).isFile()) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("INVALID_LOG_FILE_ERROR_", this.activityLogPath));
            }
            try {
                file = File.createTempFile("ActivityLogParser", ".tmp");
                file.deleteOnExit();
            }
            catch (Exception exception) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("TEMP_FILE_ERROR_"));
            }
            Object[] objectArray = new String[]{this.was_home};
            StringBuffer stringBuffer = new StringBuffer(MessageFormat.format(WASConstants.JAVA_EXE, objectArray));
            if (WASConstants.ISWINDOWSOS) {
                stringBuffer.append(" -Dws.output.encoding=console");
            }
            stringBuffer.append(MessageFormat.format(WASConstants.CONFIG_URL_PARAMETER, objectArray));
            stringBuffer.append(MessageFormat.format(WASConstants.SERVER_ROOT_PARAMETER, objectArray));
            stringBuffer.append(MessageFormat.format(WASConstants.WAS_INSTALL_ROOT_PARAMETER, objectArray));
            stringBuffer.append(MessageFormat.format(WASConstants.USER_INSTALL_ROOT_PARAMETER, objectArray));
            stringBuffer.append(MessageFormat.format(WASConstants.EXT_DIRS_PARAMETER, objectArray));
            stringBuffer.append(MessageFormat.format(WASConstants.CLASSPATH_PARAMETER, objectArray));
            stringBuffer.append(" com.ibm.ws.bootstrap.WSLauncher");
            stringBuffer.append(" com.ibm.ejs.ras.ShowLog");
            stringBuffer.append(" -xml");
            stringBuffer.append(" ");
            if (WASConstants.ISWINDOWSOS) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(file2.getAbsolutePath());
            if (WASConstants.ISWINDOWSOS) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(" ");
            if (WASConstants.ISWINDOWSOS) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(file.getAbsolutePath());
            if (WASConstants.ISWINDOWSOS) {
                stringBuffer.append("\"");
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            Object object = this.currentThreadLock;
            synchronized (object) {
                this.childThreadsDone = 0;
                try {
                    process = Runtime.getRuntime().exec(stringBuffer.toString());
                }
                catch (Exception exception) {
                    throw new WASActivityLogParseException(LoggingUtilities.getResourceString("SHOWLOG_ERROR_"));
                }
                new ShowlogOutputReader(process.getErrorStream(), stringBuffer2).start();
                new ShowlogOutputReader(process.getInputStream(), stringBuffer2).start();
                try {
                    this.currentThreadLock.wait(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n2 = -1;
            try {
                n2 = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                process.destroy();
            }
            if (n2 != 0) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("SHOWLOG_ERROR_"));
            }
            if (stringBuffer2.length() > 0) {
                if (stringBuffer2.toString().indexOf("RasException") != -1) {
                    if (!file2.canWrite()) {
                        throw new WASActivityLogParseException(LoggingUtilities.getResourceString("READ_ONLY_LOG_FILE_ERROR_", this.activityLogPath));
                    }
                    throw new WASActivityLogParseException(LoggingUtilities.getResourceString("SHOWLOG_INPUT_ERROR_", this.activityLogPath));
                }
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("SHOWLOG_ERROR_"));
            }
            String string = "";
            vector = new Vector<String>();
            StringBuffer stringBuffer3 = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                while (string != null && string.indexOf("---------------------------------------------------------------") == -1 && string.indexOf(WASConstants.XML_RECORD_START) == -1 && string.indexOf(WASConstants.TEXT_FILE_END) == -1 && string.indexOf("<total records=") == -1) {
                    string = bufferedReader.readLine();
                }
                if (string.indexOf(WASConstants.XML_RECORD_START) != -1) {
                    boolean bl = false;
                    boolean bl2 = false;
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    int n3 = -1;
                    while (string != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "<>", true);
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken().trim();
                            if (string2.equals("<")) {
                                bl = true;
                                continue;
                            }
                            if (!bl) continue;
                            if (string2.startsWith("WASActivityLogEntry")) {
                                stringBuffer3.append(string2);
                                bl2 = true;
                                continue;
                            }
                            if (!bl2) continue;
                            stringBuffer3.append(string2);
                            if (!string2.equals(">")) continue;
                            StringBuffer stringBuffer4 = new StringBuffer(" recordId=\"Rec_");
                            stringBuffer4.append(String.valueOf(vector.size()));
                            n3 = stringBuffer3.toString().indexOf("SourceId=\"");
                            if (n3 != -1) {
                                string3 = stringBuffer3.substring(n3 + 10).trim();
                                if ((string3 = string3.substring(0, string3.indexOf(34))).equals(string4 = this.normalize(string3))) {
                                    stringBuffer4.append("_");
                                    stringBuffer4.append(string3);
                                }
                            }
                            stringBuffer4.append("\"");
                            stringBuffer3.insert("WASActivityLogEntry".length(), stringBuffer4.toString());
                            stringBuffer3.insert(0, "<");
                            vector.addElement(stringBuffer3.toString());
                            bl = false;
                            bl2 = false;
                            stringBuffer3.delete(0, stringBuffer3.length());
                        }
                        string = bufferedReader.readLine();
                    }
                    break block72;
                }
                if (string.indexOf("---------------------------------------------------------------") != -1) {
                    String string5 = "";
                    String string6 = "";
                    boolean bl = false;
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() <= 0) continue;
                        if (string.indexOf("---------------------------------------------------------------") != -1 || string.indexOf(WASConstants.TEXT_FILE_END) != -1) {
                            if (string5.length() > 0) {
                                stringBuffer3.insert(0, "_".concat(string5));
                            }
                            stringBuffer3.insert(0, "<".concat("WASActivityLogEntry").concat(" recordId=\"Rec_").concat(String.valueOf(vector.size())));
                            if (bl) {
                                stringBuffer3.append("\" rawData=\"\"/>");
                            } else {
                                stringBuffer3.append("\"/>");
                            }
                            vector.addElement(stringBuffer3.toString());
                            stringBuffer3.delete(0, stringBuffer3.length());
                            string5 = "";
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_COMPONENTID)) {
                            stringBuffer3.append("\" componentId=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_PROCESSID)) {
                            stringBuffer3.append("\" processId=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_THREADID)) {
                            stringBuffer3.append("\" threadId=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_FUNCTIONNAME)) {
                            stringBuffer3.append("\" functionName=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_PROBEID)) {
                            stringBuffer3.append("\" probeId=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_SOURCEID)) {
                            string5 = string.substring(string.indexOf(58) + 1).trim();
                            if (!string5.equals(string6 = this.normalize(string5))) {
                                string5 = "";
                            }
                            stringBuffer3.append("\" sourceId=\"");
                            stringBuffer3.append(string6);
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_CLASSNAME)) {
                            stringBuffer3.append("\" className=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_METHODNAME)) {
                            stringBuffer3.append("\" methodName=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_MANUFACTURER)) {
                            stringBuffer3.append("\" manufacturer=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_PRODUCT)) {
                            stringBuffer3.append("\" product=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_VERSION)) {
                            stringBuffer3.append("\" version=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_SOMPROCESSTYPE)) {
                            stringBuffer3.append("\" somProcessType=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_SERVERNAME)) {
                            stringBuffer3.append("\" serverName=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_CLIENTHOSTNAME)) {
                            stringBuffer3.append("\" clientHostName=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_CLIENTUSERID)) {
                            stringBuffer3.append("\" clientUserId=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_TIMESTAMP)) {
                            stringBuffer3.append("\" timeStamp=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_UNITOFWORK)) {
                            stringBuffer3.append("\" unitOfWork=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_SEVERITY)) {
                            stringBuffer3.append("\" severity=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_CATEGORY)) {
                            stringBuffer3.append("\" category=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_FORMATWARNING)) {
                            stringBuffer3.append("\" formatWarning=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_PRIMARYMESSAGE)) {
                            stringBuffer3.append("\" primaryMessage=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_EXTENDEDMESSAGE)) {
                            stringBuffer3.append("\" extendedMessage=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        if (string.startsWith(WASConstants.SHOWLOG_RECORD_ENTRY_RAWDATALENGTH)) {
                            bl = true;
                            stringBuffer3.append("\" rawDataLen=\"");
                            stringBuffer3.append(this.normalize(string.substring(string.indexOf(58) + 1).trim()));
                            continue;
                        }
                        stringBuffer3.append(WASConstants.LINE_SEPARATOR);
                        stringBuffer3.append(this.normalize(string));
                    }
                    break block72;
                }
                if (string.indexOf(WASConstants.TEXT_FILE_END) != -1 || string.indexOf("<total records=") != -1) {
                    throw new WASActivityLogParseException(LoggingUtilities.getResourceString("NO_RECORDS_ERROR_"));
                }
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("SHOWLOG_OUTPUT_ERROR_"));
            }
            catch (Exception exception) {
                throw new WASActivityLogParseException(LoggingUtilities.getResourceString("SHOWLOG_OUTPUT_ERROR_"));
            }
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vector.size() == 0) {
            throw new WASActivityLogParseException(LoggingUtilities.getResourceString("NO_RECORDS_ERROR_"));
        }
        return vector.elements();
    }

    private String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setActivityLogPath(String string) {
        this.activityLogPath = string;
    }

    public String getActivityLogPath() {
        return this.activityLogPath;
    }

    public void setWAS_Home(String string) {
        this.was_home = string;
    }

    public String getWAS_Home() {
        return this.was_home;
    }

    class ShowlogOutputReader
    extends Thread {
        private BufferedReader reader;
        private StringBuffer output;
        private String line = "";

        public ShowlogOutputReader(InputStream inputStream, StringBuffer stringBuffer) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.output = stringBuffer;
        }

        public void run() {
            try {
                while ((this.line = this.reader.readLine()) != null) {
                    this.output.append(this.line.trim());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Object object = WASActivityLogParser.this.currentThreadLock;
            synchronized (object) {
                if (++WASActivityLogParser.this.childThreadsDone == 2) {
                    WASActivityLogParser.this.currentThreadLock.notify();
                }
            }
        }
    }
}

