/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime;

import com.ibm.etools.pd.sd.runtime.J2eeRequestProfilerCorrelator;
import com.ibm.etools.pd.sd.runtime.J2eeRequestProfilerService;
import com.ibm.etools.pd.sd.runtime.records.AgentRecord;
import com.ibm.etools.pd.sd.runtime.records.ClassRecord;
import com.ibm.etools.pd.sd.runtime.records.MethodAccessRecord;
import com.ibm.etools.pd.sd.runtime.records.MethodRecord;
import com.ibm.etools.pd.sd.runtime.records.ObjRecord;
import com.ibm.etools.pd.sd.runtime.records.ThreadRecord;
import com.ibm.etools.pd.sd.runtime.records.TrcStartRecord;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class J2eeRequestProfilerLogger
implements MonitorListener,
AgentControllerListener,
RemoteClientListener {
    private RemoteComponentSkeleton agent = null;
    private boolean isAttached = false;
    private boolean isMonitored = false;
    private boolean isAgentControllerAvailable = false;
    private AgentRecord agentRecord = null;
    private boolean isTraceInitialized = false;
    private Vector messageQueue = new Vector();
    private InetAddress hostAddress;
    private String agentId = null;
    private String processId = null;
    private String nodeId = null;
    private static final String J2EE_REQUEST_PROFILER = "J2EE Request Profiler";
    private static final String TYPE_PROFILER = "Profiler";
    private static J2eeRequestProfilerLogger logger = null;
    private HashMap methodCollection;
    private HashMap classCollection;
    private HashMap objectCollection;
    private HashMap threadCollection;
    static /* synthetic */ Class class$0;

    public J2eeRequestProfilerLogger() {
        J2eeRequestProfilerLogger j2eeRequestProfilerLogger = this;
        synchronized (j2eeRequestProfilerLogger) {
            try {
                this.agent = new RemoteComponentSkeleton(J2EE_REQUEST_PROFILER, TYPE_PROFILER);
                this.agent.addMonitorListener((MonitorListener)this);
                this.agent.addAgentControllerListener((AgentControllerListener)this);
                this.agent.addRemoteClientListener((RemoteClientListener)this);
                this.agent.initializeFast();
            }
            catch (Throwable throwable) {}
        }
        this.methodCollection = new HashMap();
        this.classCollection = new HashMap();
        this.objectCollection = new HashMap();
        this.threadCollection = new HashMap();
        try {
            this.hostAddress = InetAddress.getLocalHost();
        }
        catch (Exception exception) {}
    }

    public void agentControllerActive() {
        try {
            J2eeRequestProfilerLogger j2eeRequestProfilerLogger = this;
            synchronized (j2eeRequestProfilerLogger) {
                this.agentId = this.agent.getAgentUUID();
                this.nodeId = this.agent.getNodeUUID();
                this.processId = new Long(this.agent.getPID()).toString();
                this.agentRecord = new AgentRecord(logger, this.agentId, this.processId, this.agent.getName(), this.agent.getType(), J2eeRequestProfilerService.getCurrentTimeMillis());
            }
        }
        catch (Throwable throwable) {}
        this.isAgentControllerAvailable = true;
        this.isTraceInitialized = false;
    }

    public void agentControllerInactive() {
        this.isAgentControllerAvailable = false;
        this.isMonitored = false;
        this.isAttached = false;
        this.isTraceInitialized = false;
    }

    public void monitorActive() {
        this.isAttached = true;
        this.isMonitored = true;
    }

    public void monitorInactive() {
        this.isMonitored = false;
    }

    public void clientActive() {
    }

    public void clientInactive() {
        this.isAttached = false;
        this.classCollection.clear();
        this.methodCollection.clear();
        this.objectCollection.clear();
        this.threadCollection.clear();
        this.isTraceInitialized = false;
    }

    public void write(String message) {
        if (this.isMonitored) {
            if (this.isTraceInitialized) {
                this.agent.logMessageUTF8(this.agentRecord.toString());
                this.agent.logMessageUTF8(new TrcStartRecord().toString());
                this.flushMessageQueue();
                this.isTraceInitialized = true;
            }
            this.agent.logMessageUTF8(message);
        } else {
            this.messageQueue.add(message);
        }
    }

    public void flushMessageQueue() {
        Vector vector = this.messageQueue;
        synchronized (vector) {
            if (this.messageQueue.size() > 0 && this.isAgentControllerAvailable && this.isMonitored) {
                int i = 0;
                while (i < this.messageQueue.size()) {
                    this.agent.logMessageUTF8((String)this.messageQueue.elementAt(i));
                    ++i;
                }
                this.messageQueue.removeAllElements();
            }
        }
    }

    public void finalize() {
        this.agent.deregister();
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public static J2eeRequestProfilerLogger getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.etools.pd.sd.runtime.J2eeRequestProfilerLogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (logger == null) {
                logger = new J2eeRequestProfilerLogger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    public boolean isAgentControllerAvailable() {
        return this.isAgentControllerAvailable;
    }

    public boolean isMonitored() {
        return this.isMonitored;
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public boolean shouldCollectData(J2eeRequestProfilerCorrelator parent2) {
        if (this.isMonitored()) {
            return true;
        }
        if (this.isAttached() || !J2eeRequestProfilerService.isDynamicDiscoverySupported()) {
            return false;
        }
        if (parent2 == null) {
            return false;
        }
        String parentAgentUuid = parent2.getAgentUuid();
        return parentAgentUuid != null && !parentAgentUuid.equals(logger.getAgentId());
    }

    public void logCorrelator(int eventType, J2eeRequestProfilerCorrelator self, J2eeRequestProfilerCorrelator partner) {
        String methodId;
        MethodRecord methodRecord;
        Integer threadIdObj;
        ThreadRecord threadRecord;
        Integer objectIdObj;
        ObjRecord objRecord;
        String className;
        int threadId = Thread.currentThread().hashCode();
        className = className.substring((className = self.getClassName()).startsWith("class ") ? 6 : 0);
        int objectId = self.getInstanceId();
        String methodName = self.getMethodName();
        String methodSignature = self.getMethodSignature();
        self.setAgentUuid(logger.getAgentId());
        self.setNodeUuid(logger.getNodeId());
        self.setJvmUuid(logger.getProcessId());
        self.setAgentZeroUuid(partner == null ? logger.getAgentId() : partner.getAgentZeroUuid());
        self.setHostZeroAddress(partner == null ? logger.getHostAddress() : partner.getHostZeroAddress());
        self.setThreadId(threadId);
        ClassRecord classRecord = (ClassRecord)this.classCollection.get(className);
        if (classRecord == null) {
            classRecord = new ClassRecord(logger, className);
            classRecord.setTime(J2eeRequestProfilerService.getCurrentTimeMillis());
            this.classCollection.put(className, classRecord);
        }
        if ((objRecord = (ObjRecord)this.objectCollection.get(objectIdObj = new Integer(objectId))) == null) {
            objRecord = new ObjRecord(logger, threadId, objectId, J2eeRequestProfilerService.getCurrentTimeMillis(), classRecord, 0);
            this.objectCollection.put(objectIdObj, objRecord);
        }
        if ((threadRecord = (ThreadRecord)this.threadCollection.get(threadIdObj = new Integer(threadId))) == null) {
            threadRecord = new ThreadRecord(logger, Thread.currentThread().getName(), threadId, Thread.currentThread().getThreadGroup().getName(), "unknown", objRecord, J2eeRequestProfilerService.getCurrentTimeMillis());
            this.threadCollection.put(threadIdObj, threadRecord);
        }
        if ((methodRecord = (MethodRecord)this.methodCollection.get(methodId = String.valueOf(className) + "#" + methodName + "#" + methodSignature)) == null) {
            methodRecord = new MethodRecord(logger, methodName, classRecord);
            methodRecord.setSignature(self.getMethodSignature());
            this.methodCollection.put(methodId, methodRecord);
        }
        MethodAccessRecord methodAccessRecord = new MethodAccessRecord(logger, eventType, threadRecord, methodRecord, objRecord, 1);
        methodAccessRecord.setTime(J2eeRequestProfilerService.getCurrentTimeMillis());
        if (partner != null && partner.getAgentUuid() != null && !partner.getAgentUuid().equals(self.getAgentUuid()) && eventType == 1) {
            if (!this.isAttached) {
                this.agent.requestMonitorThroughPeer(partner.getHostZeroAddress(), partner.getAgentZeroUuid(), 10000L);
            }
            methodAccessRecord.setLocal(false);
            methodAccessRecord.addDCSContext("<InvocationContext nodeIdRef=\"" + partner.getNodeUuid() + "\" " + "processIdRef=\"" + partner.getJvmUuid() + "\" " + "agentIdRef=\"" + partner.getAgentUuid() + "\" " + "threadIdRef=\"" + partner.getThreadId() + "\" " + "ticket=\"" + partner.getApplicationCounter() + "\" " + "sequenceCounter=\"" + partner.getOperationCounter() + "\"/>");
        } else {
            methodAccessRecord.setLocal(true);
        }
        methodAccessRecord.setSequenceCounter(self.getOperationCounter());
        methodAccessRecord.setTicket(self.getApplicationCounter());
        methodAccessRecord.setStackDepth((int)self.getOperationCounter());
        methodAccessRecord.print();
    }
}

