/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime.records;

import com.ibm.etools.pd.sd.runtime.J2eeRequestProfilerLogger;
import com.ibm.etools.pd.sd.runtime.records.MethodRecord;
import com.ibm.etools.pd.sd.runtime.records.ObjRecord;
import com.ibm.etools.pd.sd.runtime.records.RecordImpl;
import com.ibm.etools.pd.sd.runtime.records.ThreadRecord;

public class MethodAccessRecord
extends RecordImpl {
    public static final int METHOD_UNKWN = 0;
    public static final int METHOD_ENTRY = 1;
    public static final int METHOD_EXIT = 2;
    public static final int METHOD_CALL = 3;
    public static final int METHOD_RETURN = 4;
    public static final String[] _recordHeader = new String[]{"", "<methodEntry", "<methodExit", "<methodCall", "<methodReturn"};
    public static final String[] _recordTrailer = new String[]{"", "</methodEntry>", "</methodExit>", "</methodCall>", "</methodReturn>"};
    private String _time;
    private MethodRecord _method;
    private ObjRecord _object;
    private ThreadRecord _thread;
    private long _ticket;
    private long _sequenceCounter;
    private String contextData;
    private int _stackDepth = 1;
    private String collationValue;
    private int _traceIdRef;
    private int _accessType;
    private String _dcsContext;
    private boolean _isLocal = true;
    private String _threadCpuTime;

    public MethodAccessRecord(J2eeRequestProfilerLogger logger, int type, ThreadRecord tr, MethodRecord mr, ObjRecord or, int stack_depth) {
        super(logger);
        this._accessType = type;
        this._thread = tr;
        this._time = "";
        this._method = mr;
        this._object = or;
        this._ticket = 0L;
        this.contextData = "";
        this._stackDepth = stack_depth;
        this.collationValue = "";
        this._traceIdRef = -1;
        this._dcsContext = null;
        this._isLocal = true;
    }

    public int getAccessType() {
        return this._accessType;
    }

    public String getTime() {
        return this._time;
    }

    public long getTicket() {
        return this._ticket;
    }

    public String threadCpuTime() {
        return this._threadCpuTime;
    }

    public long getSequenceCounter() {
        return this._sequenceCounter;
    }

    public void incCounter() {
        ++this._sequenceCounter;
    }

    public String getContext() {
        return this.contextData;
    }

    public int getStackDepth() {
        return this._stackDepth;
    }

    public String getCollationValue() {
        return this.collationValue;
    }

    public int getTraceIdRef() {
        return this._traceIdRef;
    }

    public ThreadRecord getThread() {
        return this._thread;
    }

    public void setTime(String t) {
        this._time = t;
    }

    public void setTicket(long t) {
        this._ticket = t;
    }

    public void setThreadCpuTime(String s) {
        this._threadCpuTime = s;
    }

    public void setSequenceCounter(long n) {
        this._sequenceCounter = n;
    }

    public void setContext(String s) {
        this.contextData = s;
    }

    public void setStackDepth(int n) {
        this._stackDepth = n;
    }

    public void setCollationValue(String s) {
        this.collationValue = s;
    }

    public void setTraceIdRef(int id) {
        this._traceIdRef = id;
    }

    public void addDCSContext(String context) {
        if (context == null || context.length() == 0) {
            return;
        }
        this._dcsContext = this._dcsContext == null ? context : String.valueOf(this._dcsContext) + context;
    }

    public void setLocal(boolean isLocal) {
        this._isLocal = isLocal;
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public MethodRecord getMethod() {
        return this._method;
    }

    public ObjRecord getObject() {
        return this._object;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(_recordHeader[this._accessType]);
        buffer.append(" threadIdRef=\"");
        buffer.append(this._thread.getThreadId());
        buffer.append("\" time=\"");
        buffer.append(this._time);
        if (this._method != null) {
            buffer.append("\" methodIdRef=\"");
            buffer.append(this._method.getId());
            if (this._method.getClassRecord() != null) {
                buffer.append("\" classIdRef=\"");
                buffer.append(this._method.getClassRecord().getId());
            }
            if (this._object != null) {
                buffer.append("\" objIdRef=\"");
                buffer.append(this._object.getId());
            }
        }
        buffer.append("\" ticket=\"");
        buffer.append(this._ticket);
        if (this._sequenceCounter >= 0L) {
            buffer.append("\" sequenceCounter=\"");
            buffer.append(this._sequenceCounter);
        }
        buffer.append("\" stackDepth=\"");
        buffer.append(this._stackDepth);
        if (this._traceIdRef != -1) {
            buffer.append("\" traceIdRef=\"");
            buffer.append(this._traceIdRef);
        }
        if (this._dcsContext == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">\n");
            buffer.append(this._dcsContext);
            buffer.append('\n');
            buffer.append(_recordTrailer[this._accessType]);
        }
        return buffer.toString();
    }

    public void print() {
        if (this._thread != null) {
            this._thread.print();
        }
        if (this._method != null) {
            this._method.print();
        }
        if (this._object != null) {
            this._object.print();
        }
        super.print();
    }
}

