/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime.records;

import com.ibm.etools.pd.sd.runtime.J2eeRequestProfilerLogger;
import com.ibm.etools.pd.sd.runtime.records.ClassRecord;
import com.ibm.etools.pd.sd.runtime.records.RecordImpl;

public class MethodRecord
extends RecordImpl {
    private String name;
    private String signature;
    private int startLineNo;
    private int endLineNo;
    private String sigNotation;
    private ClassRecord _cr;
    private String collationValue;
    private int traceIdRef;

    public MethodRecord(J2eeRequestProfilerLogger logger, String methodName, ClassRecord cr) {
        super(logger);
        this.name = methodName;
        this.signature = "";
        this.startLineNo = -1;
        this.endLineNo = -1;
        this.sigNotation = "";
        this._cr = cr;
        this.collationValue = "";
        this.traceIdRef = -1;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getStartLineNo() {
        return this.startLineNo;
    }

    public int getEndLineNo() {
        return this.endLineNo;
    }

    public String getSigNotation() {
        return this.sigNotation;
    }

    public String getCollationValue() {
        return this.collationValue;
    }

    public int getTraceIdRef() {
        return this.traceIdRef;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setSignature(String s) {
        this.signature = s;
    }

    public void setStartLineNo(int i) {
        this.startLineNo = i;
    }

    public void setEndLineNo(int i) {
        this.endLineNo = i;
    }

    public void setSigNotation(String s) {
        this.sigNotation = s;
    }

    public void setCollationValue(String s) {
        this.collationValue = s;
    }

    public void setTraceIdRef(int id) {
        this.traceIdRef = id;
    }

    public ClassRecord getClassRecord() {
        return this._cr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("<methodDef");
        if (this.name.length() > 0) {
            buffer.append(" name=\"");
            buffer.append(this.name);
            buffer.append('\"');
        }
        if (this.signature.length() > 0) {
            buffer.append(" signature=\"");
            buffer.append(this.signature);
            buffer.append('\"');
        }
        if (this.startLineNo != -1) {
            buffer.append(" startLineNo=\"");
            buffer.append(this.startLineNo);
            buffer.append('\"');
        }
        if (this.endLineNo != -1) {
            buffer.append(" endLineNo=\"");
            buffer.append(this.endLineNo);
            buffer.append('\"');
        }
        if (this.sigNotation.length() > 0) {
            buffer.append(" sigNotation=\"");
            buffer.append(this.sigNotation);
            buffer.append('\"');
        }
        if (this._cr != null) {
            buffer.append(" classIdRef=\"");
            buffer.append(this._cr.getId());
            buffer.append('\"');
        }
        buffer.append(" methodId=\"");
        buffer.append(this.getId());
        buffer.append('\"');
        if (this.collationValue.length() > 0) {
            buffer.append(" collationValue=\"");
            buffer.append(this.collationValue);
            buffer.append('\"');
        }
        if (this.traceIdRef > 0) {
            buffer.append(" traceIdRef=\"");
            buffer.append(this.traceIdRef);
            buffer.append('\"');
        }
        buffer.append("/>");
        return buffer.toString();
    }

    public void print() {
        if (this._cr != null) {
            this._cr.print();
        }
        super.print();
    }
}

