/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.pd.sd.runtime.records;

import com.ibm.etools.pd.sd.runtime.J2eeRequestProfilerService;
import java.net.InetAddress;
import java.util.TimeZone;

public class NodeRecord {
    private String nodeId;
    private String hostname;
    private String ipaddress;
    private String timezone;
    private String time;

    public NodeRecord() {
        try {
            InetAddress host = InetAddress.getLocalHost();
            this.ipaddress = host.getHostAddress();
            this.hostname = host.getHostName();
            byte[] b = host.getAddress();
            int len = b.length;
            this.nodeId = "";
            int i = 0;
            while (i < len) {
                this.nodeId = String.valueOf(this.nodeId) + b[i];
                ++i;
            }
        }
        catch (Exception exception) {
            this.hostname = "localhost";
            this.ipaddress = "127.0.0.1";
            this.nodeId = "UnknownHost";
        }
        this.time = J2eeRequestProfilerService.getCurrentTimeMillis();
        this.timezone = TimeZone.getDefault().getID();
    }

    public NodeRecord(String hostName) {
        try {
            InetAddress host = InetAddress.getByName(hostName);
            this.ipaddress = host.getHostAddress();
            this.hostname = host.getHostName();
            byte[] b = host.getAddress();
            int len = b.length;
            this.nodeId = "";
            int i = 0;
            while (i < len) {
                byte n = b[i];
                this.nodeId = String.valueOf(this.nodeId) + n;
                ++i;
            }
        }
        catch (Exception exception) {
            this.hostname = "UnknownHost";
            this.ipaddress = "???.???.???.???";
            this.nodeId = "UnknownHost";
        }
        this.time = J2eeRequestProfilerService.getCurrentTimeMillis();
        this.timezone = "";
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("<node nodeId=\"");
        buffer.append(this.nodeId);
        buffer.append("\" hostname=\"");
        buffer.append(this.hostname);
        buffer.append("\" ipaddress=\"");
        buffer.append(this.ipaddress);
        buffer.append("\" ");
        if (this.timezone.length() != 0) {
            buffer.append("timezone=\"");
            buffer.append(this.timezone);
            buffer.append("\" ");
        }
        buffer.append("time=\"");
        buffer.append(this.time);
        buffer.append("\"/>");
        return buffer.toString();
    }
}

