/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.deploy.core;

import com.ibm.etools.environment.command.AbstractCommand;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.resource.ResourceManager;
import com.ibm.etools.webservice.deploy.core.CommonDeploymentData;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.NestedDeploymentModule;
import com.ibm.etools.webservice.deploy.core.WebserviceClient;
import com.ibm.etools.webservice.deploy.core.Webservices;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public abstract class AbstractDeploymentModule
extends AbstractCommand {
    protected DeployModel model_;
    protected Environment environment_;
    protected File tempDir_;
    protected static int EJB_MODULE = 0;
    protected static int WEB_MODULE = 1;
    protected static int JAVA_MODULE = 2;
    protected static int UNKNOWN_MODULE = 3;
    private final String[] moduleTypeNames_ = new String[]{"EJB", "Servlet", "Bean", ""};

    public AbstractDeploymentModule(DeployModel deployModel) {
        this.model_ = deployModel;
    }

    public Status execute(Environment environment) {
        this.environment_ = environment;
        Status status = new SimpleStatus("");
        Archive archive = null;
        String string = null;
        try {
            try {
                archive = this.getModuleFile();
                string = archive.getName();
                this.trace(this.getMessage("TRACE_PROCESSING_START", string));
                Status status2 = this.setupModule();
                if (status2.getSeverity() < 4) {
                    if (this.model_.isDeployService()) {
                        status = this.deployWebservice(archive);
                    }
                    if (this.model_.isDeployClient() && status.getSeverity() == 0) {
                        status = this.deployWebserviceClient(archive);
                    }
                }
            }
            catch (Exception exception) {
                status = new SimpleStatus("", this.getMessage("ERROR_EXCEPTION_THROWN", exception.toString()), 4, exception);
            }
        }
        finally {
            this.trace(this.getMessage("TRACE_PROCESSING_END", string));
            try {
                this.saveModule();
                this.cleanupModule();
            }
            catch (Exception exception) {
                status = new SimpleStatus("", this.getMessage("ERROR_EXCEPTION_THROWN", exception.toString()), 4, exception);
            }
            if (archive != null && !(this instanceof NestedDeploymentModule)) {
                archive.close();
            }
        }
        return status;
    }

    protected abstract Archive getModuleFile();

    protected abstract void saveModule() throws Exception;

    protected abstract int getModuleType();

    protected abstract Status setupModule() throws Exception;

    protected abstract void cleanupModule() throws Exception;

    protected abstract URL getRootURL();

    protected abstract void compileCode() throws Exception;

    private Status deployWebservice(Archive archive) throws Exception {
        Webservices webservices = new Webservices(archive);
        CommonDeploymentData[] commonDeploymentDataArray = webservices.getWebservices();
        return this.deploy(commonDeploymentDataArray, archive, false);
    }

    private Status deployWebserviceClient(Archive archive) throws Exception {
        WebserviceClient webserviceClient = new WebserviceClient(archive);
        CommonDeploymentData[] commonDeploymentDataArray = webserviceClient.getWebserviceRefs();
        return this.deploy(commonDeploymentDataArray, archive, true);
    }

    private Status deploy(CommonDeploymentData[] commonDeploymentDataArray, Archive archive, boolean bl) throws Exception {
        Status status = new SimpleStatus("");
        if (commonDeploymentDataArray == null) {
            return status;
        }
        int n = 0;
        while (n < commonDeploymentDataArray.length) {
            String string = commonDeploymentDataArray[n].getWsdlFile();
            URL uRL = null;
            URL uRL2 = this.getRootURL();
            ResourceManager resourceManager = this.environment_.getResourceManager();
            if (string != null) {
                uRL = resourceManager.appends(uRL2, string);
            }
            if (uRL != null) {
                URL uRL3 = null;
                String string2 = commonDeploymentDataArray[n].getMappingFile();
                if (string2 != null) {
                    uRL3 = resourceManager.appends(uRL2, string2);
                }
                status = this.generateDeploymentCode(this.getModuleType() == WEB_MODULE, uRL.toString(), uRL3 == null ? null : uRL3.toString(), bl ? this.model_.getGeneratedClientSourceLocation() : this.model_.getGeneratedServiceSourceLocation(), archive, bl);
                if (!this.model_.isCodeGenOnly()) {
                    this.compileCode();
                }
            }
            ++n;
        }
        return status;
    }

    protected abstract Status generateDeploymentCode(boolean var1, String var2, String var3, String var4, Archive var5, boolean var6) throws Exception;

    protected String getModuleTypeName() {
        return this.moduleTypeNames_[this.getModuleType()];
    }

    private void trace(String string) {
        if (this.model_.isTrace()) {
            this.environment_.getProgressMonitor().report(string);
        }
    }

    protected String getMessage(String string, String string2) {
        String string3 = this.model_.getBundle().getString(string);
        return MessageFormat.format(string3, string2);
    }

    protected String getMessage(String string, String string2, String string3) {
        String string4 = this.model_.getBundle().getString(string);
        return MessageFormat.format(string4, string2, string3);
    }
}

