/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.deploy.core;

import com.ibm.etools.environment.command.Command;
import com.ibm.etools.environment.common.ClassPath;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.EARDeploymentModule;
import com.ibm.etools.webservice.deploy.core.NestedDeploymentModule;
import java.io.File;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ConsoleEARDeploymentModule
extends EARDeploymentModule {
    private File jarTempDir = null;

    public ConsoleEARDeploymentModule(EARFile eARFile, DeployModel deployModel) {
        super(eARFile, deployModel);
    }

    protected Command getNestedModuleCommand(Archive archive) {
        return new NestedDeploymentModule(archive, this.model_);
    }

    protected void setup() throws Exception {
        ClassPath classPath = this.model_.getClassPath();
        this.jarTempDir = ArchiveUtil.createTempDirectory((String)"Jardir", null);
        classPath.appendPath(this.buildClassJarpath(this.jarTempDir, this.earFile_));
        this.model_.setTempFiles(new Vector());
    }

    protected void save() throws Exception {
        this.earFile_.saveAsNoReopen(this.model_.getOutputFile());
        this.earFile_.close();
    }

    protected void cleanup() {
        if (this.jarTempDir != null) {
            ArchiveUtil.delete((File)this.jarTempDir);
        }
        this.deleteTempFiles();
    }

    private ClassPath buildClassJarpath(File file, EARFile eARFile) throws Exception {
        ClassPath classPath = new ClassPath();
        eARFile.extractTo(file.getAbsolutePath(), 0);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].getName().endsWith(".jar")) {
                classPath.appendPath(fileArray[n].getAbsolutePath());
            }
            ++n;
        }
        return classPath;
    }

    private void deleteTempFiles() {
        Vector vector = this.model_.getTempFiles();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                File file = new File(string);
                if (file.exists()) {
                    ArchiveUtil.delete((File)file);
                }
                ++n;
            }
        }
    }
}

