/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.deploy.core;

import com.ibm.etools.environment.command.AbstractCommand;
import com.ibm.etools.environment.command.Command;
import com.ibm.etools.environment.commandline.CommandLine;
import com.ibm.etools.environment.common.ClassPath;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.Main;
import com.ibm.etools.environment.console.ParsingCommand;
import com.ibm.etools.webservice.deploy.core.DeployCommandLine;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.DeploymentFactory;
import com.ibm.etools.webservice.deploy.core.Utils;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;

public class DeployWebService
extends AbstractCommand
implements ParsingCommand {
    private DeployModel model_ = null;

    public DeployWebService() {
        DeployModel deployModel = new DeployModel();
        this.setDeployModel(deployModel);
    }

    public Status parse(String[] stringArray, Environment environment) {
        DeployCommandLine deployCommandLine = new DeployCommandLine(this.model_.getBundle());
        ProgressMonitor progressMonitor = environment.getProgressMonitor();
        String[] stringArray2 = new String[stringArray.length - 1];
        int n = 1;
        while (n < stringArray.length) {
            stringArray2[n - 1] = stringArray[n];
            ++n;
        }
        try {
            deployCommandLine.check_flags(stringArray2);
        }
        catch (CommandLine.Flag_error flag_error) {
            progressMonitor.report(flag_error.getMessage());
            progressMonitor.report("");
            progressMonitor.report(deployCommandLine.get_help_text());
            return new SimpleStatus("", "", 4);
        }
        if (deployCommandLine.flag_specified("FLAG_HELP")) {
            progressMonitor.report(deployCommandLine.get_help_text());
            return new SimpleStatus("", "", 2);
        }
        DeployWebService.populateModelFromCommandline(deployCommandLine, this.model_);
        return new SimpleStatus("");
    }

    public Status execute(Environment environment) {
        return this.deploy(this.model_, environment);
    }

    public void setDeployModel(DeployModel deployModel) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.etools.webservice.deploy.core.deploy");
        this.model_ = deployModel;
        this.model_.setBundle(resourceBundle);
    }

    private Status deploy(DeployModel deployModel, Environment environment) {
        Status status = new SimpleStatus("");
        try {
            String string = deployModel.getInputFile();
            Archive archive = null;
            ClassPath classPath = deployModel.getClassPath();
            try {
                archive = DeployWebService.getArchiveFactory().openArchive(string);
            }
            catch (Exception exception) {
                environment.getProgressMonitor().report(this.getMessage("ERROR_OPENING_FILE", string));
                return new SimpleStatus("", exception.getMessage(), 4);
            }
            Utils.registerXML();
            classPath.appendPath(System.getProperty("java.class.path"));
            Command command = DeploymentFactory.createDeploymentCommand(archive, deployModel);
            if (command == null) {
                environment.getProgressMonitor().report(this.getMessage("ERROR_CANT_DEPLOY", string));
            } else {
                status = command.execute(environment);
                if (status.getSeverity() != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Utils.getMessageFromStatus(status, 0, stringBuffer);
                    environment.getProgressMonitor().report(stringBuffer.toString());
                }
            }
            DeployWebService.getArchiveFactory().closeOpenArchives();
        }
        catch (Exception exception) {
            status = new SimpleStatus("", exception.toString(), 4, exception);
        }
        return status;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = DeployWebService.class.getName();
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        Main.main(stringArray2);
    }

    private static void populateModelFromCommandline(DeployCommandLine deployCommandLine, DeployModel deployModel) {
        deployModel.setInputFile(deployCommandLine.get_positionals()[0]);
        deployModel.setOutputFile(deployCommandLine.get_positionals()[1]);
        deployModel.setCodeGenOnly(deployCommandLine.flag_specified("FLAG_CODEGEN"));
        deployModel.setGenDebug(deployCommandLine.flag_specified("FLAG_DEBUG"));
        deployModel.setKeepFiles(deployCommandLine.flag_specified("FLAG_KEEP"));
        deployModel.setIgnoreErrors_(deployCommandLine.flag_specified("FLAG_IGNORE"));
        deployModel.setTrace(deployCommandLine.flag_specified("FLAG_TRACE"));
        deployModel.setDoValidation(!deployCommandLine.flag_specified("FLAG_NOVALIDATE"));
        if (deployModel.isCodeGenOnly()) {
            deployModel.setKeepFiles(true);
        }
        String[] stringArray = new String[]{};
        ClassPath classPath = new ClassPath();
        if (deployCommandLine.flag_specified("FLAG_CLASSPATH")) {
            String string = deployCommandLine.get_flag_parms("FLAG_CLASSPATH")[0];
            classPath.appendPath(string);
        }
        if (deployCommandLine.flag_specified("FLAG_JARDIR")) {
            stringArray = deployCommandLine.get_flag_parms("FLAG_JARDIR");
        }
        int n = 0;
        while (n < stringArray.length) {
            ClassPath classPath2 = new ClassPath();
            classPath2.appendDir(stringArray[n]);
            classPath.appendPath(classPath2);
            ++n;
        }
        deployModel.setClassPath(classPath);
    }

    private static CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactoryImpl.getActiveFactory();
    }

    private String getMessage(String string, String string2) {
        String string3 = this.model_.getBundle().getString(string);
        return MessageFormat.format(string3, string2);
    }
}

