/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.deploy.core;

import com.ibm.etools.environment.command.AbstractCommand;
import com.ibm.etools.environment.command.Command;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;

public abstract class EARDeploymentModule
extends AbstractCommand {
    protected EARFile earFile_;
    protected DeployModel model_;

    public EARDeploymentModule(EARFile eARFile, DeployModel deployModel) {
        this.earFile_ = eARFile;
        this.model_ = deployModel;
    }

    protected abstract void setup() throws Exception;

    protected abstract void save() throws Exception;

    protected abstract void cleanup();

    protected abstract Command getNestedModuleCommand(Archive var1);

    public Status execute(Environment environment) {
        Status status = new SimpleStatus("");
        try {
            try {
                EList eList = this.earFile_.getDeploymentDescriptor().getModules();
                this.setup();
                int n = 0;
                while (n < eList.size()) {
                    Module module = (Module)eList.get(n);
                    Archive archive = (Archive)this.earFile_.getFile(module.getUri());
                    Command command = this.getNestedModuleCommand(archive);
                    if (command != null) {
                        status = command.execute(environment);
                    }
                    if (status.getSeverity() == 4) break;
                    ++n;
                }
                this.save();
            }
            catch (Exception exception) {
                status = new SimpleStatus("", String.valueOf(this.getMessage("ERROR_DEPLOYMENT", "")) + exception.toString(), 4, exception);
            }
        }
        finally {
            this.cleanup();
        }
        return status;
    }

    protected String getMessage(String string, String string2) {
        String string3 = this.model_.getBundle().getString(string);
        return MessageFormat.format(string3, string2);
    }
}

