/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.deploy.core;

import com.ibm.etools.environment.common.ClassPath;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.webservice.deploy.core.AbstractCmdDeploymentModule;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.WebserviceXMLException;
import com.sun.tools.javac.Main;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class NestedDeploymentModule
extends AbstractCmdDeploymentModule {
    private Archive module_;
    private File generatedOutputDir_;
    private File classDestDir_;
    private File rootClassDir_;

    public NestedDeploymentModule(Archive archive, DeployModel deployModel) {
        super(deployModel);
        this.module_ = archive;
    }

    protected Archive getModuleFile() {
        return this.module_;
    }

    protected void saveModule() throws Exception {
        String string = this.module_.getURI();
        this.model_.getTempFiles().add(string);
    }

    protected int getModuleType() {
        int n = UNKNOWN_MODULE;
        if (this.module_.isEJBJarFile()) {
            n = EJB_MODULE;
        } else if (this.module_.isWARFile()) {
            n = WEB_MODULE;
        } else if (this.module_.isApplicationClientFile()) {
            n = JAVA_MODULE;
        }
        return n;
    }

    protected URL getRootURL() {
        URL uRL = null;
        try {
            uRL = this.tempDir_.toURL();
        }
        catch (Exception exception) {}
        return uRL;
    }

    protected Status setupModule() throws Exception {
        String string;
        this.tempDir_ = ArchiveUtil.createTempDirectory((String)"Base", null);
        this.getModuleFile().extractTo(this.tempDir_.getAbsolutePath(), 0);
        this.generatedOutputDir_ = new File(this.tempDir_, "generatedSource");
        this.classDestDir_ = null;
        this.rootClassDir_ = new File(this.tempDir_, "rootClassDir");
        if (this.model_.isKeepFiles()) {
            string = this.getMessage("TRACE_KEEPING_DIRECTORY", this.tempDir_.getAbsolutePath(), this.getModuleFile().getName());
            this.environment_.getProgressMonitor().report(string);
        }
        this.rootClassDir_.mkdir();
        if (this.getModuleType() == WEB_MODULE) {
            this.classDestDir_ = new File(this.rootClassDir_, "WEB-INF" + File.separator + "classes");
            this.classDestDir_.mkdirs();
        } else {
            this.classDestDir_ = this.rootClassDir_;
        }
        this.generatedOutputDir_.mkdir();
        string = this.generatedOutputDir_.toURL().toString();
        this.model_.setGeneratedClientSourceLocation(string);
        this.model_.setGeneratedServiceSourceLocation(string);
        return new SimpleStatus("");
    }

    protected void cleanupModule() throws Exception {
        if (this.tempDir_ != null && !this.model_.isKeepFiles()) {
            this.model_.getTempFiles().add(this.tempDir_.getAbsolutePath());
        }
    }

    protected void compileCode() throws Exception {
        this.compileJavaCode(this.generatedOutputDir_, this.classDestDir_);
        this.copyGeneratedClassFiles(this.rootClassDir_, this.module_);
    }

    private void compileJavaCode(File file, File file2) throws Exception {
        Object object;
        Vector vector = new Vector();
        String string = file2.getAbsolutePath();
        this.getJavaSourceFiles(file, vector);
        if (vector.size() < 1) {
            return;
        }
        ClassPath classPath = new ClassPath();
        classPath.appendPath(this.model_.getClassPath());
        classPath.appendPath(string);
        if (this.getModuleType() == WEB_MODULE) {
            this.appendWebModulePaths(classPath);
        }
        File file3 = File.createTempFile("wsd", "rsp");
        String string2 = file3.getAbsolutePath();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file3));
        int n = 0;
        while (n < vector.size()) {
            object = (File)vector.elementAt(n);
            printWriter.println(((File)object).getAbsolutePath());
            ++n;
        }
        printWriter.close();
        String[] stringArray = null;
        stringArray = this.model_.isGenDebug() ? new String[]{"-classpath", classPath.toString(), "-sourcepath", file.getAbsolutePath(), "-d", string, "-g", "@" + string2} : new String[]{"-classpath", classPath.toString(), "-sourcepath", file.getAbsolutePath(), "-d", string, "@" + string2};
        object = null;
        Method method2 = Main.class.getDeclaredMethod("compile", String[].class);
        if (!Modifier.isStatic(method2.getModifiers())) {
            object = new Main();
        }
        this.trace(this.getMessage("TRACE_COMPILING", string2));
        Object object2 = method2.invoke(object, new Object[]{stringArray});
        int n2 = (Integer)object2;
        if (!this.model_.isKeepFiles()) {
            this.model_.getTempFiles().add(string2);
        }
        if (n2 != 0) {
            String string3 = this.getModuleFile().getName();
            if (!this.model_.isIgnoreErrors()) {
                throw new WebserviceXMLException(this.getMessage("ERROR_COMPILATION", string3));
            }
        }
    }

    private void appendWebModulePaths(ClassPath classPath) {
        File file = new File(this.tempDir_, "WEB-INF");
        File file2 = new File(file, "classes");
        File file3 = new File(file, "lib");
        classPath.appendPath(file2.getAbsolutePath());
        if (file3.isDirectory()) {
            classPath.appendDir(file3.getAbsolutePath());
        }
    }

    private void copyGeneratedClassFiles(File file, Archive archive) throws Exception {
        ReadOnlyDirectory readOnlyDirectory = null;
        readOnlyDirectory = this.getArchiveFactory().openReadOnlyDirectory(file.getAbsolutePath());
        List list = readOnlyDirectory.getFilesRecursive();
        int n = 0;
        while (n < list.size()) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file2 = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)list.get(n);
            String string = file2.getURI();
            if (string.endsWith(".class")) {
                org.eclipse.jst.j2ee.commonarchivecore.internal.File file3 = this.getFile(archive, string);
                if (archive.containsFile(string)) {
                    archive.remove(file3);
                }
                archive.addCopy(file2);
            }
            ++n;
        }
    }

    private void getJavaSourceFiles(File file, Vector vector) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                this.getJavaSourceFiles(file2, vector);
            } else if (file2.getName().endsWith(".java")) {
                vector.add(file2);
            }
            ++n;
        }
    }

    private org.eclipse.jst.j2ee.commonarchivecore.internal.File getFile(Archive archive, String string) {
        org.eclipse.jst.j2ee.commonarchivecore.internal.File file = null;
        try {
            file = archive.getFile(string);
        }
        catch (Exception exception) {}
        return file;
    }

    private CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactoryImpl.getActiveFactory();
    }

    private void trace(String string) {
        if (this.model_.isTrace()) {
            this.environment_.getProgressMonitor().report(string);
        }
    }

    protected String getMessage(String string, String string2) {
        String string3 = this.model_.getBundle().getString(string);
        return MessageFormat.format(string3, string2);
    }

    protected String getMessage(String string, String string2, String string3) {
        String string4 = this.model_.getBundle().getString(string);
        return MessageFormat.format(string4, string2, string3);
    }
}

