/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.deploy.core;

import com.ibm.etools.webservice.deploy.core.ServiceRef;
import com.ibm.etools.webservice.deploy.core.Utils;
import com.ibm.etools.webservice.deploy.core.WebserviceClientBnd;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;

public class WebserviceClient {
    private static final String WEBSERVICECLIENT_FILENAME = "webservicesclient.xml";
    private Archive modFile_ = null;
    private WebserviceClientBnd clientBnd_ = null;

    public WebserviceClient(Archive archive) {
        this.clientBnd_ = new WebserviceClientBnd(archive);
        this.modFile_ = archive;
    }

    public ServiceRef[] getWebserviceRefs() {
        WebServicesClient webServicesClient = this.getClientModel();
        ServiceRef[] serviceRefArray = null;
        if (webServicesClient != null) {
            serviceRefArray = this.getServiceRefsFromClientModel(webServicesClient);
        } else if (this.modFile_.isEJBJarFile()) {
            serviceRefArray = this.getServiceRefsFromEJB();
        } else if (this.modFile_.isApplicationClientFile()) {
            ApplicationClientFile applicationClientFile = (ApplicationClientFile)this.modFile_;
            Vector vector = this.getServiceRefsFromList((List)applicationClientFile.getDeploymentDescriptor().getServiceRefs(), null);
            serviceRefArray = vector.toArray(new ServiceRef[0]);
        } else if (this.modFile_.isWARFile()) {
            WARFile wARFile = (WARFile)this.modFile_;
            Vector vector = this.getServiceRefsFromList((List)wARFile.getDeploymentDescriptor().getServiceRefs(), null);
            serviceRefArray = vector.toArray(new ServiceRef[0]);
        }
        return serviceRefArray;
    }

    private Vector getServiceRefsFromList(List list, String string) {
        Vector<ServiceRef> vector = new Vector<ServiceRef>();
        int n = 0;
        while (n < list.size()) {
            org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef = (org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef)list.get(n);
            vector.add(new ServiceRef(serviceRef, string, this.clientBnd_));
            ++n;
        }
        return vector;
    }

    private WebServicesClient getClientModel() {
        String string = Utils.getModulePath(this.modFile_, WEBSERVICECLIENT_FILENAME);
        WebServicesClient webServicesClient = null;
        if (this.modFile_.containsFile(string)) {
            try {
                WebServicesResource webServicesResource = (WebServicesResource)this.modFile_.getMofResource(string);
                webServicesClient = webServicesResource.getWebServicesClient();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return webServicesClient;
    }

    private ServiceRef[] getServiceRefsFromClientModel(WebServicesClient webServicesClient) {
        EList eList = webServicesClient.getServiceRefs();
        EList eList2 = webServicesClient.getComponentScopedRefs();
        ServiceRef[] serviceRefArray = null;
        if (eList.size() != 0) {
            Vector vector = this.getServiceRefsFromList((List)eList, null);
            serviceRefArray = vector.toArray(new ServiceRef[0]);
        } else {
            Vector vector = new Vector();
            int n = 0;
            while (n < eList2.size()) {
                ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)eList2.get(n);
                EList eList3 = componentScopedRefs.getServiceRefs();
                vector.addAll(this.getServiceRefsFromList((List)eList3, componentScopedRefs.getComponentName()));
                ++n;
            }
            serviceRefArray = vector.toArray(new ServiceRef[0]);
        }
        return serviceRefArray;
    }

    private ServiceRef[] getServiceRefsFromEJB() {
        EJBJarFile eJBJarFile = (EJBJarFile)this.modFile_;
        EList eList = eJBJarFile.getDeploymentDescriptor().getEnterpriseBeans();
        Vector vector = new Vector();
        int n = 0;
        while (n < eList.size()) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(n);
            vector.addAll(this.getServiceRefsFromList((List)enterpriseBean.getServiceRefs(), enterpriseBean.getName()));
            ++n;
        }
        return vector.toArray(new ServiceRef[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Webservicesclient:\n");
        ServiceRef[] serviceRefArray = this.getWebserviceRefs();
        int n = 0;
        while (n < serviceRefArray.length) {
            serviceRefArray[n].dumpString(stringBuffer);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

