/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.htmt.rmm;

import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.RmmLogger;
import java.util.Properties;

public class Config {
    static final String moduleName = "RMM_API";
    RmmLogger rmmLogger;
    public static final int U_MIN_GLOBAL_MEMORY = 10;
    public static final int MU_MIN_GLOBAL_MEMORY = 10;
    public static final int SMALL_MEM_CONFIG = 20;
    public static final int MEDIUM_MEM_CONFIG = 50;
    public static final int LARGE_MEM_CONFIG = 100;
    public static final int U_DEF_GLOBAL_MEMORY = 50;
    public static final int MU_DEF_GLOBAL_MEMORY = 70;
    int global_mem = 70;
    int max_global_mem = 0;
    String networkingType = "RealMulticast";
    String unicastTransport = "TCPChannel";
    String multicastTransport = "PTL";
    String direction = "Both";
    String multicastDataPort = "23445";
    String ttl = "1";
    String unicastServerSocketPort = null;
    String networkInterface = "none";
    String heartbeatInterval = "1000";
    String heartbeatTimeoutSec = "20";
    String packetSize = "8000";
    String rateLimitPolicy = "Disabled";
    String transmissionRateLimit = "250000";
    String messageAnnouncerThreads = "0";
    String tcpKeepAlive = "false";
    String multicastSocketReceptionBufferSize = "1024";
    String unicastSocketReceptionBufferSize = "256";
    String unicastSocketTransmissionBufferSize = "64";
    String bindAll = "true";
    String clockUpdateIntervalMilli = "25";
    String recHeartbeatTimeoutMillis = null;
    String maxTagLength = null;
    int utPending = 4096;
    int urReceive = 16384;
    int urBuffers = 4096;
    int mtPending = 4096;
    int mtHistory = 25600;
    int mrReceive = 20480;
    int mrBuffers = 4096;

    Config(LogEventListener l) {
        this.rmmLogger = new RmmLogger(l, 2, 2);
    }

    boolean parseConfigParams(Properties rmm_config, Properties tx_config, Properties rx_config) {
        String prop = rmm_config.getProperty("NominalInstanceMemoryMbytes");
        if (prop != null) {
            try {
                this.global_mem = Integer.parseInt(prop);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("NominalInstanceMemoryMbytes", prop, e2, moduleName);
                return false;
            }
            if (this.global_mem < 10) {
                this.rmmLogger.baseBadParam("Not enough memory allocated for RMM. NominalInstanceMemoryMbytes", "" + this.global_mem, null, moduleName);
                return false;
            }
            if (this.global_mem > 1024) {
                this.rmmLogger.baseWarn("NominalInstanceMemoryMbytes exceeds GB", null, moduleName);
            }
        } else {
            this.rmmLogger.baseWarn("NominalInstanceMemoryMbytes not supplied. Using default " + this.global_mem, null, moduleName);
        }
        if ((prop = rmm_config.getProperty("MaxInstanceMemoryMbytes")) != null) {
            try {
                this.max_global_mem = Integer.parseInt(prop);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("MaxInstanceMemoryMbytes", prop, e3, moduleName);
                return false;
            }
            if (this.max_global_mem > 0 && this.max_global_mem < this.global_mem) {
                this.rmmLogger.baseBadParam("MaxInstanceMemoryMbytes (" + this.max_global_mem + ") must not be less than NominalInstanceMemoryMbytes (" + this.global_mem + ")", "" + this.max_global_mem, null, moduleName);
                return false;
            }
        }
        if (this.max_global_mem <= 0) {
            this.rmmLogger.baseWarn("MaxInstanceMemoryMbytes not supplied. No limit will be enforced.", null, moduleName);
            this.max_global_mem = 0;
        }
        if ((prop = rmm_config.getProperty("NetworkingType")) != null) {
            if (prop.equalsIgnoreCase("RealMulticast")) {
                this.networkingType = "RealMulticast";
            } else if (prop.equalsIgnoreCase("EmulatedMulticast")) {
                this.networkingType = "EmulatedMulticast";
            } else {
                this.rmmLogger.baseBadParam("NetworkingType", prop, null, moduleName);
                return false;
            }
        }
        if ((prop = rmm_config.getProperty("UnicastTransportType")) != null) {
            if (prop.equalsIgnoreCase("TCPChannel")) {
                this.unicastTransport = "TCPChannel";
            } else if (prop.equalsIgnoreCase("TCP")) {
                this.unicastTransport = "TCP";
            } else {
                this.rmmLogger.baseBadParam("UnicastTransportType", prop, null, moduleName);
                return false;
            }
        }
        if ((prop = rmm_config.getProperty("MulticastTransportProtocol")) != null) {
            if (prop.equalsIgnoreCase("PTL")) {
                this.multicastTransport = "PTL";
            } else if (prop.equalsIgnoreCase("PGM")) {
                this.multicastTransport = "PGM";
            } else if (prop.equalsIgnoreCase("UDPEncapsulatedPGM")) {
                this.multicastTransport = "UDPEncapsulatedPGM";
            } else {
                this.rmmLogger.baseBadParam("MulticastTransportProtocol", prop, null, moduleName);
                return false;
            }
        }
        if ((prop = rmm_config.getProperty("TransportDirection")) != null) {
            if (prop.equalsIgnoreCase("Both")) {
                this.direction = "Both";
            } else if (prop.equalsIgnoreCase("In")) {
                this.direction = "In";
            } else if (prop.equalsIgnoreCase("Out")) {
                this.direction = "Out";
            } else {
                this.rmmLogger.baseBadParam("TransportDirection", prop, null, moduleName);
                return false;
            }
        }
        if ((prop = rmm_config.getProperty("MulticastDataPort")) != null) {
            this.multicastDataPort = prop;
        }
        if ((prop = rmm_config.getProperty("MulticastTTL")) != null) {
            this.ttl = prop;
        }
        if ((prop = rmm_config.getProperty("UnicastServerSocketPort")) != null) {
            this.unicastServerSocketPort = prop;
        }
        if ((prop = rmm_config.getProperty("NetworkInterface")) != null) {
            this.networkInterface = prop;
        }
        if ((prop = rmm_config.getProperty("BindAllInterfaces")) != null) {
            this.bindAll = prop;
        }
        if ((prop = rmm_config.getProperty("HeartbeatIntervalMillis")) != null) {
            this.heartbeatInterval = prop;
        }
        int timeoutSec = 0;
        prop = rmm_config.getProperty("HeartbeatTimeoutSec");
        if (prop != null) {
            this.heartbeatTimeoutSec = prop;
            try {
                timeoutSec = Integer.parseInt(prop);
            }
            catch (NumberFormatException e4) {
                timeoutSec = 20;
            }
        }
        if ((prop = rmm_config.getProperty("HeartbeatTimeoutMillis")) != null) {
            this.recHeartbeatTimeoutMillis = prop;
            try {
                timeoutSec = Integer.parseInt(prop);
            }
            catch (NumberFormatException e5) {
                timeoutSec = 20000;
            }
            if ((timeoutSec /= 1000) > 0) {
                this.heartbeatTimeoutSec = "" + timeoutSec;
            }
        }
        if ((prop = rmm_config.getProperty("PacketSizeBytes")) != null) {
            this.packetSize = prop;
        }
        if ((prop = rmm_config.getProperty("RateControlPolicy")) != null) {
            if (prop.equalsIgnoreCase("Disabled")) {
                this.rateLimitPolicy = "Disabled";
            } else if (prop.equalsIgnoreCase("Static")) {
                this.rateLimitPolicy = "Static";
            } else if (prop.equalsIgnoreCase("Dynamic")) {
                this.rateLimitPolicy = "Dynamic";
            } else {
                this.rmmLogger.baseBadParam("RateLimitPolicy", prop, null, moduleName);
                return false;
            }
        }
        if ((prop = rmm_config.getProperty("TransRateLimitKbps")) != null) {
            this.transmissionRateLimit = prop;
        }
        if ((prop = rmm_config.getProperty("MulticastSocketReceptionBufferSizeKBytes")) != null) {
            this.multicastSocketReceptionBufferSize = prop;
        }
        if ((prop = rmm_config.getProperty("UnicastSocketReceptionBufferSizeKBytes")) != null) {
            this.unicastSocketReceptionBufferSize = prop;
        }
        if ((prop = rmm_config.getProperty("UnicastSocketTransmissionBufferSizeKBytes")) != null) {
            this.unicastSocketTransmissionBufferSize = prop;
        }
        if ((prop = rmm_config.getProperty("MessageAnnouncerThreadsNumber")) != null) {
            this.messageAnnouncerThreads = prop;
        }
        if ((prop = rmm_config.getProperty("UseTCPKeepAlive")) != null) {
            this.tcpKeepAlive = prop;
        }
        if ((prop = rmm_config.getProperty("MaximalTagLength")) != null) {
            this.maxTagLength = prop;
        }
        if (this.networkingType.equalsIgnoreCase("EmulatedMulticast") && timeoutSec > 20) {
            this.clockUpdateIntervalMilli = timeoutSec > 60 ? (this.unicastTransport.equalsIgnoreCase("TCPChannel") ? "5000" : "2500") : "1000";
        }
        if (!this.setMemoryAllocation()) {
            this.rmmLogger.baseError("MaxInstanceMemoryMbytes too low (" + this.global_mem + ")", null, moduleName);
            this.rmmLogger.baseBadParam("MaxInstanceMemoryMbytes", "" + this.global_mem, null, moduleName);
            return false;
        }
        this.setConfigProperties(tx_config, rx_config);
        return true;
    }

    private boolean setMemoryAllocation() {
        if (this.networkingType.equalsIgnoreCase("EmulatedMulticast")) {
            if (this.global_mem < 10) {
                return false;
            }
            this.mtPending = 0;
            this.mtHistory = 0;
            this.mrReceive = 0;
            this.mrBuffers = 0;
            int n = this.utPending = this.global_mem > 50 ? 4096 : 512;
            this.urBuffers = this.global_mem > 100 ? 12288 : (this.global_mem > 50 ? 8192 : 4096);
            this.urReceive = 1024 * this.global_mem - this.utPending - this.urBuffers;
            return true;
        }
        if (this.global_mem < 10) {
            return false;
        }
        this.utPending = this.mtPending = this.global_mem > 50 ? 4096 : 512;
        this.urBuffers = this.global_mem > 100 ? 12288 : (this.global_mem > 50 ? 4096 : 1024);
        this.mrBuffers = this.urBuffers;
        if (this.direction.equalsIgnoreCase("In")) {
            this.mtHistory = this.global_mem > 50 ? 10240 : 2048;
            int memUsed = this.mtPending + this.utPending + this.mrBuffers + this.urBuffers + this.mtHistory;
            this.urReceive = this.mrReceive = (1024 * this.global_mem - memUsed) / 2;
        } else if (this.direction.equalsIgnoreCase("Out")) {
            this.urReceive = this.mrReceive = this.global_mem > 50 ? 8192 : 2048;
            int memUsed = this.mtPending + this.utPending + this.mrBuffers + this.urBuffers + this.mrReceive + this.urReceive;
            this.mtHistory = 1024 * this.global_mem - memUsed;
        } else {
            int memUsed = this.mtPending + this.utPending + this.mrBuffers + this.urBuffers;
            this.mtHistory = (1024 * this.global_mem - memUsed) / 2;
            this.urReceive = this.mrReceive = (1024 * this.global_mem - (memUsed += this.mtHistory)) / 2;
        }
        return true;
    }

    private void setConfigProperties(Properties tx_prop, Properties rx_prop) {
        int size;
        tx_prop.clear();
        rx_prop.clear();
        rx_prop.setProperty("DataPort", this.multicastDataPort);
        rx_prop.setProperty("MulticastInterface", this.networkInterface);
        rx_prop.setProperty("BindAllInterfaces", this.bindAll);
        if (this.unicastServerSocketPort != null) {
            rx_prop.setProperty("ServerSocketPort", this.unicastServerSocketPort);
        }
        if (this.networkingType.equalsIgnoreCase("EmulatedMulticast")) {
            rx_prop.setProperty("DisableMulticast", "true");
        } else {
            rx_prop.setProperty("DisableMulticast", "false");
        }
        rx_prop.setProperty("DisableUnicast", "false");
        if (this.unicastTransport.equalsIgnoreCase("TCPChannel")) {
            rx_prop.setProperty("UseTcpChannel", "true");
        } else {
            rx_prop.setProperty("UseTcpChannel", "false");
        }
        if (this.multicastTransport.equalsIgnoreCase("UDPEncapsulatedPGM")) {
            rx_prop.setProperty("ProtocolType", "PGM/UDP");
        }
        if (this.multicastTransport.equalsIgnoreCase("PGM")) {
            rx_prop.setProperty("ProtocolType", "PGM/IP");
        }
        try {
            size = Integer.parseInt(this.packetSize);
        }
        catch (NumberFormatException e2) {
            size = 8192;
        }
        if (size < 8192) {
            size = 8192;
        }
        String packetBufferSize = size <= 8192 ? "8192" : this.packetSize;
        rx_prop.setProperty("PacketBufferSizeBytes", packetBufferSize);
        int buffs = 1024 * this.urBuffers / size;
        rx_prop.setProperty("PacketBuffers", "" + buffs);
        size = this.mrReceive + this.urReceive;
        rx_prop.setProperty("ReceptionBufferLimitKbytes", "" + size);
        if (this.max_global_mem > 0) {
            size = this.mrReceive + this.urReceive + 1024 * (this.max_global_mem - this.global_mem);
            rx_prop.setProperty("MaxReceptionBufferLimitKbytes", "" + size);
        } else {
            rx_prop.setProperty("MaxReceptionBufferLimitKbytes", "0");
        }
        if (this.networkingType.equalsIgnoreCase("RealMulticast")) {
            rx_prop.setProperty("EnableAdminModule", "true");
        } else {
            rx_prop.setProperty("EnableAdminModule", "false");
        }
        try {
            size = Integer.parseInt(this.messageAnnouncerThreads);
        }
        catch (NumberFormatException e3) {
            size = 0;
        }
        rx_prop.setProperty("MessageAnnouncerThreads", this.messageAnnouncerThreads);
        if (size <= 0) {
            rx_prop.setProperty("ThreadPerTopic", "true");
        } else {
            rx_prop.setProperty("ThreadPerTopic", "false");
        }
        rx_prop.setProperty("SocketBufferSizeKbytes", this.multicastSocketReceptionBufferSize);
        rx_prop.setProperty("TcpSocketBufferSizeKbytes", this.unicastSocketReceptionBufferSize);
        rx_prop.setProperty("ClockUpdateIntervalMilli", this.clockUpdateIntervalMilli);
        rx_prop.setProperty("AdminMulticastGroup", "239.39.39.39");
        rx_prop.setProperty("BackoffTimeMillis", "0");
        rx_prop.setProperty("NackCheckPeriodMillis", "300");
        rx_prop.setProperty("CollectStats", "true");
        rx_prop.setProperty("StatisticsPeriodSec", "10");
        if (this.recHeartbeatTimeoutMillis != null) {
            rx_prop.setProperty("HeartbeatTimeoutMillis", this.recHeartbeatTimeoutMillis);
        }
        if (this.maxTagLength != null) {
            rx_prop.setProperty("MaximalTagLength", this.maxTagLength);
        }
        tx_prop.setProperty("DataPort", this.multicastDataPort);
        tx_prop.setProperty("PacketSizeBytes", this.packetSize);
        tx_prop.setProperty("MulticastInterface", this.networkInterface);
        if (this.networkInterface.equalsIgnoreCase("all")) {
            tx_prop.setProperty("BindAllInterfaces", this.bindAll);
        } else {
            tx_prop.setProperty("BindAllInterfaces", "false");
        }
        tx_prop.setProperty("McastSocketTTL", this.ttl);
        tx_prop.setProperty("LimitTransRate", this.rateLimitPolicy);
        tx_prop.setProperty("TransRateLimitKbps", this.transmissionRateLimit);
        if (this.networkingType.equalsIgnoreCase("EmulatedMulticast")) {
            tx_prop.setProperty("DisableMulticast", "true");
        } else {
            tx_prop.setProperty("DisableMulticast", "false");
        }
        tx_prop.setProperty("DisableUnicast", "false");
        if (this.unicastTransport.equalsIgnoreCase("TCPChannel")) {
            tx_prop.setProperty("UseTcpChannel", "true");
        } else {
            tx_prop.setProperty("UseTcpChannel", "false");
        }
        if (this.multicastTransport.equalsIgnoreCase("UDPEncapsulatedPGM")) {
            tx_prop.setProperty("ProtocolType", "PGM/UDP");
        }
        if (this.multicastTransport.equalsIgnoreCase("PGM")) {
            tx_prop.setProperty("ProtocolType", "PGM/IP");
        }
        tx_prop.setProperty("HeartbeatTimeoutSec", this.heartbeatTimeoutSec);
        tx_prop.setProperty("HeartbeatIntervalMillis", this.heartbeatInterval);
        size = 3 * this.mtHistory / 4;
        tx_prop.setProperty("MinimalHistoryKBytes", "" + size);
        tx_prop.setProperty("MaximalPendingQueueKBytes", "" + this.utPending);
        if (this.networkingType.equalsIgnoreCase("RealMulticast")) {
            tx_prop.setProperty("EnableAdminModule", "true");
        } else {
            tx_prop.setProperty("EnableAdminModule", "false");
        }
        if (this.tcpKeepAlive.equalsIgnoreCase("true")) {
            tx_prop.setProperty("TcpKeepAlive", "true");
        }
        tx_prop.setProperty("TcpSocketBufferSizeKbytes", this.unicastSocketTransmissionBufferSize);
        if (this.unicastServerSocketPort != null) {
            tx_prop.setProperty("ServerSocketPort", this.unicastServerSocketPort);
        }
        tx_prop.setProperty("ClockUpdateIntervalMilli", this.clockUpdateIntervalMilli);
        tx_prop.setProperty("AdminMulticastGroup", "239.39.39.39");
        tx_prop.setProperty("CollectStats", "true");
        tx_prop.setProperty("StatisticsPeriodSec", "10");
        tx_prop.setProperty("NackAccumulationTimeMillis", "300");
    }
}

