/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.htmt.rmm;

import com.ibm.htmt.rmm.Config;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.receiver.RMReceiver;
import com.ibm.rmm.transmitter.RMTransmitter;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmAddressIf;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class RMM {
    private static final String moduleName = "RMM_API";
    public RMTransmitter rMT;
    public RMReceiver rMR;
    private MyRmRec myr;
    private MyRmTr myt;
    private RmmAddress myRmmAddr;

    public static synchronized RMM getInstance() {
        try {
            RMM instance = new RMM();
            instance.myt = instance.new MyRmTr();
            MTransmitter mt = MTransmitter.getInstance();
            instance.myt.setMTr(mt);
            if (mt.config.enableAdmin) {
                instance.myt.setAdmin(AdminClient.getInstance(mt));
            }
            instance.rMT = instance.myt;
            instance.myRmmAddr = (RmmAddress)instance.rMT.getRmmAddress();
            instance.myr = instance.new MyRmRec();
            instance.myr.setMRec(MReceiver.getInstance(instance.myRmmAddr, mt.taskMan));
            if (instance.myr.getMRec().config.enableAdmin) {
                instance.myr.setAdmin(AdminClient.getInstance(instance.myr.getMRec()));
            }
            instance.rMR = instance.myr;
            return instance;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static synchronized RMM getInstance(Properties tr_config_props, Properties rec_config_props, int log_level, int debug_level, LogEventListener listener) {
        return RMM.getInstance(tr_config_props, rec_config_props, null, log_level, debug_level, listener);
    }

    public static synchronized RMM getInstance(Properties tr_config_props, Properties rec_config_props, Map config_map, int log_level, int debug_level, LogEventListener listener) {
        try {
            RMM instance = new RMM();
            instance.myt = instance.new MyRmTr();
            MTransmitter mt = MTransmitter.getInstance(tr_config_props, config_map, log_level, debug_level, listener);
            instance.myt.setMTr(mt);
            if (mt.config.enableAdmin) {
                instance.myt.setAdmin(AdminClient.getInstance(mt));
            }
            instance.rMT = instance.myt;
            instance.myRmmAddr = (RmmAddress)instance.rMT.getRmmAddress();
            if (rec_config_props.getProperty("ServerSocketPort") != null) {
                instance.myRmmAddr.closeUnicastSockets();
            }
            instance.myr = instance.new MyRmRec();
            MReceiver mr = MReceiver.getInstance(instance.myRmmAddr, mt.taskMan, rec_config_props, config_map, log_level, debug_level, listener);
            instance.myr.setMRec(mr);
            if (instance.myr.getMRec().config.enableAdmin) {
                instance.myr.setAdmin(AdminClient.getInstance(instance.myr.getMRec()));
            }
            instance.rMR = instance.myr;
            mt.setMReceiverStack(mr);
            mr.setMTransmitterStack(mt);
            return instance;
        }
        catch (Exception ex) {
            listener.onLogEvent(400, new Object[]{"RMM Init failed"}, ex, moduleName);
            return null;
        }
    }

    public RmmAddressIf getRmmAddress() {
        return this.myRmmAddr;
    }

    public static synchronized RMM getInstance(Properties rmm_config_props, Map rmm_config_map, int log_level, int debug_level, LogEventListener listener) {
        if (listener == null) {
            return null;
        }
        listener.onLogEvent(0, new Object[]{"Start up time: " + new Date()}, null, moduleName);
        listener.onLogEvent(0, new Object[]{"RMM Version: 1.9.8.19 - 16/03/09"}, null, moduleName);
        listener.onLogEvent(0, new Object[]{"OS Name: " + System.getProperty("os.name")}, null, moduleName);
        listener.onLogEvent(0, new Object[]{"RMM configuration: \n" + rmm_config_props}, null, moduleName);
        listener.onLogEvent(0, new Object[]{"Log level: " + log_level}, null, moduleName);
        Properties tx_config = new Properties();
        Properties rx_config = new Properties();
        Config config2 = new Config(listener);
        if (!config2.parseConfigParams(rmm_config_props, tx_config, rx_config)) {
            return null;
        }
        return RMM.getInstance(tx_config, rx_config, rmm_config_map, log_level, debug_level, listener);
    }

    public void setLogDebugLevels(int log_level, int debug_level) {
        if (this.myt != null) {
            this.myt.setLogDebugLevels(log_level, debug_level);
        }
        if (this.myr != null) {
            this.myr.setLogDebugLevels(log_level, debug_level);
        }
    }

    public class MyRmTr
    extends RMTransmitter {
        MTransmitter getMTr() {
            return this.mrmTransmitter;
        }

        void setMTr(MTransmitter mt) {
            this.mrmTransmitter = mt;
        }

        void setAdmin(AdminClient ad) {
            this.adminClient = ad;
        }
    }

    public class MyRmRec
    extends RMReceiver {
        MReceiver getMRec() {
            return this.mReceiver;
        }

        void setMRec(MReceiver mr) {
            this.mReceiver = mr;
        }

        void setAdmin(AdminClient ad) {
            this.adminClient = ad;
        }
    }
}

