/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUListResourceBundle;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.util.ULocale;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ICULocaleData {
    private static final String ICU_PACKAGE = "com.ibm.icu.impl.data";
    static final String LOCALE_ELEMENTS = "LocaleElements";
    private static final boolean DEBUG = ICUDebug.enabled("localedata");
    private static SoftReference GET_AVAILABLE_CACHE;
    private static SoftReference BUNDLE_CACHE;

    public static ResourceBundle getLocaleElements(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, LOCALE_ELEMENTS, locale.getBaseName());
    }

    public static ResourceBundle getLocaleElements(String localeName) {
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, LOCALE_ELEMENTS, localeName);
    }

    public static ResourceBundle getResourceBundle(String bundleName, String localeName) {
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, bundleName, localeName);
    }

    public static ResourceBundle getResourceBundle(String bundleName, ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, bundleName, locale.getBaseName());
    }

    public static ResourceBundle getResourceBundle(String packageName, String bundleName, String localeName) {
        try {
            String path = packageName + "." + bundleName;
            if (DEBUG) {
                System.out.println("calling instantiate: " + path + "_" + localeName);
            }
            return ICULocaleData.instantiate(path, localeName);
        }
        catch (MissingResourceException e2) {
            if (DEBUG) {
                System.out.println(bundleName + "_" + localeName + " not found in " + packageName);
            }
            throw e2;
        }
    }

    public static ResourceBundle getResourceBundle(String[] packages, String bundleName, String localeName) {
        ResourceBundle r = null;
        for (int i = 0; r == null && i < packages.length; ++i) {
            r = ICULocaleData.getResourceBundle(packages[i], bundleName, localeName);
        }
        return r;
    }

    public static ResourceBundle loadResourceBundle(String bundleName, ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return ICULocaleData.loadResourceBundle(bundleName, locale.getBaseName());
    }

    public static ResourceBundle loadResourceBundle(String bundleName, String localeName) {
        block7: {
            if (localeName != null && localeName.length() > 0) {
                bundleName = bundleName + "_" + localeName;
            }
            String name2 = "com.ibm.icu.impl.data." + bundleName;
            try {
                if (name2.indexOf("_zh_") == -1) {
                    Class<?> rbclass = Class.forName(name2);
                    ResourceBundle rb = (ResourceBundle)rbclass.newInstance();
                    return rb;
                }
            }
            catch (ClassNotFoundException e2) {
                if (DEBUG) {
                    System.out.println(name2 + " not found");
                }
            }
            catch (Exception e3) {
                if (!DEBUG) break block7;
                e3.printStackTrace();
                System.out.println(e3.getMessage());
            }
        }
        if (DEBUG) {
            System.out.println(bundleName + " not found.");
        }
        return null;
    }

    private static ResourceBundle loadFromCache(String key) {
        Map m;
        if (BUNDLE_CACHE != null && (m = (Map)BUNDLE_CACHE.get()) != null) {
            return (ResourceBundle)m.get(key);
        }
        return null;
    }

    private static void addToCache(String key, ResourceBundle b) {
        HashMap<String, ResourceBundle> m = null;
        if (BUNDLE_CACHE != null) {
            m = (HashMap<String, ResourceBundle>)BUNDLE_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<String, ResourceBundle>();
            BUNDLE_CACHE = new SoftReference(m);
        }
        m.put(key, b);
    }

    private static ResourceBundle instantiate(String name2) {
        ResourceBundle b = ICULocaleData.loadFromCache(name2);
        if (b == null) {
            ResourceBundle parent2 = null;
            int i = name2.lastIndexOf(95);
            Locale rootLocale = new Locale("", "", "");
            if (i != -1) {
                parent2 = ICULocaleData.instantiate(name2.substring(0, i));
            }
            try {
                Class<?> cls;
                Locale locale = rootLocale;
                i = name2.indexOf(95);
                if (i != -1) {
                    locale = LocaleUtility.getLocaleFromName(name2.substring(i + 1));
                } else {
                    i = name2.length();
                }
                ClassLoader cl = ICULocaleData.class.getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if (ICUListResourceBundle.class.isAssignableFrom(cls = cl.loadClass(name2))) {
                    ICUListResourceBundle bx = (ICUListResourceBundle)cls.newInstance();
                    if (parent2 != null) {
                        bx.setParentX(parent2);
                    }
                    bx.icuLocale = locale;
                    b = bx;
                } else {
                    b = ResourceBundle.getBundle(name2.substring(0, i), locale);
                }
                ICULocaleData.addToCache(name2, b);
            }
            catch (ClassNotFoundException e2) {
                int j = name2.indexOf(95);
                int k = name2.lastIndexOf(95);
                if (k == j && j != -1) {
                    String locName = name2.substring(j + 1, name2.length());
                    String defaultName = ULocale.getDefault().toString();
                    if (!locName.equals(rootLocale.toString()) && defaultName.indexOf(locName) == -1) {
                        String bundle = name2.substring(0, j);
                        parent2 = ICULocaleData.instantiate(bundle + "_" + defaultName);
                    }
                }
                b = parent2;
            }
            catch (Exception e3) {
                System.out.println("failure");
                System.out.println(e3);
            }
        }
        if (b == null) {
            throw new MissingResourceException("Could not load data " + name2, "", "");
        }
        return b;
    }

    private static synchronized ResourceBundle instantiate(String name2, String localeName) {
        if (localeName.length() != 0) {
            name2 = name2 + "_" + localeName;
        }
        return ICULocaleData.instantiate(name2);
    }

    private static Set createLocaleNameSet(String bundleName) {
        try {
            ResourceBundle index = ICULocaleData.getResourceBundle(bundleName, "index");
            Object[][] localeStrings = (Object[][])index.getObject("InstalledLocales");
            String[] localeNames = new String[localeStrings.length];
            for (int i = 0; i < localeNames.length; ++i) {
                localeNames[i] = LocaleUtility.getLocaleFromName((String)localeStrings[i][0]).toString();
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(localeNames));
            return Collections.unmodifiableSet(set);
        }
        catch (MissingResourceException e2) {
            if (DEBUG) {
                System.out.println("couldn't find index for bundleName: " + bundleName);
            }
            Thread.dumpStack();
            return Collections.EMPTY_SET;
        }
    }
}

