/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.TimeZoneAdapter;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import sun.util.calendar.ZoneInfo;

public class JDKTimeZone
extends TimeZone {
    private static final long serialVersionUID = -3724907649889455280L;
    protected transient java.util.TimeZone zone;

    public static TimeZone wrap(java.util.TimeZone tz) {
        if (tz instanceof TimeZoneAdapter) {
            return ((TimeZoneAdapter)tz).unwrap();
        }
        if (tz instanceof java.util.SimpleTimeZone) {
            return new SimpleTimeZone((java.util.SimpleTimeZone)tz);
        }
        return new JDKTimeZone(tz);
    }

    public java.util.TimeZone unwrap() {
        return this.zone;
    }

    protected JDKTimeZone(java.util.TimeZone tz) {
        this.zone = tz;
        super.setID(this.zone.getID());
    }

    public void setID(String ID2) {
        super.setID(ID2);
        this.zone.setID(ID2);
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        return this.unwrap().getOffset(era, year, month, day, dayOfWeek, milliseconds);
    }

    public void getOffset(long date, boolean local, int[] offsets) {
        if (System.getSecurityManager() == null) {
            try {
                if (this.zone instanceof ZoneInfo) {
                    ((ZoneInfo)this.zone).getOffsets(date, offsets);
                    if (local) {
                        ((ZoneInfo)this.zone).getOffsets(date -= (long)(offsets[0] + offsets[1]), offsets);
                    }
                    return;
                }
            }
            catch (SecurityException ex) {
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        super.getOffset(date, local, offsets);
    }

    public void setRawOffset(int offsetMillis) {
        this.unwrap().setRawOffset(offsetMillis);
    }

    public int getRawOffset() {
        return this.unwrap().getRawOffset();
    }

    public boolean useDaylightTime() {
        return this.unwrap().useDaylightTime();
    }

    public boolean inDaylightTime(Date date) {
        return this.unwrap().inDaylightTime(date);
    }

    public boolean hasSameRules(TimeZone other) {
        if (other == null) {
            return false;
        }
        if (other instanceof JDKTimeZone) {
            return this.zone.hasSameRules(((JDKTimeZone)other).zone);
        }
        return super.hasSameRules(other);
    }

    public Object clone() {
        return JDKTimeZone.wrap((java.util.TimeZone)this.zone.clone());
    }

    public synchronized int hashCode() {
        return this.unwrap().hashCode();
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            if (System.getSecurityManager() == null) {
                try {
                    Object[] args = new Object[]{};
                    Class[] argtypes = new Class[]{};
                    Method m = this.zone.getClass().getMethod("getDSTSavings", argtypes);
                    int result = (Integer)m.invoke((Object)this.zone, args);
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 3600000;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        try {
            return obj != null && this.unwrap().equals(((JDKTimeZone)obj).unwrap());
        }
        catch (ClassCastException e2) {
            return false;
        }
    }

    public String toString() {
        return "JDKTimeZone: " + this.unwrap().toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.zone.getID());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String id = (String)in.readObject();
        this.zone = java.util.TimeZone.getTimeZone(id);
    }
}

