/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncChannelFuture;
import com.ibm.io.async.AsyncChannelGroup;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncFuture;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.io.async.LookupTable;
import com.ibm.io.async.ResultHandler;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class AbstractAsyncChannel
implements Channel {
    private static final TraceComponent tc = Tr.register(AbstractAsyncChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private static IAsyncProvider provider = AsyncLibrary.getInstance();
    private boolean closed = false;
    private static LookupTable channelTable = new LookupTable(2000);
    protected final int channelIndex;
    protected AsyncFuture readFuture = new AsyncFuture(this);
    protected AsyncFuture writeFuture = new AsyncFuture(this);
    static final int defaultBufferCount = 10;
    protected CompletionKey readIOCB = null;
    protected CompletionKey writeIOCB = null;
    protected VirtualConnection channelVCI = null;
    protected static final int READ_FUTURE_INDEX = -1;
    protected static final long READ_INDEX = -4294967296L;
    protected static final int WRITE_FUTURE_INDEX = -2;
    protected static final long WRITE_INDEX = -8589934592L;
    protected static final int SYNC_READ_FUTURE_INDEX = -3;
    protected static final long SYNC_READ_INDEX = -12884901888L;
    protected static final int SYNC_WRITE_FUTURE_INDEX = -4;
    protected static final long SYNC_WRITE_INDEX = -17179869184L;
    private static Field addrField;
    long channelIdentifier;
    protected ResultHandler resultHandler;
    protected AsyncChannelGroup asyncChannelGroup;

    static long getBufAddress(ByteBuffer byteBuffer) {
        long l;
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Only direct buffers allowed");
        }
        try {
            l = addrField.getLong(byteBuffer);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting async provider instance, exception: " + illegalAccessException.getMessage());
            }
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.io.async.AbstractAsyncChannel", (String)"149");
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        return l;
    }

    protected AbstractAsyncChannel(AsyncChannelGroup asyncChannelGroup) {
        this.channelIndex = channelTable.addElement(this);
        this.asyncChannelGroup = asyncChannelGroup;
        this.resultHandler = asyncChannelGroup.getResultHandler();
        this.readFuture.setRead(true);
        this.writeFuture.setRead(false);
    }

    public static AbstractAsyncChannel getChannelFromIndex(int n) {
        return (AbstractAsyncChannel)channelTable.lookupElement(n);
    }

    public AsyncFuture getFutureFromIndex(int n) {
        if (n == -1 || n == -3) {
            return this.readFuture;
        }
        if (n == -2 || n == -4) {
            return this.writeFuture;
        }
        return null;
    }

    void cancel(AsyncChannelFuture asyncChannelFuture, Exception exception) throws ClosedChannelException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel");
        }
        if (!this.isOpen()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Cancel request on closed connection");
            }
            asyncChannelFuture.setCancelInProgress(0);
            throw new ClosedChannelException();
        }
        if (asyncChannelFuture.isCompleted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Cancel request on completed future");
            }
            asyncChannelFuture.setCancelInProgress(0);
            return;
        }
        long l = ((AsyncFuture)asyncChannelFuture).isRead() ? this.readIOCB.getCallIdentifier() : this.writeIOCB.getCallIdentifier();
        int n = provider.cancel2(this.channelIdentifier, l);
        if (n == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Cancel Successful, resetting CancelInProgress state to 0");
            }
            asyncChannelFuture.setCancelInProgress(0);
            asyncChannelFuture.completed(exception);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Cancel could not be completed");
            }
            asyncChannelFuture.setCancelInProgress(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        channelTable.removeElement(this.channelIndex);
        this.closed = true;
    }

    protected AsyncChannelGroup getAsyncChannelGroup() {
        return this.asyncChannelGroup;
    }

    final boolean isCapable(int n) {
        return provider.hasCapability(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAsyncFuture multiIO(ByteBuffer[] byteBufferArray, long l, boolean bl, boolean bl2, long l2, boolean bl3, VirtualConnection virtualConnection, boolean bl4) {
        AsyncFuture asyncFuture;
        block32: {
            int n;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "multiIO(.," + l + "," + bl + "," + bl2 + "," + l2 + "," + bl3 + ",.," + bl4);
            }
            if (byteBufferArray == null) {
                throw new IllegalArgumentException();
            }
            asyncFuture = null;
            CompletionKey completionKey = null;
            this.channelVCI = virtualConnection;
            if (bl) {
                asyncFuture = this.readFuture;
                completionKey = this.readIOCB;
                if (bl4) {
                    completionKey.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFF00000000L);
                } else {
                    completionKey.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFD00000000L);
                }
            } else {
                asyncFuture = this.writeFuture;
                completionKey = this.writeIOCB;
                if (bl4) {
                    completionKey.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFE00000000L);
                } else {
                    completionKey.setCallIdentifier((long)this.channelIndex | 0xFFFFFFFC00000000L);
                }
            }
            asyncFuture.resetFuture();
            asyncFuture.setBuffers(byteBufferArray);
            if (!this.isOpen()) {
                asyncFuture.completed(new ClosedChannelException());
                return asyncFuture;
            }
            int n2 = 0;
            for (n = 0; n < byteBufferArray.length && byteBufferArray[n] != null; ++n) {
                ++n2;
            }
            if (n2 == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "no buffers passed on I/O call");
                }
                AsyncException asyncException = new AsyncException("no buffers passed on I/O call");
                FFDCFilter.processException((Throwable)asyncException, (String)"com.ibm.io.async.AbstractAsyncChannel", (String)"384", (Object)this);
                asyncFuture.completed(asyncException);
                return asyncFuture;
            }
            if (n2 > completionKey.getBufferCount()) {
                completionKey.expandBuffers(n2);
            }
            for (n = 0; n < n2; ++n) {
                completionKey.setBuffer(AbstractAsyncChannel.getBufAddress(byteBufferArray[n]) + (long)byteBufferArray[n].position(), byteBufferArray[n].remaining(), n);
            }
            n = 0;
            completionKey.setBytesAffected(0);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Requesting IO from native for  call id: " + Long.toHexString(completionKey.getCallIdentifier()) + " channel id(hex): " + Long.toHexString(completionKey.getChannelIdentifier()) + " channel id(dec): " + completionKey.getChannelIdentifier());
                }
                if ((n = (int)(provider.multiIO3(completionKey.getAddress(), l, n2, bl, bl2, l2, bl3) ? 1 : 0)) != 0) {
                    if (virtualConnection.isInputStateTrackingOperational()) {
                        Object object = virtualConnection.getLockObject();
                        synchronized (object) {
                            if (bl4) {
                                if (bl) {
                                    virtualConnection.setReadStatetoCloseAllowedNoSync();
                                } else {
                                    virtualConnection.setWriteStatetoCloseAllowedNoSync();
                                }
                            }
                            if (virtualConnection.getCloseWaiting()) {
                                virtualConnection.getLockObject().notify();
                            }
                        }
                    }
                    this.resultHandler.eventPending();
                    break block32;
                }
                int n3 = completionKey.getReturnCode();
                if (n3 == 0) {
                    if (completionKey.getBytesAffected() == 0 && l2 > 0L) {
                        IOException iOException = new IOException("Async IO operation failed, internal error");
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.io.async.AbstractAsyncChannel", (String)"453");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error processing multiIO request, exception: " + iOException.getMessage());
                        }
                        asyncFuture.completed(iOException);
                    } else {
                        asyncFuture.completed(completionKey.getBytesAffected());
                    }
                } else {
                    String string = AsyncLibrary.getErrorMessage(n3);
                    asyncFuture.completed(new IOException("Async IO operation failed, reason: " + string));
                }
            }
            catch (AsyncException asyncException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error processing multiIO request, exception: " + asyncException.getMessage());
                }
                FFDCFilter.processException((Throwable)asyncException, (String)"com.ibm.io.async.AbstractAsyncChannel", (String)"420", (Object)this);
                asyncFuture.completed(asyncException);
            }
        }
        return asyncFuture;
    }

    static {
        StartPrivilegedThread startPrivilegedThread = new StartPrivilegedThread();
        AccessController.doPrivileged(startPrivilegedThread);
    }

    static class StartPrivilegedThread
    implements PrivilegedAction {
        public Object run() {
            try {
                Class<?> clazz = Class.forName("java.nio.Buffer");
                addrField = clazz.getDeclaredField("address");
                addrField.setAccessible(true);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return null;
        }
    }
}

