/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import com.ibm.nws.ffdc.FFDCFilter;

abstract class AbstractAsyncFuture
implements IAbstractAsyncFuture {
    private static final TraceComponent tc;
    protected final AbstractAsyncChannel channel;
    protected volatile Exception exception = null;
    protected volatile boolean completed = false;
    protected volatile boolean fullyCompleted = false;
    protected volatile int cancelInProgress = 0;
    protected volatile int reuseCount = 0;
    protected final Object completedSemaphore = new Object();
    protected ICompletionListener firstListener = null;
    protected Object firstListenerState = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractAsyncFuture(AbstractAsyncChannel abstractAsyncChannel) {
        this.channel = abstractAsyncChannel;
    }

    public int getReuseCount() {
        return this.reuseCount;
    }

    public Object getCompletedSemaphore() {
        return this.completedSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completed(Exception exception) {
        boolean bl = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "completed", exception.getMessage());
        }
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (this.completed || !this.channel.isOpen()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Future completed after already cancelled or socket was closed");
                }
                return;
            }
            this.completed = true;
            if (this.getTimeoutWorkItem() != null) {
                this.getTimeoutWorkItem().state = 2L;
            }
            this.exception = exception;
            if (this.firstListener == null) {
                bl = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "doing notify for future " + this);
                }
                this.completedSemaphore.notifyAll();
            }
        }
        if (bl) {
            this.fireCompletionActions();
        }
    }

    protected abstract void fireCompletionActions();

    protected void invokeCallback(ICompletionListener iCompletionListener, AbstractAsyncFuture abstractAsyncFuture, Object object) {
        try {
            iCompletionListener.futureCompleted(abstractAsyncFuture, object);
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error invoking callback, exception: " + throwable + " : " + throwable.getMessage());
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.io.async.AbstractAsyncFuture", (String)"182", (Object)this);
        }
    }

    public abstract void addCompletionListener(ICompletionListener var1, Object var2);

    public abstract void cancel(Exception var1);

    public boolean isCompleted() {
        return this.completed;
    }

    public void setFullyCompleted(boolean bl) {
        this.fullyCompleted = bl;
    }

    public void setCancelInProgress(int n) {
        this.cancelInProgress = n;
    }

    public int getCancelInProgress() {
        return this.cancelInProgress;
    }

    public void waitForCompletion() throws InterruptedException {
        block3: {
            try {
                this.waitForCompletion(0L);
            }
            catch (AsyncTimeoutException asyncTimeoutException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected timeout on blocking wait call, exception: " + asyncTimeoutException.getMessage());
                }
                FFDCFilter.processException((Throwable)asyncTimeoutException, (String)"com.ibm.io.async.AbstractAsyncFuture", (String)"268", (Object)this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(long l) throws AsyncTimeoutException, InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForCompletion", new Long(l));
        }
        if (this.fullyCompleted) {
            return;
        }
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.channel.resultHandler.incrementSyncBlockedThreads();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "waiting for completion notification for future: " + this);
            }
            this.completedSemaphore.wait(l);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "done waiting for completion notification for future: " + this);
            }
            this.channel.resultHandler.decrementSyncBlockedThreads();
        }
        if (this.fullyCompleted) {
            return;
        }
        object = this.completedSemaphore;
        synchronized (object) {
            if (!this.completed) {
                this.completed = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sync operation timed out");
                }
                throw new AsyncTimeoutException();
            }
            return;
        }
    }

    public void resetFuture() {
        ++this.reuseCount;
        if (this.getTimeoutWorkItem() != null) {
            this.getTimeoutWorkItem().state = 2L;
        }
        this.setTimeoutWorkItem(null);
        this.completed = false;
        this.fullyCompleted = false;
        this.exception = null;
        this.firstListener = null;
        this.firstListenerState = null;
    }

    static {
        $assertionsDisabled = !AbstractAsyncFuture.class.desiredAssertionStatus();
        tc = Tr.register(AbstractAsyncFuture.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    }
}

