/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AbstractAsyncFuture;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.ICompletionListener;
import com.ibm.io.async.TimerWorkItem;
import java.io.IOException;

abstract class AsyncChannelFuture
extends AbstractAsyncFuture {
    private static final TraceComponent tc = Tr.register(AsyncChannelFuture.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected TimerWorkItem timeoutTracker = null;

    protected AsyncChannelFuture(AbstractAsyncChannel abstractAsyncChannel) {
        super(abstractAsyncChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(ICompletionListener iCompletionListener, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addCompletionListener, listener " + iCompletionListener);
        }
        boolean bl = true;
        if (!this.fullyCompleted) {
            Object object2 = this.completedSemaphore;
            synchronized (object2) {
                if (!this.completed) {
                    bl = false;
                    this.firstListener = iCompletionListener;
                    this.firstListenerState = object;
                }
            }
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "request already complete - notifying listener on pooled thread");
            }
            this.notifyListenerOnPooledThread(iCompletionListener, object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addCompletionListener, listener " + iCompletionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Exception exception) {
        if (this.channel == null) {
            return;
        }
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.channel.cancel(this, exception);
                }
                catch (Exception exception2) {}
            } else {
                if (this.channel.readFuture != null) {
                    this.channel.readFuture.setCancelInProgress(0);
                }
                if (this.channel.writeFuture != null) {
                    this.channel.writeFuture.setCancelInProgress(0);
                }
            }
        }
    }

    protected void fireCompletionActions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "fireCompletionActions");
        }
        ICompletionListener iCompletionListener = null;
        if (this.firstListener != null) {
            iCompletionListener = this.firstListener;
            this.firstListener = null;
            if (this.exception != null && this.exception instanceof AsyncTimeoutException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "timeout exception - notifying listener on pooled thread for channelId: " + this.channel.channelIdentifier);
                }
                this.notifyListenerOnPooledThread(iCompletionListener, this.firstListenerState);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "invoking callback for channelId: " + this.channel.channelIdentifier);
                }
                this.invokeCallback(iCompletionListener, this, this.firstListenerState);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "no listener found for event, future: " + this);
        }
    }

    protected void throwException() throws InterruptedException, IOException {
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof InterruptedException) {
            throw (InterruptedException)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        throw new RuntimeException(this.exception);
    }

    private void notifyListenerOnPooledThread(final ICompletionListener iCompletionListener, final Object object) {
        final AsyncChannelFuture asyncChannelFuture = this;
        this.channel.getAsyncChannelGroup().getThreadPool().execute(new Runnable(){

            public void run() {
                AsyncChannelFuture.this.invokeCallback(iCompletionListener, asyncChannelFuture, object);
            }
        }, 3);
    }

    public void setTimeoutWorkItem(TimerWorkItem timerWorkItem) {
        this.timeoutTracker = timerWorkItem;
    }

    public TimerWorkItem getTimeoutWorkItem() {
        return this.timeoutTracker;
    }
}

