/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncChannelFuture;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

final class AsyncFuture
extends AsyncChannelFuture
implements IAsyncFuture {
    private static final TraceComponent tc;
    private ByteBuffer[] buffers;
    protected volatile long byteCount = -1L;
    protected boolean isRead;
    protected WsByteBuffer jitBuffer = null;
    protected ByteBuffer[] jitBufferArray = new ByteBuffer[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    AsyncFuture(AbstractAsyncChannel abstractAsyncChannel) {
        super(abstractAsyncChannel);
    }

    void setBuffers(ByteBuffer[] byteBufferArray) {
        this.buffers = byteBufferArray;
    }

    void setJITBuffer(WsByteBuffer wsByteBuffer) {
        this.jitBuffer = wsByteBuffer;
        if (wsByteBuffer != null) {
            this.jitBufferArray[0] = wsByteBuffer.getWrappedByteBuffer();
            this.setBuffers(this.jitBufferArray);
        }
    }

    public WsByteBuffer getJITBuffer() {
        return this.jitBuffer;
    }

    protected void setRead(boolean bl) {
        this.isRead = bl;
    }

    protected boolean isRead() {
        return this.isRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completed(long l) {
        boolean bl = true;
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (this.completed || !this.channel.isOpen()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Future completed after already cancelled or socket was closed");
                }
                return;
            }
            this.completed = true;
            if (this.getTimeoutWorkItem() != null) {
                this.getTimeoutWorkItem().state = 2L;
            }
            this.byteCount = l;
            for (int i = 0; i < this.buffers.length; ++i) {
                int n = this.buffers[i].remaining();
                if (l > (long)n) {
                    this.buffers[i].position(this.buffers[i].limit());
                    l -= (long)n;
                    continue;
                }
                this.buffers[i].position(this.buffers[i].position() + (int)l);
                l = 0L;
                break;
            }
            if (this.firstListener == null) {
                bl = false;
                this.completedSemaphore.notifyAll();
            }
        }
        if (bl) {
            this.fireCompletionActions();
        }
    }

    public ByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public long readByteCount() {
        return this.byteCount;
    }

    public final long getByteCount() throws InterruptedException, IOException {
        try {
            return this.getByteCount(0L);
        }
        catch (AsyncTimeoutException asyncTimeoutException) {
            if (this.exception != null && this.exception instanceof AsyncTimeoutException) {
                throw (AsyncTimeoutException)this.exception;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected timeout during blocking getByteCount call, exception: " + this.exception.getMessage());
            }
            FFDCFilter.processException((Throwable)asyncTimeoutException, (String)"com.ibm.io.async.AsyncFuture", (String)"145", (Object)this);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0L;
        }
    }

    public long getByteCount(long l) throws InterruptedException, IOException {
        this.waitForCompletion(l);
        if (this.exception != null) {
            this.throwException();
        }
        return this.byteCount;
    }

    public void resetFuture() {
        super.resetFuture();
        this.setJITBuffer(null);
    }

    static {
        $assertionsDisabled = !AsyncFuture.class.desiredAssertionStatus();
        tc = Tr.register(AsyncFuture.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    }
}

