/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncProperties;
import com.ibm.io.async.CompletionKey;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.nws.ffdc.FFDCFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class AsyncLibrary
implements IAsyncProvider {
    private static final TraceComponent tc = Tr.register(AsyncLibrary.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private static final String LIBRARY_NAME = AsyncProperties.libraryName;
    static final int MAX_IDENTIFIERS = AsyncProperties.maxIdentifiers;
    private static int capabilities = 0;
    private static volatile IAsyncProvider instance = null;
    static LinkedList completionPorts = new LinkedList();
    static Object oneAtATime = new Object();
    static final int AIO_NOT_INITIALIZED = 0;
    static final int AIO_INITIALIZED = 1;
    static final int AIO_SHUTDOWN = 2;
    static volatile int aioInitialized = 0;

    protected static native int aio_cancel2(long var0, long var2) throws AsyncException;

    protected static native void aio_closeport2(long var0) throws AsyncException;

    protected static native long aio_dispose(long var0) throws AsyncException;

    protected static native boolean aio_getioev2(long var0, int var2, long var3) throws AsyncException;

    protected static native int aio_getioev3(long[] var0, int var1, int var2, long var3) throws AsyncException;

    protected static native int aio_init(int var0, Class var1) throws AsyncException;

    protected static native int aio_getErrorString(int var0, byte[] var1) throws AsyncException;

    protected static native long aio_prepare2(long var0, long var2) throws AsyncException;

    protected static native long aio_newCompletionPort() throws AsyncException;

    protected static native boolean aio_multiIO3(long var0, long var2, int var4, boolean var5, boolean var6, long var7, boolean var9) throws AsyncException;

    protected static native void aio_shutdown() throws AsyncException;

    protected static native void aio_initIOCB(long var0) throws AsyncException;

    protected static native void aio_termIOCB(long var0) throws AsyncException;

    private static void initialize() throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        capabilities = AsyncLibrary.aio_init(MAX_IDENTIFIERS, AsyncException.class);
        aioInitialized = 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", new Integer(capabilities));
        }
    }

    public static String getErrorMessage(int n) {
        byte[] byArray = new byte[255];
        int n2 = 0;
        String string = null;
        try {
            n2 = AsyncLibrary.aio_getErrorString(n, byArray);
        }
        catch (AsyncException asyncException) {
            string = "Unspecified error, error code: " + n;
        }
        if (n2 != 0) {
            string = new String(byArray, 0, n2);
        }
        if (string != null) {
            return "RC: " + n + "  " + string;
        }
        return "Error Return Code: " + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        Object object = oneAtATime;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "have lock");
            }
            if (aioInitialized == 1) {
                block9: {
                    aioInitialized = 2;
                    AsyncLibrary.closeAllCompletionPorts();
                    try {
                        AsyncLibrary.aio_shutdown();
                    }
                    catch (AsyncException asyncException) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "AsyncException occured while shutting down: " + asyncException.getMessage());
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "shutdown");
                }
            }
        }
    }

    public static IAsyncProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        try {
            return AsyncLibrary.createInstance();
        }
        catch (AsyncException asyncException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting async provider instance, exception: " + asyncException.getMessage());
            }
            FFDCFilter.processException((Throwable)asyncException, (String)"com.ibm.io.async.AsyncLibrary", (String)"331");
            return null;
        }
    }

    public static synchronized IAsyncProvider createInstance() throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createInstance");
        }
        if (instance == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "instance is null.  Instantiating new AsyncLibrary ");
            }
            instance = new AsyncLibrary();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "aioInitialized is: " + aioInitialized);
        }
        if (aioInitialized == 0 || aioInitialized == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "initializing AIO subsystem");
            }
            AsyncLibrary.initialize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createInstance");
        }
        return instance;
    }

    protected AsyncLibrary() throws AsyncException {
        StartPrivilegedThread3 startPrivilegedThread3 = new StartPrivilegedThread3();
        AsyncException asyncException = (AsyncException)AccessController.doPrivileged(startPrivilegedThread3);
        if (asyncException != null) {
            throw asyncException;
        }
        AsyncLibrary.initialize();
    }

    public boolean hasCapability(int n) {
        return (capabilities & n) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancel2(long l, long l2) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel2", new Object[]{new Long(l), new Long(l2)});
        }
        Object object = oneAtATime;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "have lock");
            }
            if (aioInitialized == 1) {
                try {
                    int n = AsyncLibrary.aio_cancel2(l, l2);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "cancel2");
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    if (aioInitialized == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught throwable after shutdown - ignoring");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught throwable:" + throwable);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "cancel2");
                    }
                    throw new AsyncException("Throwable caught from aio dll: aio_cancel2: " + throwable.getMessage());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel2");
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dispose(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose", new Long(l));
        }
        Object object = oneAtATime;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "have lock");
            }
            if (aioInitialized == 1) {
                try {
                    long l2 = AsyncLibrary.aio_dispose(l);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "dispose");
                    }
                    return l2;
                }
                catch (AsyncException asyncException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error disposing channel: " + l + ", error: " + asyncException.getMessage());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "dispose");
                    }
                    return 0L;
                }
                catch (Throwable throwable) {
                    if (aioInitialized == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught throwable after shutdown - ignoring");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught throwable:" + throwable);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "dispose");
                    }
                    throw new RuntimeException("Throwable caught from aio dll: aio_dispose: " + throwable.getMessage());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "dispose");
            }
            return l;
        }
    }

    public boolean getCompletionData2(long l, int n, long l2) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionData2", new Object[]{new Long(l)});
        }
        boolean bl = false;
        if (aioInitialized == 1) {
            bl = AsyncLibrary.aio_getioev2(l, n, l2);
            if (aioInitialized == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Shutdown after callout");
                }
                bl = false;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Shutdown before callout");
            }
            bl = false;
        }
        return bl;
    }

    public int getCompletionData3(long[] lArray, int n, int n2, long l) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompletionData3");
        }
        int n3 = 0;
        if (aioInitialized == 1) {
            n3 = AsyncLibrary.aio_getioev3(lArray, n, n2, l);
            if (aioInitialized == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Shutdown after callout");
                }
                n3 = 0;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Shutdown before callout");
            }
            n3 = 0;
        }
        return n3;
    }

    public long prepare2(long l, long l2) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare2", new Object[]{new Long(l), new Long(l2)});
        }
        return AsyncLibrary.aio_prepare2(l, l2);
    }

    public synchronized long getNewCompletionPort() throws AsyncException {
        Long l = new Long(AsyncLibrary.aio_newCompletionPort());
        completionPorts.add(l);
        return l;
    }

    public synchronized void closeCompletionPort(long l) {
        int n = completionPorts.size();
        for (int i = 0; i < n; ++i) {
            block3: {
                if ((Long)completionPorts.get(i) != l) continue;
                try {
                    AsyncLibrary.aio_closeport2(l);
                }
                catch (AsyncException asyncException) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Error closing completion port: " + l + ", error:" + asyncException.getMessage());
                }
            }
            completionPorts.remove(i);
            break;
        }
    }

    private static void closeAllCompletionPorts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeAllCompletionPorts");
        }
        block4: while (true) {
            try {
                while (true) {
                    Long l = (Long)completionPorts.removeFirst();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Closing completion port: " + l);
                    }
                    try {
                        AsyncLibrary.aio_closeport2(l);
                        continue block4;
                    }
                    catch (AsyncException asyncException) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Error closing completion port: " + l + ", error:" + asyncException.getMessage());
                        continue;
                    }
                    break;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeAllCompletionPorts");
                }
                return;
            }
        }
    }

    public boolean multiIO3(long l, long l2, int n, boolean bl, boolean bl2, long l3, boolean bl3) throws AsyncException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "multiIO3", new Object[]{new Long(l), new Long(l2), new Integer(n)});
        }
        return AsyncLibrary.aio_multiIO3(l, l2, n, bl, bl2, l3, bl3);
    }

    public void initializeIOCB(CompletionKey completionKey) throws AsyncException {
        AsyncLibrary.aio_initIOCB(completionKey.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateIOCB(CompletionKey completionKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateIOCB");
        }
        Object object = oneAtATime;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "have lock");
            }
            if (aioInitialized == 1) {
                try {
                    AsyncLibrary.aio_termIOCB(completionKey.getAddress());
                }
                catch (AsyncException asyncException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error occured while terminating IOCB" + asyncException.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (aioInitialized == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught throwable after shutdown - ignoring");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught throwable: " + throwable);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "terminateIOCB");
                    }
                    throw new RuntimeException("Throwable caught from aio dll: aio_termIOCB: " + throwable.getMessage());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateIOCB");
        }
    }

    class StartPrivilegedThread3
    implements PrivilegedAction {
        public Object run() {
            try {
                if (System.getProperty("os.name").equals("OS/400")) {
                    System.load(LIBRARY_NAME);
                } else {
                    System.loadLibrary(LIBRARY_NAME);
                }
            }
            catch (Throwable throwable) {
                return new AsyncException("could not load native AIO support library. Exception " + throwable.getMessage());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "loaded native AIO library: " + LIBRARY_NAME);
            }
            return null;
        }
    }
}

